/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.offset;

import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.BrokerPathConfigHelper;
import org.apache.rocketmq.broker.offset.ConsumerOrderInfoLockManager;
import org.apache.rocketmq.common.ConfigManager;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;
import org.apache.rocketmq.remoting.protocol.header.ExtraInfoUtil;

public class ConsumerOrderInfoManager
extends ConfigManager {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqBroker");
    private static final String TOPIC_GROUP_SEPARATOR = "@";
    private static final long CLEAN_SPAN_FROM_LAST = 86400000L;
    private ConcurrentHashMap<String, ConcurrentHashMap<Integer, OrderInfo>> table = new ConcurrentHashMap(128);
    private transient ConsumerOrderInfoLockManager consumerOrderInfoLockManager;
    private transient BrokerController brokerController;

    public ConsumerOrderInfoManager() {
    }

    public ConsumerOrderInfoManager(BrokerController brokerController) {
        this.brokerController = brokerController;
        this.consumerOrderInfoLockManager = new ConsumerOrderInfoLockManager(brokerController);
    }

    public ConcurrentHashMap<String, ConcurrentHashMap<Integer, OrderInfo>> getTable() {
        return this.table;
    }

    public void setTable(ConcurrentHashMap<String, ConcurrentHashMap<Integer, OrderInfo>> table) {
        this.table = table;
    }

    protected static String buildKey(String topic, String group) {
        return topic + TOPIC_GROUP_SEPARATOR + group;
    }

    protected static String[] decodeKey(String key) {
        return key.split(TOPIC_GROUP_SEPARATOR);
    }

    private void updateLockFreeTimestamp(String topic, String group, int queueId, OrderInfo orderInfo) {
        if (this.consumerOrderInfoLockManager != null) {
            this.consumerOrderInfoLockManager.updateLockFreeTimestamp(topic, group, queueId, orderInfo);
        }
    }

    public void update(String attemptId, boolean isRetry, String topic, String group, int queueId, long popTime, long invisibleTime, List<Long> msgQueueOffsetList, StringBuilder orderInfoBuilder) {
        OrderInfo orderInfo;
        ConcurrentHashMap<Integer, OrderInfo> old;
        String key = ConsumerOrderInfoManager.buildKey(topic, group);
        ConcurrentHashMap<Integer, OrderInfo> qs = this.table.get(key);
        if (qs == null && (old = this.table.putIfAbsent(key, qs = new ConcurrentHashMap(16))) != null) {
            qs = old;
        }
        if ((orderInfo = qs.get(queueId)) != null) {
            OrderInfo newOrderInfo = new OrderInfo(attemptId, popTime, invisibleTime, msgQueueOffsetList, System.currentTimeMillis(), 0L);
            newOrderInfo.mergeOffsetConsumedCount(orderInfo.attemptId, orderInfo.offsetList, orderInfo.offsetConsumedCount);
            orderInfo = newOrderInfo;
        } else {
            orderInfo = new OrderInfo(attemptId, popTime, invisibleTime, msgQueueOffsetList, System.currentTimeMillis(), 0L);
        }
        qs.put(queueId, orderInfo);
        Map offsetConsumedCount = orderInfo.offsetConsumedCount;
        int minConsumedTimes = Integer.MAX_VALUE;
        if (offsetConsumedCount != null) {
            Set offsetSet = offsetConsumedCount.keySet();
            for (Long offset : offsetSet) {
                Integer consumedTimes = offsetConsumedCount.getOrDefault(offset, 0);
                ExtraInfoUtil.buildQueueOffsetOrderCountInfo((StringBuilder)orderInfoBuilder, (String)topic, (long)queueId, (long)offset, (int)consumedTimes);
                minConsumedTimes = Math.min(minConsumedTimes, consumedTimes);
            }
            if (offsetConsumedCount.size() != orderInfo.offsetList.size()) {
                minConsumedTimes = 0;
            }
        } else {
            minConsumedTimes = 0;
        }
        ExtraInfoUtil.buildQueueIdOrderCountInfo((StringBuilder)orderInfoBuilder, (String)topic, (int)queueId, (int)minConsumedTimes);
        this.updateLockFreeTimestamp(topic, group, queueId, orderInfo);
    }

    public boolean checkBlock(String attemptId, String topic, String group, int queueId, long invisibleTime) {
        OrderInfo orderInfo;
        ConcurrentHashMap<Integer, OrderInfo> old;
        String key = ConsumerOrderInfoManager.buildKey(topic, group);
        ConcurrentHashMap<Integer, OrderInfo> qs = this.table.get(key);
        if (qs == null && (old = this.table.putIfAbsent(key, qs = new ConcurrentHashMap(16))) != null) {
            qs = old;
        }
        if ((orderInfo = qs.get(queueId)) == null) {
            return false;
        }
        return orderInfo.needBlock(attemptId, invisibleTime);
    }

    public void clearBlock(String topic, String group, int queueId) {
        this.table.computeIfPresent(ConsumerOrderInfoManager.buildKey(topic, group), (key, val) -> {
            val.remove(queueId);
            return val;
        });
    }

    public long commitAndNext(String topic, String group, int queueId, long queueOffset, long popTime) {
        long temp;
        int i;
        String key = ConsumerOrderInfoManager.buildKey(topic, group);
        ConcurrentHashMap<Integer, OrderInfo> qs = this.table.get(key);
        if (qs == null) {
            return queueOffset + 1L;
        }
        OrderInfo orderInfo = qs.get(queueId);
        if (orderInfo == null) {
            log.warn("OrderInfo is null, {}, {}, {}", new Object[]{key, queueOffset, orderInfo});
            return queueOffset + 1L;
        }
        List o = orderInfo.offsetList;
        if (o == null || o.isEmpty()) {
            log.warn("OrderInfo is empty, {}, {}, {}", new Object[]{key, queueOffset, orderInfo});
            return -1L;
        }
        if (popTime != orderInfo.popTime) {
            log.warn("popTime is not equal to orderInfo saved. key: {}, offset: {}, orderInfo: {}, popTime: {}", new Object[]{key, queueOffset, orderInfo, popTime});
            return -2L;
        }
        Long first = (Long)o.get(0);
        int size = o.size();
        for (i = 0; i < size && queueOffset != (temp = i == 0 ? first : first + (Long)o.get(i)); ++i) {
        }
        if (i >= size) {
            log.warn("OrderInfo not found commit offset, {}, {}, {}", new Object[]{key, queueOffset, orderInfo});
            return -1L;
        }
        orderInfo.setCommitOffsetBit(orderInfo.commitOffsetBit | 1L << i);
        long nextOffset = orderInfo.getNextOffset();
        this.updateLockFreeTimestamp(topic, group, queueId, orderInfo);
        return nextOffset;
    }

    public void updateNextVisibleTime(String topic, String group, int queueId, long queueOffset, long popTime, long nextVisibleTime) {
        String key = ConsumerOrderInfoManager.buildKey(topic, group);
        ConcurrentHashMap<Integer, OrderInfo> qs = this.table.get(key);
        if (qs == null) {
            log.warn("orderInfo of queueId is null. key: {}, queueOffset: {}, queueId: {}", new Object[]{key, queueOffset, queueId});
            return;
        }
        OrderInfo orderInfo = qs.get(queueId);
        if (orderInfo == null) {
            log.warn("orderInfo is null, key: {}, queueOffset: {}, queueId: {}", new Object[]{key, queueOffset, queueId});
            return;
        }
        if (popTime != orderInfo.popTime) {
            log.warn("popTime is not equal to orderInfo saved. key: {}, queueOffset: {}, orderInfo: {}, popTime: {}", new Object[]{key, queueOffset, orderInfo, popTime});
            return;
        }
        orderInfo.updateOffsetNextVisibleTime(queueOffset, nextVisibleTime);
        this.updateLockFreeTimestamp(topic, group, queueId, orderInfo);
    }

    protected void autoClean() {
        if (this.brokerController == null) {
            return;
        }
        Iterator<Map.Entry<String, ConcurrentHashMap<Integer, OrderInfo>>> iterator = this.table.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ConcurrentHashMap<Integer, OrderInfo>> entry = iterator.next();
            String topicAtGroup = entry.getKey();
            ConcurrentHashMap<Integer, OrderInfo> qs = entry.getValue();
            String[] arrays = ConsumerOrderInfoManager.decodeKey(topicAtGroup);
            if (arrays.length != 2) continue;
            String topic = arrays[0];
            String group = arrays[1];
            TopicConfig topicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(topic);
            if (topicConfig == null) {
                iterator.remove();
                log.info("Topic not exist, Clean order info, {}:{}", (Object)topicAtGroup, qs);
                continue;
            }
            if (this.brokerController.getSubscriptionGroupManager().getSubscriptionGroupTable().get(group) == null) {
                iterator.remove();
                log.info("Group not exist, Clean order info, {}:{}", (Object)topicAtGroup, qs);
                continue;
            }
            if (qs.isEmpty()) {
                iterator.remove();
                log.info("Order table is empty, Clean order info, {}:{}", (Object)topicAtGroup, qs);
                continue;
            }
            Iterator<Map.Entry<Integer, OrderInfo>> qsIterator = qs.entrySet().iterator();
            while (qsIterator.hasNext()) {
                Map.Entry<Integer, OrderInfo> qsEntry = qsIterator.next();
                if (qsEntry.getKey() >= topicConfig.getReadQueueNums()) {
                    qsIterator.remove();
                    log.info("Queue not exist, Clean order info, {}:{}, {}", new Object[]{topicAtGroup, entry.getValue(), topicConfig});
                    continue;
                }
                if (System.currentTimeMillis() - qsEntry.getValue().getLastConsumeTimestamp() <= 86400000L) continue;
                qsIterator.remove();
                log.info("Not consume long time, Clean order info, {}:{}, {}", new Object[]{topicAtGroup, entry.getValue(), topicConfig});
            }
        }
    }

    public String encode() {
        return this.encode(false);
    }

    public String configFilePath() {
        if (this.brokerController != null) {
            return BrokerPathConfigHelper.getConsumerOrderInfoPath(this.brokerController.getMessageStoreConfig().getStorePathRootDir());
        }
        return BrokerPathConfigHelper.getConsumerOrderInfoPath("~");
    }

    public void decode(String jsonString) {
        ConsumerOrderInfoManager obj;
        if (jsonString != null && (obj = (ConsumerOrderInfoManager)((Object)RemotingSerializable.fromJson((String)jsonString, ConsumerOrderInfoManager.class))) != null) {
            this.table = obj.table;
            if (this.consumerOrderInfoLockManager != null) {
                this.consumerOrderInfoLockManager.recover(this.table);
            }
        }
    }

    public String encode(boolean prettyFormat) {
        this.autoClean();
        return RemotingSerializable.toJson((Object)((Object)this), (boolean)prettyFormat);
    }

    public void shutdown() {
        if (this.consumerOrderInfoLockManager != null) {
            this.consumerOrderInfoLockManager.shutdown();
        }
    }

    @VisibleForTesting
    protected ConsumerOrderInfoLockManager getConsumerOrderInfoLockManager() {
        return this.consumerOrderInfoLockManager;
    }

    public static class OrderInfo {
        private long popTime;
        @JSONField(name="i")
        private Long invisibleTime;
        @JSONField(name="o")
        private List<Long> offsetList;
        @JSONField(name="ot")
        private Map<Long, Long> offsetNextVisibleTime;
        @JSONField(name="oc")
        private Map<Long, Integer> offsetConsumedCount;
        @JSONField(name="l")
        private long lastConsumeTimestamp;
        @JSONField(name="cm")
        private long commitOffsetBit;
        @JSONField(name="a")
        private String attemptId;

        public OrderInfo() {
        }

        public OrderInfo(String attemptId, long popTime, long invisibleTime, List<Long> queueOffsetList, long lastConsumeTimestamp, long commitOffsetBit) {
            this.popTime = popTime;
            this.invisibleTime = invisibleTime;
            this.offsetList = OrderInfo.buildOffsetList(queueOffsetList);
            this.lastConsumeTimestamp = lastConsumeTimestamp;
            this.commitOffsetBit = commitOffsetBit;
            this.attemptId = attemptId;
        }

        public List<Long> getOffsetList() {
            return this.offsetList;
        }

        public void setOffsetList(List<Long> offsetList) {
            this.offsetList = offsetList;
        }

        public long getLastConsumeTimestamp() {
            return this.lastConsumeTimestamp;
        }

        public void setLastConsumeTimestamp(long lastConsumeTimestamp) {
            this.lastConsumeTimestamp = lastConsumeTimestamp;
        }

        public long getCommitOffsetBit() {
            return this.commitOffsetBit;
        }

        public void setCommitOffsetBit(long commitOffsetBit) {
            this.commitOffsetBit = commitOffsetBit;
        }

        public long getPopTime() {
            return this.popTime;
        }

        public void setPopTime(long popTime) {
            this.popTime = popTime;
        }

        public Long getInvisibleTime() {
            return this.invisibleTime;
        }

        public void setInvisibleTime(Long invisibleTime) {
            this.invisibleTime = invisibleTime;
        }

        public Map<Long, Long> getOffsetNextVisibleTime() {
            return this.offsetNextVisibleTime;
        }

        public void setOffsetNextVisibleTime(Map<Long, Long> offsetNextVisibleTime) {
            this.offsetNextVisibleTime = offsetNextVisibleTime;
        }

        public Map<Long, Integer> getOffsetConsumedCount() {
            return this.offsetConsumedCount;
        }

        public void setOffsetConsumedCount(Map<Long, Integer> offsetConsumedCount) {
            this.offsetConsumedCount = offsetConsumedCount;
        }

        public String getAttemptId() {
            return this.attemptId;
        }

        public void setAttemptId(String attemptId) {
            this.attemptId = attemptId;
        }

        public static List<Long> buildOffsetList(List<Long> queueOffsetList) {
            ArrayList<Long> simple = new ArrayList<Long>();
            if (queueOffsetList.size() == 1) {
                simple.addAll(queueOffsetList);
                return simple;
            }
            Long first = queueOffsetList.get(0);
            simple.add(first);
            for (int i = 1; i < queueOffsetList.size(); ++i) {
                simple.add(queueOffsetList.get(i) - first);
            }
            return simple;
        }

        @JSONField(serialize=false, deserialize=false)
        public boolean needBlock(String attemptId, long currentInvisibleTime) {
            if (this.offsetList == null || this.offsetList.isEmpty()) {
                return false;
            }
            if (this.attemptId != null && this.attemptId.equals(attemptId)) {
                return false;
            }
            int num = this.offsetList.size();
            int i = 0;
            if (this.invisibleTime == null || this.invisibleTime <= 0L) {
                this.invisibleTime = currentInvisibleTime;
            }
            long currentTime = System.currentTimeMillis();
            while (i < num) {
                if (this.isNotAck(i)) {
                    Long time;
                    long nextVisibleTime = this.popTime + this.invisibleTime;
                    if (this.offsetNextVisibleTime != null && (time = this.offsetNextVisibleTime.get(this.getQueueOffset(i))) != null) {
                        nextVisibleTime = time;
                    }
                    if (currentTime < nextVisibleTime) {
                        return true;
                    }
                }
                ++i;
            }
            return false;
        }

        @JSONField(serialize=false, deserialize=false)
        public Long getLockFreeTimestamp() {
            if (this.offsetList == null || this.offsetList.isEmpty()) {
                return null;
            }
            int num = this.offsetList.size();
            long currentTime = System.currentTimeMillis();
            for (int i = 0; i < num; ++i) {
                Long time;
                if (!this.isNotAck(i)) continue;
                if (this.invisibleTime == null || this.invisibleTime <= 0L) {
                    return null;
                }
                long nextVisibleTime = this.popTime + this.invisibleTime;
                if (this.offsetNextVisibleTime != null && (time = this.offsetNextVisibleTime.get(this.getQueueOffset(i))) != null) {
                    nextVisibleTime = time;
                }
                if (currentTime >= nextVisibleTime) continue;
                return nextVisibleTime;
            }
            return currentTime;
        }

        @JSONField(serialize=false, deserialize=false)
        public void updateOffsetNextVisibleTime(long queueOffset, long nextVisibleTime) {
            if (this.offsetNextVisibleTime == null) {
                this.offsetNextVisibleTime = new HashMap<Long, Long>();
            }
            this.offsetNextVisibleTime.put(queueOffset, nextVisibleTime);
        }

        @JSONField(serialize=false, deserialize=false)
        public long getNextOffset() {
            int i;
            if (this.offsetList == null || this.offsetList.isEmpty()) {
                return -2L;
            }
            int num = this.offsetList.size();
            for (i = 0; i < num && !this.isNotAck(i); ++i) {
            }
            if (i == num) {
                return this.getQueueOffset(num - 1) + 1L;
            }
            return this.getQueueOffset(i);
        }

        @JSONField(serialize=false, deserialize=false)
        public long getQueueOffset(int offsetIndex) {
            return OrderInfo.getQueueOffset(this.offsetList, offsetIndex);
        }

        protected static long getQueueOffset(List<Long> offsetList, int offsetIndex) {
            if (offsetIndex == 0) {
                return offsetList.get(0);
            }
            return offsetList.get(0) + offsetList.get(offsetIndex);
        }

        @JSONField(serialize=false, deserialize=false)
        public boolean isNotAck(int offsetIndex) {
            return (this.commitOffsetBit & 1L << offsetIndex) == 0L;
        }

        @JSONField(serialize=false, deserialize=false)
        public void mergeOffsetConsumedCount(String preAttemptId, List<Long> preOffsetList, Map<Long, Integer> prevOffsetConsumedCount) {
            int i;
            HashMap<Long, Integer> offsetConsumedCount = new HashMap<Long, Integer>();
            if (prevOffsetConsumedCount == null) {
                prevOffsetConsumedCount = new HashMap<Long, Integer>();
            }
            if (preAttemptId != null && preAttemptId.equals(this.attemptId)) {
                this.offsetConsumedCount = prevOffsetConsumedCount;
                return;
            }
            HashSet<Long> preQueueOffsetSet = new HashSet<Long>();
            for (i = 0; i < preOffsetList.size(); ++i) {
                preQueueOffsetSet.add(OrderInfo.getQueueOffset(preOffsetList, i));
            }
            for (i = 0; i < this.offsetList.size(); ++i) {
                long queueOffset = this.getQueueOffset(i);
                if (!preQueueOffsetSet.contains(queueOffset)) continue;
                int count = 1;
                Integer preCount = prevOffsetConsumedCount.get(queueOffset);
                if (preCount != null) {
                    count = preCount + 1;
                }
                offsetConsumedCount.put(queueOffset, count);
            }
            this.offsetConsumedCount = offsetConsumedCount;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("popTime", this.popTime).add("invisibleTime", (Object)this.invisibleTime).add("offsetList", this.offsetList).add("offsetNextVisibleTime", this.offsetNextVisibleTime).add("offsetConsumedCount", this.offsetConsumedCount).add("lastConsumeTimestamp", this.lastConsumeTimestamp).add("commitOffsetBit", this.commitOffsetBit).add("attemptId", (Object)this.attemptId).toString();
        }
    }
}

