/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.utilint.LongAvgRate;
import com.sleepycat.je.utilint.MapStat;
import com.sleepycat.je.utilint.Stat;
import com.sleepycat.je.utilint.StatDefinition;
import com.sleepycat.je.utilint.StatGroup;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class LongAvgRateMapStat
extends MapStat<Long, LongAvgRate> {
    private static final long serialVersionUID = 1L;
    protected final long periodMillis;
    private final TimeUnit reportTimeUnit;
    private long removeStatTimestamp;

    public LongAvgRateMapStat(StatGroup group, StatDefinition definition, long periodMillis, TimeUnit reportTimeUnit) {
        super(group, definition);
        assert (definition.getType() == StatDefinition.StatType.INCREMENTAL);
        assert (periodMillis > 0L);
        assert (reportTimeUnit != null);
        this.periodMillis = periodMillis;
        this.reportTimeUnit = reportTimeUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LongAvgRateMapStat(LongAvgRateMapStat other) {
        super(other);
        this.periodMillis = other.periodMillis;
        this.reportTimeUnit = other.reportTimeUnit;
        LongAvgRateMapStat longAvgRateMapStat = this;
        synchronized (longAvgRateMapStat) {
            LongAvgRateMapStat longAvgRateMapStat2 = other;
            synchronized (longAvgRateMapStat2) {
                this.removeStatTimestamp = other.removeStatTimestamp;
            }
        }
    }

    public synchronized LongAvgRate createStat(String key) {
        assert (key != null);
        LongAvgRate stat = new LongAvgRate(this.definition.getName() + ":" + key, this.periodMillis, this.reportTimeUnit);
        this.statMap.put(key, stat);
        return stat;
    }

    @Override
    public synchronized void removeStat(String key) {
        this.removeStat(key, System.currentTimeMillis());
    }

    synchronized void removeStat(String key, long time) {
        this.removeStatTimestamp = time;
        super.removeStat(key);
    }

    @Override
    public LongAvgRateMapStat copy() {
        return new LongAvgRateMapStat(this);
    }

    public LongAvgRateMapStat computeInterval(Stat<String> base) {
        assert (base instanceof LongAvgRateMapStat);
        LongAvgRateMapStat copy = this.copy();
        LongAvgRateMapStat baseCopy = (LongAvgRateMapStat)base.copy();
        if (copy.getLatestTime() < baseCopy.getLatestTime()) {
            return copy.updateLatest(baseCopy);
        }
        return baseCopy.updateLatest(copy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized LongAvgRateMapStat updateLatest(LongAvgRateMapStat latest) {
        LongAvgRateMapStat longAvgRateMapStat = latest;
        synchronized (longAvgRateMapStat) {
            Iterator i = this.statMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                LongAvgRate latestStat = (LongAvgRate)latest.statMap.get(e.getKey());
                if (latestStat != null) {
                    ((LongAvgRate)e.getValue()).add(latestStat);
                    continue;
                }
                i.remove();
            }
            for (Map.Entry e : latest.statMap.entrySet()) {
                String key = (String)e.getKey();
                if (this.statMap.containsKey(key)) continue;
                this.statMap.put(key, e.getValue());
            }
        }
        return this;
    }

    private synchronized long getLatestTime() {
        long latestTime = this.removeStatTimestamp;
        for (LongAvgRate stat : this.statMap.values()) {
            latestTime = Math.max(latestTime, stat.getPrevTime());
        }
        return latestTime;
    }

    @Override
    public synchronized void negate() {
    }
}

