/*
 * Decompiled with CFR 0.152.
 */
package io.oxia.client.batch;

import io.oxia.client.ClientConfig;
import io.oxia.client.batch.Batcher;
import io.oxia.client.grpc.OxiaStubProvider;
import io.oxia.client.metrics.InstrumentProvider;
import io.oxia.client.session.SessionManager;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;

public class BatchManager
implements AutoCloseable {
    private final ConcurrentMap<Long, Batcher> batchersByShardId = new ConcurrentHashMap<Long, Batcher>();
    @NonNull
    private final Function<Long, Batcher> batcherFactory;
    private volatile boolean closed;

    public Batcher getBatcher(long shardId) {
        if (this.closed) {
            throw new IllegalStateException("Batch manager is closed");
        }
        return this.batchersByShardId.computeIfAbsent(shardId, this::createAndStartBatcher);
    }

    private Batcher createAndStartBatcher(long shardId) {
        return this.batcherFactory.apply(shardId);
    }

    @Override
    public void close() throws Exception {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.batchersByShardId.values().forEach(Batcher::close);
    }

    @NonNull
    public static BatchManager newReadBatchManager(@NonNull ClientConfig config, @NonNull OxiaStubProvider stubProvider, @NonNull InstrumentProvider instrumentProvider) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (stubProvider == null) {
            throw new NullPointerException("stubProvider is marked non-null but is null");
        }
        if (instrumentProvider == null) {
            throw new NullPointerException("instrumentProvider is marked non-null but is null");
        }
        return new BatchManager(Batcher.newReadBatcherFactory(config, stubProvider, instrumentProvider));
    }

    @NonNull
    public static BatchManager newWriteBatchManager(@NonNull ClientConfig config, @NonNull OxiaStubProvider stubProvider, @NonNull SessionManager sessionManager, @NonNull InstrumentProvider instrumentProvider) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (stubProvider == null) {
            throw new NullPointerException("stubProvider is marked non-null but is null");
        }
        if (sessionManager == null) {
            throw new NullPointerException("sessionManager is marked non-null but is null");
        }
        if (instrumentProvider == null) {
            throw new NullPointerException("instrumentProvider is marked non-null but is null");
        }
        return new BatchManager(Batcher.newWriteBatcherFactory(config, stubProvider, sessionManager, instrumentProvider));
    }

    @Generated
    public BatchManager(@NonNull Function<Long, Batcher> batcherFactory) {
        if (batcherFactory == null) {
            throw new NullPointerException("batcherFactory is marked non-null but is null");
        }
        this.batcherFactory = batcherFactory;
    }

    public static class ShutdownException
    extends Exception {
        @NonNull
        private final List<Exception> exceptions;

        @Generated
        ShutdownException(@NonNull List<Exception> exceptions) {
            if (exceptions == null) {
                throw new NullPointerException("exceptions is marked non-null but is null");
            }
            this.exceptions = exceptions;
        }

        @NonNull
        @Generated
        public List<Exception> getExceptions() {
            return this.exceptions;
        }
    }
}

