/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps;

import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.ImportedTableInfo;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.accumulo.server.tables.TableManager;
import org.apache.hadoop.fs.Path;
import org.slf4j.LoggerFactory;

class FinishImportTable
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private ImportedTableInfo tableInfo;

    public FinishImportTable(ImportedTableInfo ti) {
        this.tableInfo = ti;
    }

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        return 0L;
    }

    @Override
    public Repo<Master> call(long tid, Master env) throws Exception {
        env.getFileSystem().deleteRecursively(new Path(this.tableInfo.importDir, "mappings.txt"));
        TableManager.getInstance().transitionTableState(this.tableInfo.tableId, TableState.ONLINE);
        Utils.unreserveNamespace(this.tableInfo.namespaceId, tid, false);
        Utils.unreserveTable(this.tableInfo.tableId, tid, true);
        Utils.unreserveHdfsDirectory(new Path(this.tableInfo.exportDir).toString(), tid);
        env.getEventCoordinator().event("Imported table %s ", this.tableInfo.tableName);
        LoggerFactory.getLogger(FinishImportTable.class).debug("Imported table " + this.tableInfo.tableId + " " + this.tableInfo.tableName);
        return null;
    }

    @Override
    public String getReturn() {
        return this.tableInfo.tableId;
    }

    @Override
    public void undo(long tid, Master env) throws Exception {
    }
}

