/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common.web;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tez.common.web.ProfileServlet;
import org.eclipse.jetty.servlet.DefaultServlet;

public class ProfileOutputServlet
extends DefaultServlet {
    public static final String FILE_QUERY_PARAM = "file";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String queriedFile = request.getParameter(FILE_QUERY_PARAM);
        if (queriedFile == null) {
            this.writeMessage(response, "Run the profiler to be able to receive its output");
            return;
        }
        File outputFile = new File(ProfileServlet.OUTPUT_DIR, queriedFile);
        if (!outputFile.exists()) {
            this.writeMessage(response, "Requested file does not exist: " + queriedFile);
            return;
        }
        if (outputFile.length() < 100L) {
            response.setIntHeader("Refresh", 2);
            this.writeMessage(response, "This page auto-refreshes every 2 seconds until output file is ready...");
            return;
        }
        response.setContentType("text/html; charset=UTF-8");
        response.getOutputStream().write(Files.readAllBytes(Paths.get(outputFile.getPath(), new String[0])));
        response.getOutputStream().flush();
        response.getOutputStream().close();
    }

    private void writeMessage(HttpServletResponse response, String message) throws IOException {
        response.setContentType("text/plain; charset=UTF-8");
        PrintWriter out = response.getWriter();
        out.println(message);
        out.close();
    }
}

