/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.ExportSnapshot;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestExportSnapshotHelpers {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestExportSnapshotHelpers.class);

    @Test
    public void testBalanceSplit() throws Exception {
        ArrayList<Pair> files = new ArrayList<Pair>(21);
        for (long i = 0L; i <= 20L; ++i) {
            SnapshotProtos.SnapshotFileInfo fileInfo = SnapshotProtos.SnapshotFileInfo.newBuilder().setType(SnapshotProtos.SnapshotFileInfo.Type.HFILE).setHfile("file-" + i).build();
            files.add(new Pair((Object)fileInfo, (Object)i));
        }
        List splits = ExportSnapshot.getBalancedSplits(files, (int)5);
        Assert.assertEquals((long)5L, (long)splits.size());
        String[] split0 = new String[]{"file-20", "file-11", "file-10", "file-1", "file-0"};
        this.verifyBalanceSplit((List)splits.get(0), split0, 42L);
        String[] split1 = new String[]{"file-19", "file-12", "file-9", "file-2"};
        this.verifyBalanceSplit((List)splits.get(1), split1, 42L);
        String[] split2 = new String[]{"file-18", "file-13", "file-8", "file-3"};
        this.verifyBalanceSplit((List)splits.get(2), split2, 42L);
        String[] split3 = new String[]{"file-17", "file-14", "file-7", "file-4"};
        this.verifyBalanceSplit((List)splits.get(3), split3, 42L);
        String[] split4 = new String[]{"file-16", "file-15", "file-6", "file-5"};
        this.verifyBalanceSplit((List)splits.get(4), split4, 42L);
    }

    private void verifyBalanceSplit(List<Pair<SnapshotProtos.SnapshotFileInfo, Long>> split, String[] expected, long expectedSize) {
        Assert.assertEquals((long)expected.length, (long)split.size());
        long totalSize = 0L;
        for (int i = 0; i < expected.length; ++i) {
            Pair<SnapshotProtos.SnapshotFileInfo, Long> fileInfo = split.get(i);
            Assert.assertEquals((Object)expected[i], (Object)((SnapshotProtos.SnapshotFileInfo)fileInfo.getFirst()).getHfile());
            totalSize += ((Long)fileInfo.getSecond()).longValue();
        }
        Assert.assertEquals((long)expectedSize, (long)totalSize);
    }
}

