/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.streams;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.accumulo.core.util.ratelimit.NullRateLimiter;
import org.apache.accumulo.core.util.ratelimit.RateLimiter;
import org.apache.hadoop.fs.Seekable;

public class RateLimitedInputStream
extends FilterInputStream
implements Seekable {
    private final RateLimiter rateLimiter;

    public <StreamType extends InputStream> RateLimitedInputStream(StreamType stream, RateLimiter rateLimiter) {
        super(stream);
        this.rateLimiter = rateLimiter == null ? NullRateLimiter.INSTANCE : rateLimiter;
    }

    @Override
    public int read() throws IOException {
        int val = this.in.read();
        if (val >= 0) {
            this.rateLimiter.acquire(1L);
        }
        return val;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int count = this.in.read(buffer, offset, length);
        if (count > 0) {
            this.rateLimiter.acquire(count);
        }
        return count;
    }

    public void seek(long pos) throws IOException {
        ((Seekable)this.in).seek(pos);
    }

    public long getPos() throws IOException {
        return ((Seekable)this.in).getPos();
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        return ((Seekable)this.in).seekToNewSource(targetPos);
    }
}

