/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.streams;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.accumulo.core.file.streams.PositionedOutput;
import org.apache.hadoop.fs.FSDataOutputStream;

public class PositionedOutputs {
    private PositionedOutputs() {
    }

    public static PositionedOutputStream wrap(final OutputStream fout) {
        Objects.requireNonNull(fout);
        if (fout instanceof FSDataOutputStream) {
            return new PositionedOutputStream(fout){

                @Override
                public long position() throws IOException {
                    return ((FSDataOutputStream)fout).getPos();
                }
            };
        }
        if (fout instanceof PositionedOutput) {
            return new PositionedOutputStream(fout){

                @Override
                public long position() throws IOException {
                    return ((PositionedOutput)((Object)fout)).position();
                }
            };
        }
        return new PositionedOutputStream(fout){

            @Override
            public long position() throws IOException {
                throw new UnsupportedOperationException("Underlying stream does not support position()");
            }
        };
    }

    private static abstract class PositionedOutputStream
    extends FilterOutputStream
    implements PositionedOutput {
        public PositionedOutputStream(OutputStream stream) {
            super(stream);
        }

        @Override
        public void write(byte[] data, int off, int len) throws IOException {
            this.out.write(data, off, len);
        }
    }
}

