/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.gc.replication;

import com.google.protobuf.InvalidProtocolBufferException;
import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.trace.Span;
import org.apache.accumulo.core.trace.Trace;
import org.apache.accumulo.core.trace.thrift.TInfo;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.server.AccumuloServerContext;
import org.apache.accumulo.server.log.WalStateManager;
import org.apache.accumulo.server.replication.StatusUtil;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.thrift.TException;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.TServiceClientFactory;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseWriteAheadLogReferences
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(CloseWriteAheadLogReferences.class);
    private static final String RFILE_SUFFIX = ".rf";
    private final AccumuloServerContext context;

    public CloseWriteAheadLogReferences(AccumuloServerContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Duration duration;
        long startTime;
        Connector conn;
        try {
            conn = this.context.getConnector();
        }
        catch (Exception e) {
            log.error("Could not create connector", (Throwable)e);
            throw new RuntimeException(e);
        }
        if (!ReplicationTable.isOnline((Connector)conn)) {
            log.debug("Replication table isn't online, not attempting to clean up wals");
            return;
        }
        Span findWalsSpan = Trace.start((String)"findReferencedWals");
        HashSet<String> closed = null;
        try {
            startTime = System.nanoTime();
            closed = this.getClosedLogs(conn);
            duration = Duration.ofNanos(System.nanoTime() - startTime);
        }
        finally {
            findWalsSpan.stop();
        }
        log.info("Found " + closed.size() + " WALs referenced in metadata in " + duration);
        Span updateReplicationSpan = Trace.start((String)"updateReplicationTable");
        long recordsClosed = 0L;
        try {
            startTime = System.nanoTime();
            recordsClosed = this.updateReplicationEntries(conn, closed);
            duration = Duration.ofNanos(System.nanoTime() - startTime);
        }
        finally {
            updateReplicationSpan.stop();
        }
        log.info("Closed " + recordsClosed + " WAL replication references in replication table in " + duration);
    }

    protected HashSet<String> getClosedLogs(Connector conn) {
        WalStateManager wals = new WalStateManager(conn.getInstance(), ZooReaderWriter.getInstance());
        HashSet<String> result = new HashSet<String>();
        try {
            for (Map.Entry entry : wals.getAllState().entrySet()) {
                if (entry.getValue() != WalStateManager.WalState.UNREFERENCED && entry.getValue() != WalStateManager.WalState.CLOSED) continue;
                Path path = (Path)entry.getKey();
                log.debug("Found closed WAL " + path.toString());
                result.add(path.toString());
            }
        }
        catch (WalStateManager.WalMarkerException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long updateReplicationEntries(Connector conn, Set<String> closedWals) {
        BatchScanner bs = null;
        BatchWriter bw = null;
        long recordsClosed = 0L;
        try {
            bw = conn.createBatchWriter("accumulo.metadata", new BatchWriterConfig());
            bs = conn.createBatchScanner("accumulo.metadata", Authorizations.EMPTY, 4);
            bs.setRanges(Collections.singleton(Range.prefix((CharSequence)MetadataSchema.ReplicationSection.getRowPrefix())));
            bs.fetchColumnFamily(MetadataSchema.ReplicationSection.COLF);
            Text replFileText = new Text();
            for (Map.Entry entry : bs) {
                Replication.Status status;
                try {
                    status = Replication.Status.parseFrom((byte[])((Value)entry.getValue()).get());
                }
                catch (InvalidProtocolBufferException e) {
                    log.error("Could not parse Status protobuf for {}", entry.getKey(), (Object)e);
                    continue;
                }
                MetadataSchema.ReplicationSection.getFile((Key)((Key)entry.getKey()), (Text)replFileText);
                String replFile = replFileText.toString();
                boolean isClosed = closedWals.contains(replFile);
                if (status.getClosed() || replFile.endsWith(RFILE_SUFFIX) || !isClosed) continue;
                try {
                    this.closeWal(bw, (Key)entry.getKey());
                    ++recordsClosed;
                }
                catch (MutationsRejectedException e) {
                    log.error("Failed to submit delete mutation for " + entry.getKey());
                }
            }
        }
        catch (TableNotFoundException e) {
            log.error("Replication table was deleted", (Throwable)e);
        }
        finally {
            if (null != bs) {
                bs.close();
            }
            if (null != bw) {
                try {
                    bw.close();
                }
                catch (MutationsRejectedException e) {
                    log.error("Failed to write delete mutations for replication table", (Throwable)e);
                }
            }
        }
        return recordsClosed;
    }

    protected void closeWal(BatchWriter bw, Key k) throws MutationsRejectedException {
        log.debug("Closing unreferenced WAL ({}) in metadata table", (Object)k.toStringNoTruncate());
        Mutation m = new Mutation(k.getRow());
        m.put(k.getColumnFamily(), k.getColumnQualifier(), StatusUtil.fileClosedValue());
        bw.addMutation(m);
    }

    private HostAndPort getMasterAddress() {
        try {
            List locations = this.context.getInstance().getMasterLocations();
            if (locations.size() == 0) {
                return null;
            }
            return HostAndPort.fromString((String)((String)locations.get(0)));
        }
        catch (Exception e) {
            log.warn("Failed to obtain master host " + e);
            return null;
        }
    }

    private MasterClientService.Client getMasterConnection() {
        HostAndPort address = this.getMasterAddress();
        try {
            if (address == null) {
                log.warn("Could not fetch Master address");
                return null;
            }
            return (MasterClientService.Client)ThriftUtil.getClient((TServiceClientFactory)new MasterClientService.Client.Factory(), (HostAndPort)address, (ClientContext)this.context);
        }
        catch (Exception e) {
            log.warn("Issue with masterConnection (" + address + ") " + e, (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getActiveTservers(TInfo tinfo) {
        MasterClientService.Client client = null;
        List tservers = null;
        try {
            client = this.getMasterConnection();
            if (null != client) {
                tservers = client.getActiveTservers(tinfo, this.context.rpcCreds());
            }
        }
        catch (TException e) {
            log.warn("Failed to fetch active tabletservers from the master", (Throwable)e);
            List<String> list = null;
            return list;
        }
        finally {
            ThriftUtil.returnClient((TServiceClient)client);
        }
        return tservers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected List<String> getActiveWalsForServer(TInfo tinfo, HostAndPort server) {
        List list;
        TabletClientService.Client tserverClient = null;
        try {
            tserverClient = (TabletClientService.Client)ThriftUtil.getClient((TServiceClientFactory)new TabletClientService.Client.Factory(), (HostAndPort)server, (ClientContext)this.context);
            list = tserverClient.getActiveLogs(tinfo, this.context.rpcCreds());
        }
        catch (TTransportException e) {
            log.warn("Failed to fetch active write-ahead logs from " + server, (Throwable)e);
            List<String> list2 = null;
            ThriftUtil.returnClient((TServiceClient)tserverClient);
            return list2;
        }
        catch (TException e2) {
            log.warn("Failed to fetch active write-ahead logs from " + server, (Throwable)e2);
            List<String> list3 = null;
            {
                catch (Throwable throwable) {
                    ThriftUtil.returnClient(tserverClient);
                    throw throwable;
                }
            }
            ThriftUtil.returnClient((TServiceClient)tserverClient);
            return list3;
        }
        ThriftUtil.returnClient((TServiceClient)tserverClient);
        return list;
    }
}

