/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.CoreCoprocessor;
import org.apache.hadoop.hbase.coprocessor.HasMasterServices;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hadoop.hbase.quotas.QuotaUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.yetus.audience.InterfaceAudience;

@CoreCoprocessor
@InterfaceAudience.Private
public class MasterQuotasObserver
implements MasterCoprocessor,
MasterObserver {
    public static final String REMOVE_QUOTA_ON_TABLE_DELETE = "hbase.quota.remove.on.table.delete";
    public static final boolean REMOVE_QUOTA_ON_TABLE_DELETE_DEFAULT = true;
    private CoprocessorEnvironment cpEnv;
    private Configuration conf;
    private boolean quotasEnabled = false;
    private MasterServices masterServices;

    @Override
    public Optional<MasterObserver> getMasterObserver() {
        return Optional.of(this);
    }

    public void start(CoprocessorEnvironment ctx) throws IOException {
        this.conf = ctx.getConfiguration();
        this.quotasEnabled = QuotaUtil.isQuotaEnabled(this.conf);
        if (!(ctx instanceof MasterCoprocessorEnvironment)) {
            throw new CoprocessorException("Must be loaded on master.");
        }
        MasterCoprocessorEnvironment mEnv = (MasterCoprocessorEnvironment)ctx;
        if (!(mEnv instanceof HasMasterServices)) {
            throw new CoprocessorException("Must be loaded on a master having master services.");
        }
        this.masterServices = ((HasMasterServices)((Object)mEnv)).getMasterServices();
    }

    @Override
    public void postDeleteTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (!this.quotasEnabled) {
            return;
        }
        Connection conn = ctx.getEnvironment().getConnection();
        QuotaProtos.Quotas tableQuotas = QuotaUtil.getTableQuota((Connection)conn, (TableName)tableName);
        QuotaProtos.Quotas namespaceQuotas = QuotaUtil.getNamespaceQuota((Connection)conn, (String)tableName.getNamespaceAsString());
        if (tableQuotas != null || namespaceQuotas != null) {
            this.masterServices.getMasterQuotaManager().removeRegionSizesForTable(tableName);
            if (tableQuotas != null) {
                Throwable throwable;
                Admin admin;
                QuotaSettings settings;
                if (tableQuotas.hasSpace()) {
                    settings = QuotaSettingsFactory.removeTableSpaceLimit((TableName)tableName);
                    admin = conn.getAdmin();
                    throwable = null;
                    try {
                        admin.setQuota(settings);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (admin != null) {
                            if (throwable != null) {
                                try {
                                    admin.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                admin.close();
                            }
                        }
                    }
                }
                if (tableQuotas.hasThrottle()) {
                    settings = QuotaSettingsFactory.unthrottleTable((TableName)tableName);
                    admin = conn.getAdmin();
                    throwable = null;
                    try {
                        admin.setQuota(settings);
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (admin != null) {
                            if (throwable != null) {
                                try {
                                    admin.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                admin.close();
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void postDeleteNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace) throws IOException {
        if (!this.quotasEnabled) {
            return;
        }
        Connection conn = ctx.getEnvironment().getConnection();
        QuotaProtos.Quotas quotas = QuotaUtil.getNamespaceQuota((Connection)conn, (String)namespace);
        if (quotas != null) {
            Throwable throwable;
            Admin admin;
            QuotaSettings settings;
            if (quotas.hasSpace()) {
                settings = QuotaSettingsFactory.removeNamespaceSpaceLimit((String)namespace);
                admin = conn.getAdmin();
                throwable = null;
                try {
                    admin.setQuota(settings);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (admin != null) {
                        if (throwable != null) {
                            try {
                                admin.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            admin.close();
                        }
                    }
                }
            }
            if (quotas.hasThrottle()) {
                settings = QuotaSettingsFactory.unthrottleNamespace((String)namespace);
                admin = conn.getAdmin();
                throwable = null;
                try {
                    admin.setQuota(settings);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (admin != null) {
                        if (throwable != null) {
                            try {
                                admin.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            admin.close();
                        }
                    }
                }
            }
        }
    }
}

