/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.region;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.region.MasterRegion;
import org.apache.hadoop.hbase.master.region.MasterRegionParams;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class MasterRegionFactory {
    public static final String ARCHIVED_WAL_SUFFIX = "$masterlocalwal$";
    public static final String ARCHIVED_HFILE_SUFFIX = "$-masterlocalhfile-$";
    private static final String MAX_WALS_KEY = "hbase.master.store.region.maxwals";
    private static final int DEFAULT_MAX_WALS = 10;
    public static final String USE_HSYNC_KEY = "hbase.master.store.region.wal.hsync";
    public static final String MASTER_STORE_DIR = "MasterData";
    private static final String FLUSH_SIZE_KEY = "hbase.master.store.region.flush.size";
    private static final long DEFAULT_FLUSH_SIZE = 0x8000000L;
    private static final String FLUSH_PER_CHANGES_KEY = "hbase.master.store.region.flush.per.changes";
    private static final long DEFAULT_FLUSH_PER_CHANGES = 1000000L;
    private static final String FLUSH_INTERVAL_MS_KEY = "hbase.master.store.region.flush.interval.ms";
    private static final long DEFAULT_FLUSH_INTERVAL_MS = TimeUnit.MINUTES.toMillis(15L);
    private static final String COMPACT_MIN_KEY = "hbase.master.store.region.compact.min";
    private static final int DEFAULT_COMPACT_MIN = 4;
    private static final String ROLL_PERIOD_MS_KEY = "hbase.master.store.region.walroll.period.ms";
    private static final long DEFAULT_ROLL_PERIOD_MS = TimeUnit.MINUTES.toMillis(15L);
    private static final String RING_BUFFER_SLOT_COUNT = "hbase.master.store.ringbuffer.slot.count";
    private static final int DEFAULT_RING_BUFFER_SLOT_COUNT = 128;
    public static final TableName TABLE_NAME = TableName.valueOf((String)"master:store");
    public static final byte[] PROC_FAMILY = Bytes.toBytes((String)"proc");
    private static final TableDescriptor TABLE_DESC = TableDescriptorBuilder.newBuilder((TableName)TABLE_NAME).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])PROC_FAMILY)).build();

    public static MasterRegion create(Server server) throws IOException {
        MasterRegionParams params = new MasterRegionParams().server(server).regionDirName(MASTER_STORE_DIR).tableDescriptor(TABLE_DESC);
        Configuration conf = server.getConfiguration();
        long flushSize = conf.getLong(FLUSH_SIZE_KEY, 0x8000000L);
        long flushPerChanges = conf.getLong(FLUSH_PER_CHANGES_KEY, 1000000L);
        long flushIntervalMs = conf.getLong(FLUSH_INTERVAL_MS_KEY, DEFAULT_FLUSH_INTERVAL_MS);
        int compactMin = conf.getInt(COMPACT_MIN_KEY, 4);
        params.flushSize(flushSize).flushPerChanges(flushPerChanges).flushIntervalMs(flushIntervalMs).compactMin(compactMin);
        int maxWals = conf.getInt(MAX_WALS_KEY, 10);
        params.maxWals(maxWals);
        if (conf.get(USE_HSYNC_KEY) != null) {
            params.useHsync(conf.getBoolean(USE_HSYNC_KEY, false));
        }
        params.ringBufferSlotCount(conf.getInt(RING_BUFFER_SLOT_COUNT, 128));
        long rollPeriodMs = conf.getLong(ROLL_PERIOD_MS_KEY, DEFAULT_ROLL_PERIOD_MS);
        params.rollPeriodMs(rollPeriodMs).archivedWalSuffix(ARCHIVED_WAL_SUFFIX).archivedHFileSuffix(ARCHIVED_HFILE_SUFFIX);
        return MasterRegion.create(params);
    }
}

