/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.trevni.TrevniRuntimeException;
import org.apache.trevni.ValueType;

class OutputBuffer
extends ByteArrayOutputStream {
    static final int BLOCK_SIZE = 65536;
    private int bitCount;
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public OutputBuffer() {
        super(32768);
    }

    public boolean isFull() {
        return this.size() >= 65536;
    }

    public ByteBuffer asByteBuffer() {
        return ByteBuffer.wrap(this.buf, 0, this.count);
    }

    public void writeValue(Object value, ValueType type) throws IOException {
        switch (type) {
            case NULL: {
                break;
            }
            case BOOLEAN: {
                this.writeBoolean((Boolean)value);
                break;
            }
            case INT: {
                this.writeInt((Integer)value);
                break;
            }
            case LONG: {
                this.writeLong((Long)value);
                break;
            }
            case FIXED32: {
                this.writeFixed32((Integer)value);
                break;
            }
            case FIXED64: {
                this.writeFixed64((Long)value);
                break;
            }
            case FLOAT: {
                this.writeFloat(((Float)value).floatValue());
                break;
            }
            case DOUBLE: {
                this.writeDouble((Double)value);
                break;
            }
            case STRING: {
                this.writeString((String)value);
                break;
            }
            case BYTES: {
                if (value instanceof ByteBuffer) {
                    this.writeBytes((ByteBuffer)value);
                    break;
                }
                this.writeBytes((byte[])value);
                break;
            }
            default: {
                throw new TrevniRuntimeException("Unknown value type: " + (Object)((Object)type));
            }
        }
    }

    public void writeBoolean(boolean value) {
        if (this.bitCount == 0) {
            this.ensure(1);
            ++this.count;
        }
        if (value) {
            int n = this.count - 1;
            this.buf[n] = (byte)(this.buf[n] | (byte)(1 << this.bitCount));
        }
        ++this.bitCount;
        if (this.bitCount == 8) {
            this.bitCount = 0;
        }
    }

    public void writeLength(int length) throws IOException {
        this.bitCount = 0;
        this.writeInt(length);
    }

    public void writeString(String string) throws IOException {
        byte[] bytes = string.getBytes(UTF8);
        this.writeInt(bytes.length);
        this.write(bytes, 0, bytes.length);
    }

    public void writeBytes(ByteBuffer bytes) throws IOException {
        int pos = bytes.position();
        int start = bytes.arrayOffset() + pos;
        int len = bytes.limit() - pos;
        this.writeBytes(bytes.array(), start, len);
    }

    @Override
    public void writeBytes(byte[] bytes) throws IOException {
        this.writeBytes(bytes, 0, bytes.length);
    }

    public void writeBytes(byte[] bytes, int start, int len) throws IOException {
        this.writeInt(len);
        this.write(bytes, start, len);
    }

    public void writeFloat(float f) throws IOException {
        this.writeFixed32(Float.floatToRawIntBits(f));
    }

    public void writeDouble(double d) throws IOException {
        this.writeFixed64(Double.doubleToRawLongBits(d));
    }

    public void writeFixed32(int i) throws IOException {
        this.ensure(4);
        this.buf[this.count] = (byte)(i & 0xFF);
        this.buf[this.count + 1] = (byte)(i >>> 8 & 0xFF);
        this.buf[this.count + 2] = (byte)(i >>> 16 & 0xFF);
        this.buf[this.count + 3] = (byte)(i >>> 24 & 0xFF);
        this.count += 4;
    }

    public void writeFixed64(long l) throws IOException {
        this.ensure(8);
        int first = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        int second = (int)(l >>> 32 & 0xFFFFFFFFFFFFFFFFL);
        this.buf[this.count] = (byte)(first & 0xFF);
        this.buf[this.count + 4] = (byte)(second & 0xFF);
        this.buf[this.count + 5] = (byte)(second >>> 8 & 0xFF);
        this.buf[this.count + 1] = (byte)(first >>> 8 & 0xFF);
        this.buf[this.count + 2] = (byte)(first >>> 16 & 0xFF);
        this.buf[this.count + 6] = (byte)(second >>> 16 & 0xFF);
        this.buf[this.count + 7] = (byte)(second >>> 24 & 0xFF);
        this.buf[this.count + 3] = (byte)(first >>> 24 & 0xFF);
        this.count += 8;
    }

    public void writeInt(int n) throws IOException {
        this.ensure(5);
        n = n << 1 ^ n >> 31;
        if ((n & 0xFFFFFF80) != 0) {
            this.buf[this.count++] = (byte)((n | 0x80) & 0xFF);
            if ((n >>>= 7) > 127) {
                this.buf[this.count++] = (byte)((n | 0x80) & 0xFF);
                if ((n >>>= 7) > 127) {
                    this.buf[this.count++] = (byte)((n | 0x80) & 0xFF);
                    if ((n >>>= 7) > 127) {
                        this.buf[this.count++] = (byte)((n | 0x80) & 0xFF);
                        n >>>= 7;
                    }
                }
            }
        }
        this.buf[this.count++] = (byte)n;
    }

    public void writeLong(long n) throws IOException {
        this.ensure(10);
        n = n << 1 ^ n >> 63;
        if ((n & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.buf[this.count++] = (byte)((n | 0x80L) & 0xFFL);
            if ((n >>>= 7) > 127L) {
                this.buf[this.count++] = (byte)((n | 0x80L) & 0xFFL);
                if ((n >>>= 7) > 127L) {
                    this.buf[this.count++] = (byte)((n | 0x80L) & 0xFFL);
                    if ((n >>>= 7) > 127L) {
                        this.buf[this.count++] = (byte)((n | 0x80L) & 0xFFL);
                        if ((n >>>= 7) > 127L) {
                            this.buf[this.count++] = (byte)((n | 0x80L) & 0xFFL);
                            if ((n >>>= 7) > 127L) {
                                this.buf[this.count++] = (byte)((n | 0x80L) & 0xFFL);
                                if ((n >>>= 7) > 127L) {
                                    this.buf[this.count++] = (byte)((n | 0x80L) & 0xFFL);
                                    if ((n >>>= 7) > 127L) {
                                        this.buf[this.count++] = (byte)((n | 0x80L) & 0xFFL);
                                        if ((n >>>= 7) > 127L) {
                                            this.buf[this.count++] = (byte)((n | 0x80L) & 0xFFL);
                                            n >>>= 7;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        this.buf[this.count++] = (byte)n;
    }

    private void ensure(int n) {
        if (this.count + n > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, this.count + n));
        }
    }

    public static int size(Object value, ValueType type) {
        switch (type) {
            case NULL: {
                return 0;
            }
            case INT: {
                return OutputBuffer.size((Integer)value);
            }
            case LONG: {
                return OutputBuffer.size((Long)value);
            }
            case FIXED32: 
            case FLOAT: {
                return 4;
            }
            case FIXED64: 
            case DOUBLE: {
                return 8;
            }
            case STRING: {
                return OutputBuffer.size((String)value);
            }
            case BYTES: {
                if (value instanceof ByteBuffer) {
                    return OutputBuffer.size((ByteBuffer)value);
                }
                return OutputBuffer.size((byte[])value);
            }
        }
        throw new TrevniRuntimeException("Unknown value type: " + (Object)((Object)type));
    }

    public static int size(int n) {
        if ((n = n << 1 ^ n >> 31) <= 127) {
            return 1;
        }
        if (n <= 16383) {
            return 2;
        }
        if (n <= 0x1FFFFF) {
            return 3;
        }
        if (n <= 0xFFFFFFF) {
            return 4;
        }
        return 5;
    }

    public static int size(long n) {
        if ((n = n << 1 ^ n >> 63) <= 127L) {
            return 1;
        }
        if (n <= 16383L) {
            return 2;
        }
        if (n <= 0x1FFFFFL) {
            return 3;
        }
        if (n <= 0xFFFFFFFL) {
            return 4;
        }
        if (n <= 7L) {
            return 5;
        }
        if (n <= 1023L) {
            return 6;
        }
        if (n <= 131071L) {
            return 7;
        }
        if (n <= 0xFFFFFFL) {
            return 8;
        }
        if (n <= Integer.MAX_VALUE) {
            return 9;
        }
        return 10;
    }

    public static int size(ByteBuffer bytes) {
        int length = bytes.remaining();
        return OutputBuffer.size(length) + length;
    }

    public static int size(byte[] bytes) {
        int length = bytes.length;
        return OutputBuffer.size(length) + length;
    }

    public static int size(String string) {
        int length = OutputBuffer.utf8Length(string);
        return OutputBuffer.size(length) + length;
    }

    private static int utf8Length(String string) {
        int stringLength = string.length();
        int utf8Length = 0;
        for (int i = 0; i < stringLength; ++i) {
            int c;
            int p = c = string.charAt(i);
            if (Character.isHighSurrogate((char)c) && i != stringLength - 1 && Character.isLowSurrogate(string.charAt(i + 1))) {
                p = string.codePointAt(i);
                ++i;
            }
            if (p <= 127) {
                ++utf8Length;
                continue;
            }
            if (p <= 2047) {
                utf8Length += 2;
                continue;
            }
            if (p <= 65535) {
                utf8Length += 3;
                continue;
            }
            if (p <= 0x1FFFFF) {
                utf8Length += 4;
                continue;
            }
            if (p <= 0x3FFFFFF) {
                utf8Length += 5;
                continue;
            }
            utf8Length += 6;
        }
        return utf8Length;
    }
}

