/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.namenode.StoragePolicySummary;
import org.junit.Assert;
import org.junit.Test;

public class TestStoragePolicySummary {
    private Map<String, Long> convertToStringMap(StoragePolicySummary sts) {
        LinkedHashMap<String, Long> actualOutput = new LinkedHashMap<String, Long>();
        for (Map.Entry entry : StoragePolicySummary.sortByComparator((Map)sts.storageComboCounts)) {
            actualOutput.put(((StoragePolicySummary.StorageTypeAllocation)entry.getKey()).toString(), (Long)entry.getValue());
        }
        return actualOutput;
    }

    @Test
    public void testMultipleHots() {
        BlockStoragePolicySuite bsps = BlockStoragePolicySuite.createDefaultSuite();
        StoragePolicySummary sts = new StoragePolicySummary(bsps.getAllPolicies());
        BlockStoragePolicy hot = bsps.getPolicy("HOT");
        sts.add(new StorageType[]{StorageType.DISK}, hot);
        sts.add(new StorageType[]{StorageType.DISK, StorageType.DISK}, hot);
        sts.add(new StorageType[]{StorageType.DISK, StorageType.DISK, StorageType.DISK}, hot);
        sts.add(new StorageType[]{StorageType.DISK, StorageType.DISK, StorageType.DISK, StorageType.DISK}, hot);
        Map<String, Long> actualOutput = this.convertToStringMap(sts);
        Assert.assertEquals((long)4L, (long)actualOutput.size());
        HashMap<String, Long> expectedOutput = new HashMap<String, Long>();
        expectedOutput.put("HOT|DISK:1(HOT)", 1L);
        expectedOutput.put("HOT|DISK:2(HOT)", 1L);
        expectedOutput.put("HOT|DISK:3(HOT)", 1L);
        expectedOutput.put("HOT|DISK:4(HOT)", 1L);
        Assert.assertEquals(expectedOutput, actualOutput);
    }

    @Test
    public void testMultipleHotsWithDifferentCounts() {
        BlockStoragePolicySuite bsps = BlockStoragePolicySuite.createDefaultSuite();
        StoragePolicySummary sts = new StoragePolicySummary(bsps.getAllPolicies());
        BlockStoragePolicy hot = bsps.getPolicy("HOT");
        sts.add(new StorageType[]{StorageType.DISK}, hot);
        sts.add(new StorageType[]{StorageType.DISK, StorageType.DISK}, hot);
        sts.add(new StorageType[]{StorageType.DISK, StorageType.DISK}, hot);
        sts.add(new StorageType[]{StorageType.DISK, StorageType.DISK, StorageType.DISK}, hot);
        sts.add(new StorageType[]{StorageType.DISK, StorageType.DISK, StorageType.DISK}, hot);
        sts.add(new StorageType[]{StorageType.DISK, StorageType.DISK, StorageType.DISK, StorageType.DISK}, hot);
        Map<String, Long> actualOutput = this.convertToStringMap(sts);
        Assert.assertEquals((long)4L, (long)actualOutput.size());
        HashMap<String, Long> expectedOutput = new HashMap<String, Long>();
        expectedOutput.put("HOT|DISK:1(HOT)", 1L);
        expectedOutput.put("HOT|DISK:2(HOT)", 2L);
        expectedOutput.put("HOT|DISK:3(HOT)", 2L);
        expectedOutput.put("HOT|DISK:4(HOT)", 1L);
        Assert.assertEquals(expectedOutput, actualOutput);
    }

    @Test
    public void testMultipleWarmsInDifferentOrder() {
        BlockStoragePolicySuite bsps = BlockStoragePolicySuite.createDefaultSuite();
        StoragePolicySummary sts = new StoragePolicySummary(bsps.getAllPolicies());
        BlockStoragePolicy warm = bsps.getPolicy("WARM");
        sts.add(new StorageType[]{StorageType.DISK, StorageType.ARCHIVE}, warm);
        sts.add(new StorageType[]{StorageType.ARCHIVE, StorageType.DISK}, warm);
        sts.add(new StorageType[]{StorageType.ARCHIVE, StorageType.DISK, StorageType.DISK}, warm);
        sts.add(new StorageType[]{StorageType.DISK, StorageType.ARCHIVE, StorageType.DISK}, warm);
        sts.add(new StorageType[]{StorageType.DISK, StorageType.DISK, StorageType.ARCHIVE}, warm);
        sts.add(new StorageType[]{StorageType.DISK, StorageType.ARCHIVE, StorageType.ARCHIVE}, warm);
        sts.add(new StorageType[]{StorageType.ARCHIVE, StorageType.DISK, StorageType.ARCHIVE}, warm);
        sts.add(new StorageType[]{StorageType.ARCHIVE, StorageType.ARCHIVE, StorageType.DISK}, warm);
        sts.add(new StorageType[]{StorageType.ARCHIVE, StorageType.ARCHIVE, StorageType.DISK, StorageType.DISK}, warm);
        Map<String, Long> actualOutput = this.convertToStringMap(sts);
        Assert.assertEquals((long)4L, (long)actualOutput.size());
        HashMap<String, Long> expectedOutput = new HashMap<String, Long>();
        expectedOutput.put("WARM|DISK:1,ARCHIVE:1(WARM)", 2L);
        expectedOutput.put("WARM|DISK:2,ARCHIVE:1", 3L);
        expectedOutput.put("WARM|DISK:1,ARCHIVE:2(WARM)", 3L);
        expectedOutput.put("WARM|DISK:2,ARCHIVE:2", 1L);
        Assert.assertEquals(expectedOutput, actualOutput);
    }

    @Test
    public void testDifferentSpecifiedPolicies() {
        BlockStoragePolicySuite bsps = BlockStoragePolicySuite.createDefaultSuite();
        StoragePolicySummary sts = new StoragePolicySummary(bsps.getAllPolicies());
        BlockStoragePolicy hot = bsps.getPolicy("HOT");
        BlockStoragePolicy warm = bsps.getPolicy("WARM");
        BlockStoragePolicy cold = bsps.getPolicy("COLD");
        sts.add(new StorageType[]{StorageType.DISK, StorageType.DISK, StorageType.DISK}, hot);
        sts.add(new StorageType[]{StorageType.DISK, StorageType.DISK, StorageType.DISK}, hot);
        sts.add(new StorageType[]{StorageType.DISK, StorageType.DISK, StorageType.DISK}, warm);
        sts.add(new StorageType[]{StorageType.DISK, StorageType.DISK, StorageType.DISK}, cold);
        sts.add(new StorageType[]{StorageType.DISK, StorageType.ARCHIVE, StorageType.ARCHIVE}, hot);
        sts.add(new StorageType[]{StorageType.ARCHIVE, StorageType.DISK, StorageType.ARCHIVE}, warm);
        sts.add(new StorageType[]{StorageType.ARCHIVE, StorageType.ARCHIVE, StorageType.DISK}, cold);
        sts.add(new StorageType[]{StorageType.ARCHIVE, StorageType.ARCHIVE, StorageType.DISK}, cold);
        sts.add(new StorageType[]{StorageType.ARCHIVE, StorageType.ARCHIVE, StorageType.ARCHIVE}, hot);
        sts.add(new StorageType[]{StorageType.ARCHIVE, StorageType.ARCHIVE, StorageType.ARCHIVE}, hot);
        sts.add(new StorageType[]{StorageType.ARCHIVE, StorageType.ARCHIVE, StorageType.ARCHIVE}, warm);
        sts.add(new StorageType[]{StorageType.ARCHIVE, StorageType.ARCHIVE, StorageType.ARCHIVE}, cold);
        Map<String, Long> actualOutput = this.convertToStringMap(sts);
        Assert.assertEquals((long)9L, (long)actualOutput.size());
        HashMap<String, Long> expectedOutput = new HashMap<String, Long>();
        expectedOutput.put("HOT|DISK:3(HOT)", 2L);
        expectedOutput.put("COLD|DISK:1,ARCHIVE:2(WARM)", 2L);
        expectedOutput.put("HOT|ARCHIVE:3(COLD)", 2L);
        expectedOutput.put("WARM|DISK:3(HOT)", 1L);
        expectedOutput.put("COLD|DISK:3(HOT)", 1L);
        expectedOutput.put("WARM|ARCHIVE:3(COLD)", 1L);
        expectedOutput.put("WARM|DISK:1,ARCHIVE:2(WARM)", 1L);
        expectedOutput.put("COLD|ARCHIVE:3(COLD)", 1L);
        expectedOutput.put("HOT|DISK:1,ARCHIVE:2(WARM)", 1L);
        Assert.assertEquals(expectedOutput, actualOutput);
    }

    @Test
    public void testSortInDescendingOrder() {
        BlockStoragePolicySuite bsps = BlockStoragePolicySuite.createDefaultSuite();
        StoragePolicySummary sts = new StoragePolicySummary(bsps.getAllPolicies());
        BlockStoragePolicy hot = bsps.getPolicy("HOT");
        BlockStoragePolicy warm = bsps.getPolicy("WARM");
        BlockStoragePolicy cold = bsps.getPolicy("COLD");
        sts.add(new StorageType[]{StorageType.DISK, StorageType.DISK, StorageType.DISK}, hot);
        sts.add(new StorageType[]{StorageType.DISK, StorageType.DISK, StorageType.DISK}, hot);
        sts.add(new StorageType[]{StorageType.DISK, StorageType.ARCHIVE, StorageType.ARCHIVE}, warm);
        sts.add(new StorageType[]{StorageType.ARCHIVE, StorageType.DISK, StorageType.ARCHIVE}, warm);
        sts.add(new StorageType[]{StorageType.ARCHIVE, StorageType.ARCHIVE, StorageType.DISK}, warm);
        sts.add(new StorageType[]{StorageType.ARCHIVE, StorageType.ARCHIVE, StorageType.ARCHIVE}, cold);
        sts.add(new StorageType[]{StorageType.ARCHIVE, StorageType.ARCHIVE, StorageType.ARCHIVE}, cold);
        sts.add(new StorageType[]{StorageType.ARCHIVE, StorageType.ARCHIVE, StorageType.ARCHIVE}, cold);
        sts.add(new StorageType[]{StorageType.ARCHIVE, StorageType.ARCHIVE, StorageType.ARCHIVE}, cold);
        Map<String, Long> actualOutput = this.convertToStringMap(sts);
        Assert.assertEquals((long)3L, (long)actualOutput.size());
        LinkedHashMap<String, Long> expectedOutput = new LinkedHashMap<String, Long>();
        expectedOutput.put("COLD|ARCHIVE:3(COLD)", 4L);
        expectedOutput.put("WARM|DISK:1,ARCHIVE:2(WARM)", 3L);
        expectedOutput.put("HOT|DISK:3(HOT)", 2L);
        Assert.assertEquals((Object)((Object)expectedOutput).toString(), (Object)actualOutput.toString());
    }
}

