/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.blockmanagement.SlowPeerJsonReport;
import org.apache.hadoop.hdfs.server.blockmanagement.SlowPeerLatencyWithReportingNode;
import org.apache.hadoop.hdfs.server.blockmanagement.SlowPeerTracker;
import org.apache.hadoop.hdfs.server.protocol.OutlierMetrics;
import org.apache.hadoop.util.FakeTimer;
import org.apache.hadoop.util.Timer;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSlowPeerTracker {
    private static final Logger LOG = LoggerFactory.getLogger(TestSlowPeerTracker.class);
    @Rule
    public Timeout testTimeout = new Timeout(300000);
    private Configuration conf;
    private SlowPeerTracker tracker;
    private FakeTimer timer;
    private long reportValidityMs;
    private static final ObjectReader READER = new ObjectMapper().readerFor((TypeReference)new TypeReference<Set<SlowPeerJsonReport>>(){});

    @Before
    public void setup() {
        this.conf = new HdfsConfiguration();
        this.timer = new FakeTimer();
        this.tracker = new SlowPeerTracker(this.conf, (Timer)this.timer);
        this.reportValidityMs = this.tracker.getReportValidityMs();
    }

    @Test
    public void testEmptyReports() {
        Assert.assertTrue((boolean)this.tracker.getReportsForAllDataNodes().isEmpty());
        Assert.assertTrue((boolean)this.tracker.getReportsForNode("noSuchNode").isEmpty());
    }

    @Test
    public void testReportsAreRetrieved() {
        this.tracker.addReport("node2", "node1", new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(1.2)));
        this.tracker.addReport("node3", "node1", new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(2.1)));
        this.tracker.addReport("node3", "node2", new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(1.22)));
        Assert.assertThat((Object)this.tracker.getReportsForAllDataNodes().size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.tracker.getReportsForNode("node2").size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.tracker.getReportsForNode("node3").size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.tracker.getReportsForNode("node1").size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void testAllReportsAreExpired() {
        this.tracker.addReport("node2", "node1", new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.123)));
        this.tracker.addReport("node3", "node2", new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.2334)));
        this.tracker.addReport("node1", "node3", new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(1.234)));
        this.timer.advance(1L);
        Assert.assertThat((Object)this.tracker.getReportsForAllDataNodes().size(), (Matcher)Is.is((Object)3));
        this.timer.advance(this.reportValidityMs);
        Assert.assertTrue((boolean)this.tracker.getReportsForAllDataNodes().isEmpty());
        Assert.assertTrue((boolean)this.tracker.getReportsForNode("node1").isEmpty());
        Assert.assertTrue((boolean)this.tracker.getReportsForNode("node2").isEmpty());
        Assert.assertTrue((boolean)this.tracker.getReportsForNode("node3").isEmpty());
    }

    @Test
    public void testSomeReportsAreExpired() {
        this.tracker.addReport("node3", "node1", new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(1.234)));
        this.tracker.addReport("node3", "node2", new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(1.222)));
        this.timer.advance(this.reportValidityMs);
        this.tracker.addReport("node3", "node4", new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(1.2)));
        Assert.assertThat((Object)this.tracker.getReportsForAllDataNodes().size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.tracker.getReportsForNode("node3").size(), (Matcher)Is.is((Object)1));
        Assert.assertEquals((long)1L, (long)this.tracker.getReportsForNode("node3").stream().filter(e -> e.getReportingNode().equals("node4")).count());
    }

    @Test
    public void testReplacement() {
        OutlierMetrics outlierMetrics1 = new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(2.1));
        this.tracker.addReport("node2", "node1", outlierMetrics1);
        this.timer.advance(this.reportValidityMs);
        Assert.assertThat((Object)this.tracker.getReportsForAllDataNodes().size(), (Matcher)Is.is((Object)0));
        OutlierMetrics outlierMetrics2 = new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.001));
        this.tracker.addReport("node2", "node1", outlierMetrics2);
        Assert.assertThat((Object)this.tracker.getReportsForAllDataNodes().size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.tracker.getReportsForNode("node2").size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void testGetJson() throws IOException {
        OutlierMetrics outlierMetrics1 = new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(1.1));
        this.tracker.addReport("node1", "node2", outlierMetrics1);
        OutlierMetrics outlierMetrics2 = new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(1.23));
        this.tracker.addReport("node2", "node3", outlierMetrics2);
        OutlierMetrics outlierMetrics3 = new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(2.13));
        this.tracker.addReport("node2", "node1", outlierMetrics3);
        OutlierMetrics outlierMetrics4 = new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(1.244));
        this.tracker.addReport("node4", "node1", outlierMetrics4);
        Set<SlowPeerJsonReport> reports = this.getAndDeserializeJson();
        Assert.assertThat((Object)reports.size(), (Matcher)Is.is((Object)3));
        Assert.assertTrue((boolean)this.isNodeInReports(reports, "node1"));
        Assert.assertTrue((boolean)this.isNodeInReports(reports, "node2"));
        Assert.assertTrue((boolean)this.isNodeInReports(reports, "node4"));
        Assert.assertFalse((boolean)this.isNodeInReports(reports, "node3"));
    }

    @Test
    public void testGetJsonSizeIsLimited() throws IOException {
        this.tracker.addReport("node1", "node2", new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(1.634)));
        this.tracker.addReport("node1", "node3", new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(2.3566)));
        this.tracker.addReport("node2", "node3", new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(3.869)));
        this.tracker.addReport("node2", "node4", new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(4.1356)));
        this.tracker.addReport("node3", "node4", new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(1.73057)));
        this.tracker.addReport("node3", "node5", new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(2.495673)));
        this.tracker.addReport("node4", "node6", new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(3.29847)));
        this.tracker.addReport("node5", "node6", new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(4.13444)));
        this.tracker.addReport("node5", "node7", new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(5.10845)));
        this.tracker.addReport("node6", "node8", new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(2.37464)));
        this.tracker.addReport("node6", "node7", new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(1.29475656)));
        Set<SlowPeerJsonReport> reports = this.getAndDeserializeJson();
        Assert.assertFalse((boolean)this.isNodeInReports(reports, "node4"));
        Assert.assertTrue((boolean)this.isNodeInReports(reports, "node1"));
        Assert.assertTrue((boolean)this.isNodeInReports(reports, "node2"));
        Assert.assertTrue((boolean)this.isNodeInReports(reports, "node3"));
        Assert.assertTrue((boolean)this.isNodeInReports(reports, "node5"));
        Assert.assertTrue((boolean)this.isNodeInReports(reports, "node6"));
        Assert.assertEquals((long)1L, (long)reports.stream().filter(e -> e.getSlowNode().equals("node1") && e.getSlowPeerLatencyWithReportingNodes().size() == 2 && ((SlowPeerLatencyWithReportingNode)e.getSlowPeerLatencyWithReportingNodes().first()).getReportedLatency().equals(1.634) && ((SlowPeerLatencyWithReportingNode)e.getSlowPeerLatencyWithReportingNodes().last()).getReportedLatency().equals(2.3566)).count());
        Assert.assertEquals((long)1L, (long)reports.stream().filter(e -> e.getSlowNode().equals("node2") && e.getSlowPeerLatencyWithReportingNodes().size() == 2 && ((SlowPeerLatencyWithReportingNode)e.getSlowPeerLatencyWithReportingNodes().first()).getReportedLatency().equals(3.869) && ((SlowPeerLatencyWithReportingNode)e.getSlowPeerLatencyWithReportingNodes().last()).getReportedLatency().equals(4.1356)).count());
        Assert.assertEquals((long)1L, (long)reports.stream().filter(e -> e.getSlowNode().equals("node3") && e.getSlowPeerLatencyWithReportingNodes().size() == 2 && ((SlowPeerLatencyWithReportingNode)e.getSlowPeerLatencyWithReportingNodes().first()).getReportedLatency().equals(1.73057) && ((SlowPeerLatencyWithReportingNode)e.getSlowPeerLatencyWithReportingNodes().last()).getReportedLatency().equals(2.495673)).count());
        Assert.assertEquals((long)1L, (long)reports.stream().filter(e -> e.getSlowNode().equals("node6") && e.getSlowPeerLatencyWithReportingNodes().size() == 2 && ((SlowPeerLatencyWithReportingNode)e.getSlowPeerLatencyWithReportingNodes().first()).getReportedLatency().equals(1.29475656) && ((SlowPeerLatencyWithReportingNode)e.getSlowPeerLatencyWithReportingNodes().last()).getReportedLatency().equals(2.37464)).count());
    }

    @Test
    public void testLowRankedElementsIgnored() throws IOException {
        int i;
        for (i = 0; i < 5; ++i) {
            OutlierMetrics outlierMetrics1 = new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(1.295673));
            this.tracker.addReport("node" + i, "reporter1", outlierMetrics1);
            OutlierMetrics outlierMetrics2 = new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(2.3856));
            this.tracker.addReport("node" + i, "reporter2", outlierMetrics2);
        }
        for (i = 10; i < 20; ++i) {
            OutlierMetrics outlierMetrics = new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(3.4957));
            this.tracker.addReport("node" + i, "reporter1", outlierMetrics);
        }
        Set<SlowPeerJsonReport> reports = this.getAndDeserializeJson();
        for (int i2 = 0; i2 < 5; ++i2) {
            Assert.assertTrue((boolean)this.isNodeInReports(reports, "node" + i2));
        }
    }

    private boolean isNodeInReports(Set<SlowPeerJsonReport> reports, String node) {
        for (SlowPeerJsonReport report : reports) {
            if (!report.getSlowNode().equalsIgnoreCase(node)) continue;
            return true;
        }
        return false;
    }

    private Set<SlowPeerJsonReport> getAndDeserializeJson() throws IOException {
        String json = this.tracker.getJson();
        LOG.info("Got JSON: {}", (Object)json);
        return (Set)READER.readValue(json);
    }
}

