/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.ClientGSIContext;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.qjournal.MiniQJMHACluster;
import org.apache.hadoop.hdfs.server.namenode.ha.HAProxyFactory;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.hdfs.server.namenode.ha.ObserverReadProxyProvider;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestStateAlignmentContextWithHA {
    public static final Logger LOG = LoggerFactory.getLogger((String)TestStateAlignmentContextWithHA.class.getName());
    private static final int NUMDATANODES = 1;
    private static final int NUMCLIENTS = 10;
    private static final int NUMFILES = 120;
    private static final Configuration CONF = new HdfsConfiguration();
    private static final List<ClientGSIContext> AC_LIST = new ArrayList<ClientGSIContext>();
    private static MiniQJMHACluster qjmhaCluster;
    private static MiniDFSCluster cluster;
    private static List<Worker> clients;
    private DistributedFileSystem dfs;
    private int active = 0;
    private int standby = 1;

    @BeforeClass
    public static void startUpCluster() throws IOException {
        CONF.setInt("dfs.client.retry.window.base", 10);
        CONF.setBoolean(String.format("fs.%s.impl.disable.cache", "hdfs"), true);
        CONF.setInt("dfs.replication", 1);
        CONF.setBoolean("dfs.namenode.state.context.enabled", true);
        qjmhaCluster = HATestUtil.setUpObserverCluster(CONF, 1, 1, true);
        cluster = qjmhaCluster.getDfsCluster();
    }

    @Before
    public void before() throws IOException, URISyntaxException {
        this.dfs = HATestUtil.configureObserverReadFs(cluster, CONF, ORPPwithAlignmentContexts.class, true);
    }

    @AfterClass
    public static void shutDownCluster() throws IOException {
        if (qjmhaCluster != null) {
            qjmhaCluster.shutdown();
        }
    }

    @After
    public void after() throws IOException {
        this.killWorkers();
        cluster.transitionToStandby(1);
        cluster.transitionToActive(0);
        this.active = 0;
        this.standby = 1;
        if (this.dfs != null) {
            this.dfs.close();
            this.dfs = null;
        }
        AC_LIST.clear();
    }

    @Test
    public void testStateTransferOnWrite() throws Exception {
        long preWriteState = cluster.getNamesystem(this.active).getLastWrittenTransactionId();
        DFSTestUtil.writeFile((FileSystem)this.dfs, new Path("/testFile1"), "abc");
        long clientState = this.getContext(0).getLastSeenStateId();
        long postWriteState = cluster.getNamesystem(this.active).getLastWrittenTransactionId();
        Assert.assertTrue((clientState > preWriteState ? 1 : 0) != 0);
        Assert.assertEquals((long)clientState, (long)postWriteState);
    }

    @Test
    public void testStateTransferOnRead() throws Exception {
        DFSTestUtil.writeFile((FileSystem)this.dfs, new Path("/testFile2"), "123");
        long lastWrittenId = cluster.getNamesystem(this.active).getLastWrittenTransactionId();
        DFSTestUtil.readFile((FileSystem)this.dfs, new Path("/testFile2"));
        long clientState = this.getContext(0).getLastSeenStateId();
        Assert.assertEquals((long)clientState, (long)lastWrittenId);
    }

    @Test
    public void testStateTransferOnFreshClient() throws Exception {
        DFSTestUtil.writeFile((FileSystem)this.dfs, new Path("/testFile3"), "ezpz");
        long lastWrittenId = cluster.getNamesystem(this.active).getLastWrittenTransactionId();
        try (DistributedFileSystem clearDfs = HATestUtil.configureObserverReadFs(cluster, CONF, ORPPwithAlignmentContexts.class, true);){
            ClientGSIContext clientState = this.getContext(1);
            Assert.assertEquals((long)clientState.getLastSeenStateId(), (long)Long.MIN_VALUE);
            DFSTestUtil.readFile((FileSystem)clearDfs, new Path("/testFile3"));
            Assert.assertEquals((long)clientState.getLastSeenStateId(), (long)lastWrittenId);
        }
    }

    @Test
    public void testStateTransferOnWriteWithFailover() throws Exception {
        long preWriteState = cluster.getNamesystem(this.active).getLastWrittenTransactionId();
        DFSTestUtil.writeFile((FileSystem)this.dfs, new Path("/testFile1FO"), "123");
        long clientState = this.getContext(0).getLastSeenStateId();
        long postWriteState = cluster.getNamesystem(this.active).getLastWrittenTransactionId();
        Assert.assertTrue((clientState > preWriteState ? 1 : 0) != 0);
        Assert.assertEquals((long)clientState, (long)postWriteState);
        this.failOver();
        DFSTestUtil.writeFile((FileSystem)this.dfs, new Path("/testFile2FO"), "456");
        long clientStateFO = this.getContext(0).getLastSeenStateId();
        long writeStateFO = cluster.getNamesystem(this.active).getLastWrittenTransactionId();
        Assert.assertTrue((clientStateFO > postWriteState ? 1 : 0) != 0);
        Assert.assertEquals((long)clientStateFO, (long)writeStateFO);
    }

    @Test(timeout=300000L)
    public void testMultiClientStatesWithRandomFailovers() throws Exception {
        this.runClientsWithFailover(1, 5, 60);
        this.runClientsWithFailover(6, 10, 60);
    }

    private void runClientsWithFailover(int clientStartId, int numClients, int numFiles) throws Exception {
        ExecutorService execService = Executors.newFixedThreadPool(2);
        clients = new ArrayList<Worker>(numClients);
        for (int i = clientStartId; i <= numClients; ++i) {
            DistributedFileSystem haClient = HATestUtil.configureObserverReadFs(cluster, CONF, ORPPwithAlignmentContexts.class, true);
            clients.add(new Worker(haClient, numFiles, "/testFile3FO_", i));
        }
        List<Future<STATE>> futures = TestStateAlignmentContextWithHA.submitAll(execService, clients);
        execService.shutdown();
        boolean finished = false;
        this.failOver();
        while (!finished) {
            finished = execService.awaitTermination(20L, TimeUnit.SECONDS);
        }
        for (Future<STATE> future : futures) {
            Assert.assertEquals((Object)((Object)future.get()), (Object)((Object)STATE.SUCCESS));
        }
        clients.clear();
    }

    private ClientGSIContext getContext(int clientCreationIndex) {
        return AC_LIST.get(clientCreationIndex);
    }

    private void failOver() throws IOException {
        LOG.info("Transitioning Active to Standby");
        cluster.transitionToStandby(this.active);
        LOG.info("Transitioning Standby to Active");
        cluster.transitionToActive(this.standby);
        int tempActive = this.active;
        this.active = this.standby;
        this.standby = tempActive;
    }

    private static List<Future<STATE>> submitAll(ExecutorService executor, Collection<Worker> calls) {
        ArrayList<Future<STATE>> futures = new ArrayList<Future<STATE>>(calls.size());
        for (Worker call : calls) {
            Future<STATE> future = executor.submit(call);
            futures.add(future);
        }
        return futures;
    }

    private void killWorkers() throws IOException {
        if (clients != null) {
            for (Worker worker : clients) {
                worker.kill();
            }
            clients = null;
        }
    }

    private class Worker
    implements Callable<STATE> {
        private final DistributedFileSystem client;
        private final int filesToMake;
        private String filePath;
        private final int nonce;

        Worker(DistributedFileSystem client, int filesToMake, String filePath, int nonce) {
            this.client = client;
            this.filesToMake = filesToMake;
            this.filePath = filePath;
            this.nonce = nonce;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public STATE call() {
            int i = -1;
            try {
                STATE gsiContext;
                for (i = 0; i < this.filesToMake; ++i) {
                    gsiContext = TestStateAlignmentContextWithHA.this.getContext(this.nonce);
                    long preClientStateFO = gsiContext.getLastSeenStateId();
                    Path path = new Path(this.filePath + this.nonce + "_" + i);
                    DFSTestUtil.writeFile((FileSystem)this.client, path, "erk");
                    long postClientStateFO = gsiContext.getLastSeenStateId();
                    if (postClientStateFO < 0L || postClientStateFO <= preClientStateFO) {
                        LOG.error("FAIL: Worker started with: {} , but finished with: {}", (Object)preClientStateFO, (Object)postClientStateFO);
                        STATE sTATE = STATE.FAIL;
                        return sTATE;
                    }
                    if (i % 12 != 0) continue;
                    LOG.info("Worker {} created {} files", (Object)this.nonce, (Object)i);
                    LOG.info("LastSeenStateId = {}", (Object)postClientStateFO);
                }
                gsiContext = STATE.SUCCESS;
                return gsiContext;
            }
            catch (Exception e) {
                LOG.error("ERROR: Worker failed with: ", (Throwable)e);
                STATE sTATE = STATE.ERROR;
                return sTATE;
            }
            finally {
                LOG.info("Worker {} created {} files", (Object)this.nonce, (Object)i);
            }
        }

        public void kill() throws IOException {
            this.client.dfs.closeAllFilesBeingWritten(true);
            this.client.dfs.closeOutputStreams(true);
            this.client.dfs.closeConnectionToNamenode();
            this.client.dfs.close();
            this.client.close();
        }
    }

    private static enum STATE {
        SUCCESS,
        FAIL,
        ERROR;

    }

    static class ORPPwithAlignmentContexts<T extends ClientProtocol>
    extends ObserverReadProxyProvider<T> {
        public ORPPwithAlignmentContexts(Configuration conf, URI uri, Class<T> xface, HAProxyFactory<T> factory) throws IOException {
            super(conf, uri, xface, factory);
            AC_LIST.add((ClientGSIContext)this.getAlignmentContext());
        }
    }
}

