/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.LoadFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POMergeJoin;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.ObjectCache;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.TezInput;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.builtin.TezIndexableLoader;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.library.api.KeyValueReader;

public class POMergeJoinTez
extends POMergeJoin
implements TezInput {
    private static final Log LOG = LogFactory.getLog(POMergeJoinTez.class);
    private static final long serialVersionUID = 1L;
    private String inputKey;
    private transient String cacheKey;
    private transient KeyValueReader reader;
    private LinkedList<Tuple> index;

    public POMergeJoinTez(POMergeJoin joinOp) {
        super(joinOp);
    }

    public void setInputKey(String inputKey) {
        this.inputKey = inputKey;
    }

    @Override
    public String[] getTezInputs() {
        return new String[]{this.inputKey};
    }

    @Override
    public void replaceInput(String oldInputKey, String newInputKey) {
        this.inputKey = newInputKey;
    }

    @Override
    public void addInputsToSkip(Set<String> inputsToSkip) {
        this.cacheKey = "merge-" + this.inputKey;
        Object cacheValue = ObjectCache.getInstance().retrieve(this.cacheKey);
        if (cacheValue != null) {
            inputsToSkip.add(this.inputKey);
        }
    }

    @Override
    public void attachInputs(Map<String, LogicalInput> inputs, Configuration conf) throws ExecException {
        Object cacheValue = ObjectCache.getInstance().retrieve(this.cacheKey);
        if (cacheValue != null) {
            this.index = (LinkedList)cacheValue;
            this.rightLoader = this.getRightLoader();
            return;
        }
        LogicalInput input = inputs.get(this.inputKey);
        if (input == null) {
            throw new ExecException("Input from vertex " + this.inputKey + " is missing");
        }
        try {
            this.reader = (KeyValueReader)input.getReader();
            LOG.info((Object)("Attached input from vertex " + this.inputKey + " : input=" + input + ", reader=" + this.reader));
            this.index = new LinkedList();
            while (this.reader.next()) {
                Tuple origTuple = (Tuple)this.reader.getCurrentValue();
                Tuple copy = mTupleFactory.newTuple(origTuple.getAll());
                this.index.add(copy);
            }
            ObjectCache.getInstance().cache(this.cacheKey, this.index);
            this.rightLoader = this.getRightLoader();
        }
        catch (Exception e) {
            throw new ExecException(e);
        }
    }

    @Override
    public String name() {
        return super.name().replace("MergeJoin", "MergeJoinTez") + "\t<-\t " + this.inputKey;
    }

    @Override
    protected LoadFunc getRightLoader() throws ExecException {
        LoadFunc loader = (LoadFunc)PigContext.instantiateFuncFromSpec(this.rightLoaderFuncSpec);
        if (loader instanceof TezIndexableLoader) {
            ((TezIndexableLoader)loader).setIndex(this.index);
        }
        return loader;
    }

    @Override
    public POMergeJoinTez clone() throws CloneNotSupportedException {
        return (POMergeJoinTez)super.clone();
    }
}

