/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Arrays;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptorUtils;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestTableDescriptorUtils {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTableDescriptorUtils.class);

    @Test
    public void testDelta() {
        ColumnFamilyDescriptor cf1 = ColumnFamilyDescriptorBuilder.of((String)"cf1");
        ColumnFamilyDescriptor cf2 = ColumnFamilyDescriptorBuilder.of((String)"cf2");
        ColumnFamilyDescriptor cf3 = ColumnFamilyDescriptorBuilder.of((String)"cf3");
        ColumnFamilyDescriptor cf4 = ColumnFamilyDescriptorBuilder.of((String)"cf4");
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)"test")).setColumnFamilies(Arrays.asList(cf1, cf2, cf3, cf4)).build();
        TableDescriptorUtils.TableDescriptorDelta selfCompare = TableDescriptorUtils.computeDelta((TableDescriptor)td, (TableDescriptor)td);
        Assert.assertEquals((long)0L, (long)selfCompare.getColumnsAdded().size());
        Assert.assertEquals((long)0L, (long)selfCompare.getColumnsDeleted().size());
        Assert.assertEquals((long)0L, (long)selfCompare.getColumnsModified().size());
        ColumnFamilyDescriptor modCf2 = ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)cf2).setMaxVersions(5).build();
        ColumnFamilyDescriptor modCf3 = ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)cf3).setMaxVersions(5).build();
        ColumnFamilyDescriptor cf5 = ColumnFamilyDescriptorBuilder.of((String)"cf5");
        ColumnFamilyDescriptor cf6 = ColumnFamilyDescriptorBuilder.of((String)"cf6");
        ColumnFamilyDescriptor cf7 = ColumnFamilyDescriptorBuilder.of((String)"cf7");
        TableDescriptor newTd = TableDescriptorBuilder.newBuilder((TableDescriptor)td).removeColumnFamily(Bytes.toBytes((String)"cf1")).modifyColumnFamily(modCf2).modifyColumnFamily(modCf3).setColumnFamily(cf5).setColumnFamily(cf6).setColumnFamily(cf7).build();
        TableDescriptorUtils.TableDescriptorDelta delta = TableDescriptorUtils.computeDelta((TableDescriptor)td, (TableDescriptor)newTd);
        Assert.assertEquals((long)3L, (long)delta.getColumnsAdded().size());
        Assert.assertEquals((long)1L, (long)delta.getColumnsDeleted().size());
        Assert.assertEquals((long)2L, (long)delta.getColumnsModified().size());
        TableDescriptorUtils.TableDescriptorDelta inverseDelta = TableDescriptorUtils.computeDelta((TableDescriptor)newTd, (TableDescriptor)td);
        Assert.assertEquals((Object)delta.getColumnsDeleted(), (Object)inverseDelta.getColumnsAdded());
        Assert.assertEquals((Object)delta.getColumnsAdded(), (Object)inverseDelta.getColumnsDeleted());
        Assert.assertEquals((Object)delta.getColumnsModified(), (Object)inverseDelta.getColumnsModified());
    }
}

