/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.MasterRegistry;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hbase.thirdparty.com.google.protobuf.BlockingRpcChannel;
import org.apache.hbase.thirdparty.com.google.protobuf.Descriptors;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcCallback;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcChannel;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClientTests.class, SmallTests.class})
public class TestMasterRegistryHedgedReads {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterRegistryHedgedReads.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestMasterRegistryHedgedReads.class);
    private static final HBaseCommonTestingUtility UTIL = new HBaseCommonTestingUtility();
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).build());
    private static AtomicInteger CALLED = new AtomicInteger(0);
    private static volatile int BAD_RESP_INDEX;
    private static volatile Set<Integer> GOOD_RESP_INDEXS;
    private static MasterProtos.GetClusterIdResponse RESP;

    @BeforeClass
    public static void setUpBeforeClass() {
        Configuration conf = UTIL.getConfiguration();
        conf.setClass("hbase.rpc.client.impl", RpcClientImpl.class, RpcClient.class);
        String masters = IntStream.range(0, 10).mapToObj(i -> "localhost:" + (10000 + 100 * i)).collect(Collectors.joining(","));
        conf.set("hbase.masters", masters);
    }

    @AfterClass
    public static void tearDownAfterClass() {
        EXECUTOR.shutdownNow();
    }

    @Before
    public void setUp() {
        CALLED.set(0);
        BAD_RESP_INDEX = -1;
        GOOD_RESP_INDEXS = Collections.emptySet();
    }

    private <T> T logIfError(CompletableFuture<T> future) throws IOException {
        try {
            return (T)FutureUtils.get(future);
        }
        catch (Throwable t) {
            LOG.warn("", t);
            throw t;
        }
    }

    @Test
    public void testAllFailNoHedged() throws IOException {
        Configuration conf = UTIL.getConfiguration();
        conf.setInt("hbase.client.master_registry.hedged.fanout", 1);
        try (MasterRegistry registry = new MasterRegistry(conf);){
            Assert.assertThrows(IOException.class, () -> {
                String cfr_ignored_0 = (String)this.logIfError(registry.getClusterId());
            });
            Assert.assertEquals((long)10L, (long)CALLED.get());
        }
    }

    @Test
    public void testAllFailHedged3() throws IOException {
        Configuration conf = UTIL.getConfiguration();
        conf.setInt("hbase.client.master_registry.hedged.fanout", 3);
        BAD_RESP_INDEX = 5;
        try (MasterRegistry registry = new MasterRegistry(conf);){
            Assert.assertThrows(IOException.class, () -> {
                String cfr_ignored_0 = (String)this.logIfError(registry.getClusterId());
            });
            Assert.assertEquals((long)10L, (long)CALLED.get());
        }
    }

    @Test
    public void testFirstSucceededNoHedge() throws IOException {
        Configuration conf = UTIL.getConfiguration();
        conf.setInt("hbase.client.master_registry.hedged.fanout", 0);
        GOOD_RESP_INDEXS = IntStream.range(0, 10).mapToObj(Integer::valueOf).collect(Collectors.toSet());
        try (MasterRegistry registry = new MasterRegistry(conf);){
            String clusterId = (String)this.logIfError(registry.getClusterId());
            Assert.assertEquals((Object)RESP.getClusterId(), (Object)clusterId);
            Assert.assertEquals((long)1L, (long)CALLED.get());
        }
    }

    @Test
    public void testSecondRoundSucceededHedge4() throws IOException {
        Configuration conf = UTIL.getConfiguration();
        conf.setInt("hbase.client.master_registry.hedged.fanout", 4);
        GOOD_RESP_INDEXS = Collections.singleton(6);
        try (MasterRegistry registry = new MasterRegistry(conf);){
            String clusterId = (String)this.logIfError(registry.getClusterId());
            Assert.assertEquals((Object)RESP.getClusterId(), (Object)clusterId);
            UTIL.waitFor(5000L, () -> CALLED.get() == 8);
        }
    }

    @Test
    public void testSucceededWithLargestHedged() throws IOException, InterruptedException {
        Configuration conf = UTIL.getConfiguration();
        conf.setInt("hbase.client.master_registry.hedged.fanout", Integer.MAX_VALUE);
        GOOD_RESP_INDEXS = Collections.singleton(5);
        try (MasterRegistry registry = new MasterRegistry(conf);){
            String clusterId = (String)this.logIfError(registry.getClusterId());
            Assert.assertEquals((Object)RESP.getClusterId(), (Object)clusterId);
            UTIL.waitFor(5000L, () -> CALLED.get() == 10);
            Thread.sleep(1000L);
            Assert.assertEquals((long)10L, (long)CALLED.get());
        }
    }

    static {
        RESP = MasterProtos.GetClusterIdResponse.newBuilder().setClusterId("id").build();
    }

    public static final class RpcChannelImpl
    implements RpcChannel {
        public void callMethod(Descriptors.MethodDescriptor method, RpcController controller, Message request, Message responsePrototype, RpcCallback<Message> done) {
            if (!method.getName().equals("GetClusterId")) {
                return;
            }
            EXECUTOR.execute(() -> {
                int index = CALLED.getAndIncrement();
                if (index == BAD_RESP_INDEX) {
                    done.run((Object)MasterProtos.GetClusterIdResponse.getDefaultInstance());
                } else if (GOOD_RESP_INDEXS.contains(index)) {
                    done.run((Object)RESP);
                } else {
                    controller.setFailed("inject error");
                    done.run(null);
                }
            });
        }
    }

    public static final class RpcClientImpl
    implements RpcClient {
        public RpcClientImpl(Configuration configuration, String clusterId, SocketAddress localAddress, MetricsConnection metrics) {
        }

        public BlockingRpcChannel createBlockingRpcChannel(ServerName sn, User user, int rpcTimeout) throws IOException {
            throw new UnsupportedOperationException();
        }

        public RpcChannel createRpcChannel(ServerName sn, User user, int rpcTimeout) throws IOException {
            return new RpcChannelImpl();
        }

        public void cancelConnections(ServerName sn) {
        }

        public void close() {
        }

        public boolean hasCellBlockSupport() {
            return false;
        }
    }
}

