/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={ClientTests.class, SmallTests.class})
public class TestBufferedMutatorParams {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBufferedMutatorParams.class);
    @Rule
    public TestName name = new TestName();

    @Test
    public void testClone() {
        MockExecutorService pool = new MockExecutorService();
        String tableName = this.name.getMethodName();
        BufferedMutatorParams bmp = new BufferedMutatorParams(TableName.valueOf((String)tableName));
        MockExceptionListener listener = new MockExceptionListener();
        bmp.writeBufferSize(17L).setWriteBufferPeriodicFlushTimeoutMs(123L).setWriteBufferPeriodicFlushTimerTickMs(456L).maxKeyValueSize(13).pool((ExecutorService)pool).listener((BufferedMutator.ExceptionListener)listener);
        bmp.implementationClassName("someClassName");
        BufferedMutatorParams clone = bmp.clone();
        Assert.assertEquals((Object)tableName, (Object)clone.getTableName().toString());
        Assert.assertEquals((long)17L, (long)clone.getWriteBufferSize());
        Assert.assertEquals((long)123L, (long)clone.getWriteBufferPeriodicFlushTimeoutMs());
        Assert.assertEquals((long)456L, (long)clone.getWriteBufferPeriodicFlushTimerTickMs());
        Assert.assertEquals((long)13L, (long)clone.getMaxKeyValueSize());
        Assert.assertEquals((Object)"someClassName", (Object)clone.getImplementationClassName());
        this.cloneTest(bmp, clone);
        BufferedMutatorParams cloneWars = clone.clone();
        this.cloneTest(clone, cloneWars);
        this.cloneTest(bmp, cloneWars);
        clone.implementationClassName(null);
        Assert.assertEquals((Object)"someClassName", (Object)bmp.getImplementationClassName());
    }

    private void cloneTest(BufferedMutatorParams some, BufferedMutatorParams clone) {
        Assert.assertFalse((some == clone ? 1 : 0) != 0);
        Assert.assertEquals((Object)some.getTableName().toString(), (Object)clone.getTableName().toString());
        Assert.assertEquals((long)some.getWriteBufferSize(), (long)clone.getWriteBufferSize());
        Assert.assertEquals((long)some.getWriteBufferPeriodicFlushTimeoutMs(), (long)clone.getWriteBufferPeriodicFlushTimeoutMs());
        Assert.assertEquals((long)some.getWriteBufferPeriodicFlushTimerTickMs(), (long)clone.getWriteBufferPeriodicFlushTimerTickMs());
        Assert.assertEquals((long)some.getMaxKeyValueSize(), (long)clone.getMaxKeyValueSize());
        Assert.assertTrue((some.getListener() == clone.getListener() ? 1 : 0) != 0);
        Assert.assertTrue((some.getPool() == clone.getPool() ? 1 : 0) != 0);
        Assert.assertEquals((Object)some.getImplementationClassName(), (Object)clone.getImplementationClassName());
    }

    private static class MockExceptionListener
    implements BufferedMutator.ExceptionListener {
        private MockExceptionListener() {
        }

        public void onException(RetriesExhaustedWithDetailsException exception, BufferedMutator mutator) throws RetriesExhaustedWithDetailsException {
        }
    }

    private class MockExecutorService
    implements ExecutorService {
        private MockExecutorService() {
        }

        @Override
        public void execute(Runnable command) {
        }

        @Override
        public void shutdown() {
        }

        @Override
        public List<Runnable> shutdownNow() {
            return null;
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return false;
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return null;
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            return null;
        }

        @Override
        public Future<?> submit(Runnable task) {
            return null;
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            return null;
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return null;
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            return null;
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return null;
        }
    }
}

