/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.preemption;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.preemption.KillableContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.preemption.PreemptableQueue;
import org.apache.hadoop.yarn.util.resource.Resources;

public class PreemptionManager {
    private ReentrantReadWriteLock.ReadLock readLock;
    private ReentrantReadWriteLock.WriteLock writeLock;
    private Map<String, PreemptableQueue> entities = new HashMap<String, PreemptableQueue>();

    public PreemptionManager() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshQueues(CSQueue parent, CSQueue current) {
        this.writeLock.lock();
        try {
            PreemptableQueue parentEntity = null;
            if (parent != null) {
                parentEntity = this.entities.get(parent.getQueuePath());
            }
            if (!this.entities.containsKey(current.getQueuePath())) {
                this.entities.put(current.getQueuePath(), new PreemptableQueue(parentEntity));
            }
            if (current.getChildQueues() != null) {
                for (CSQueue child : current.getChildQueues()) {
                    this.refreshQueues(current, child);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void addKillableContainer(KillableContainer container) {
        this.writeLock.lock();
        try {
            PreemptableQueue entity = this.entities.get(container.getLeafQueueName());
            if (null != entity) {
                entity.addKillableContainer(container);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeKillableContainer(KillableContainer container) {
        this.writeLock.lock();
        try {
            PreemptableQueue entity = this.entities.get(container.getLeafQueueName());
            if (null != entity) {
                entity.removeKillableContainer(container);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void moveKillableContainer(KillableContainer oldContainer, KillableContainer newContainer) {
    }

    public void updateKillableContainerResource(KillableContainer container, Resource oldResource, Resource newResource) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public Map<ContainerId, RMContainer> getKillableContainersMap(String queueName, String partition) {
        this.readLock.lock();
        try {
            Map<ContainerId, RMContainer> containers;
            PreemptableQueue entity = this.entities.get(queueName);
            if (entity != null && (containers = entity.getKillableContainers().get(partition)) != null) {
                Map<ContainerId, RMContainer> map = containers;
                return map;
            }
            Map<ContainerId, RMContainer> map = Collections.emptyMap();
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Iterator<RMContainer> getKillableContainers(String queueName, String partition) {
        return this.getKillableContainersMap(queueName, partition).values().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getKillableResource(String queueName, String partition) {
        this.readLock.lock();
        try {
            PreemptableQueue entity = this.entities.get(queueName);
            if (entity != null) {
                Resource res = entity.getTotalKillableResources().get(partition);
                if (res == null || res.equals((Object)Resources.none())) {
                    Resource resource = Resources.none();
                    return resource;
                }
                Resource resource = Resources.clone((Resource)res);
                return resource;
            }
            Resource resource = Resources.none();
            return resource;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, PreemptableQueue> getShallowCopyOfPreemptableQueues() {
        this.readLock.lock();
        try {
            HashMap<String, PreemptableQueue> map = new HashMap<String, PreemptableQueue>();
            for (Map.Entry<String, PreemptableQueue> entry : this.entities.entrySet()) {
                String key = entry.getKey();
                PreemptableQueue entity = entry.getValue();
                map.put(key, new PreemptableQueue(new HashMap<String, Resource>(entity.getTotalKillableResources()), new HashMap<String, Map<ContainerId, RMContainer>>(entity.getKillableContainers())));
            }
            HashMap<String, PreemptableQueue> hashMap = map;
            return hashMap;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

