/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.curator.framework.recipes.leader.LeaderLatchListener;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.EmbeddedElector;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class CuratorBasedElectorService
extends AbstractService
implements EmbeddedElector,
LeaderLatchListener {
    public static final Logger LOG = LoggerFactory.getLogger(CuratorBasedElectorService.class);
    private LeaderLatch leaderLatch;
    private CuratorFramework curator;
    private String latchPath;
    private String rmId;
    private ResourceManager rm;

    public CuratorBasedElectorService(ResourceManager rm) {
        super(CuratorBasedElectorService.class.getName());
        this.rm = rm;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.rmId = HAUtil.getRMHAId((Configuration)conf);
        String clusterId = YarnConfiguration.getClusterId((Configuration)conf);
        String zkBasePath = conf.get("yarn.resourcemanager.ha.automatic-failover.zk-base-path", "/yarn-leader-election");
        this.latchPath = zkBasePath + "/" + clusterId;
        this.curator = this.rm.getCurator();
        this.initAndStartLeaderLatch();
        super.serviceInit(conf);
    }

    private void initAndStartLeaderLatch() throws Exception {
        this.leaderLatch = new LeaderLatch(this.curator, this.latchPath, this.rmId);
        this.leaderLatch.addListener((LeaderLatchListener)this);
        this.leaderLatch.start();
    }

    protected void serviceStop() throws Exception {
        this.closeLeaderLatch();
        super.serviceStop();
    }

    @Override
    public void rejoinElection() {
        try {
            this.closeLeaderLatch();
            Thread.sleep(1000L);
            this.initAndStartLeaderLatch();
        }
        catch (Exception e) {
            LOG.info("Fail to re-join election.", (Throwable)e);
        }
    }

    @Override
    public String getZookeeperConnectionState() {
        return "Connected to zookeeper : " + this.curator.getZookeeperClient().isConnected();
    }

    public void isLeader() {
        LOG.info(this.rmId + "is elected leader, transitioning to active");
        try {
            this.rm.getRMContext().getRMAdminService().transitionToActive(new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_ZKFC));
        }
        catch (Exception e) {
            LOG.info(this.rmId + " failed to transition to active, giving up leadership", (Throwable)e);
            this.notLeader();
            this.rejoinElection();
        }
    }

    private void closeLeaderLatch() throws IOException {
        if (this.leaderLatch != null) {
            this.leaderLatch.close();
        }
    }

    public void notLeader() {
        LOG.info(this.rmId + " relinquish leadership");
        try {
            this.rm.getRMContext().getRMAdminService().transitionToStandby(new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_ZKFC));
        }
        catch (Exception e) {
            LOG.info(this.rmId + " did not transition to standby successfully.");
        }
    }

    @VisibleForTesting
    public CuratorFramework getCuratorClient() {
        return this.curator;
    }
}

