/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.GenericsUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericsUtil {
    @Test
    public void testToArray() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < 10; ++i) {
            list.add(i);
        }
        Integer[] arr = (Integer[])GenericsUtil.toArray(list);
        for (int i = 0; i < arr.length; ++i) {
            Assert.assertEquals((String)"Array has identical elements as input list", list.get(i), (Object)arr[i]);
        }
    }

    @Test
    public void testWithEmptyList() {
        try {
            ArrayList list = new ArrayList();
            String[] arr = (String[])GenericsUtil.toArray(list);
            Assert.fail((String)"Empty array should throw exception");
            System.out.println(arr);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testWithEmptyList2() {
        ArrayList list = new ArrayList();
        String[] arr = (String[])GenericsUtil.toArray(String.class, list);
        Assert.assertEquals((String)"Assert list creation w/ no elements results in length 0", (long)0L, (long)arr.length);
    }

    @Test
    public void testWithGenericClass() {
        GenericClass<String> testSubject = new GenericClass<String>();
        testSubject.add("test1");
        testSubject.add("test2");
        try {
            String[] arr = (String[])testSubject.funcThatUsesToArray();
            Assert.assertEquals((Object)"test1", (Object)arr[0]);
            Assert.assertEquals((Object)"test2", (Object)arr[1]);
        }
        catch (ClassCastException ex) {
            Assert.fail((String)"GenericsUtil#toArray() is not working for generic classes");
        }
    }

    @Test
    public void testGenericOptionsParser() throws Exception {
        GenericOptionsParser parser = new GenericOptionsParser(new Configuration(), new String[]{"-jt"});
        Assert.assertEquals((long)0L, (long)parser.getRemainingArgs().length);
        parser = new GenericOptionsParser(new Configuration(), new String[]{"-Dx=y=z"});
        Assert.assertEquals((String)"Options parser gets entire ='s expresion", (Object)"y=z", (Object)parser.getConfiguration().get("x"));
    }

    @Test
    public void testGetClass() {
        Integer x = new Integer(42);
        Class c = GenericsUtil.getClass((Object)x);
        Assert.assertEquals((String)"Correct generic type is acquired from object", Integer.class, (Object)c);
        GenericClass testSubject = new GenericClass();
        Class c2 = GenericsUtil.getClass(testSubject);
        Assert.assertEquals((String)"Inner generics are acquired from object.", GenericClass.class, (Object)c2);
    }

    @Test
    public void testIsLog4jLogger() throws Exception {
        Assert.assertFalse((String)"False if clazz is null", (boolean)GenericsUtil.isLog4jLogger(null));
        Assert.assertTrue((String)"The implementation is Log4j", (boolean)GenericsUtil.isLog4jLogger(TestGenericsUtil.class));
    }

    private class GenericClass<T> {
        T dummy;
        List<T> list = new ArrayList<T>();

        private GenericClass() {
        }

        void add(T item) {
            this.list.add(item);
        }

        T[] funcThatUsesToArray() {
            Object[] arr = GenericsUtil.toArray(this.list);
            return arr;
        }
    }
}

