/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.CrcUtil;
import org.apache.hadoop.util.DataChecksum;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class TestCrcUtil {
    @Rule
    public Timeout globalTimeout = new Timeout(10000);
    private Random rand = new Random(1234L);

    @Test
    public void testComposeCrc32() throws IOException {
        byte[] data = new byte[65536];
        this.rand.nextBytes(data);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32, 512, false);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32, 511, false);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32, 32768, false);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32, Short.MAX_VALUE, false);
    }

    @Test
    public void testComposeCrc32c() throws IOException {
        byte[] data = new byte[65536];
        this.rand.nextBytes(data);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32C, 512, false);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32C, 511, false);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32C, 32768, false);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32C, Short.MAX_VALUE, false);
    }

    @Test
    public void testComposeCrc32WithMonomial() throws IOException {
        byte[] data = new byte[65536];
        this.rand.nextBytes(data);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32, 512, true);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32, 511, true);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32, 32768, true);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32, Short.MAX_VALUE, true);
    }

    @Test
    public void testComposeCrc32cWithMonomial() throws IOException {
        byte[] data = new byte[65536];
        this.rand.nextBytes(data);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32C, 512, true);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32C, 511, true);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32C, 32768, true);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32C, Short.MAX_VALUE, true);
    }

    @Test
    public void testComposeCrc32ZeroLength() throws IOException {
        TestCrcUtil.doTestComposeCrcZerolength(DataChecksum.Type.CRC32);
    }

    @Test
    public void testComposeCrc32CZeroLength() throws IOException {
        TestCrcUtil.doTestComposeCrcZerolength(DataChecksum.Type.CRC32C);
    }

    private static void doTestComposeCrc(byte[] data, DataChecksum.Type type, int chunkSize, boolean useMonomial) throws IOException {
        int partialCrc;
        int crcPolynomial = DataChecksum.getCrcPolynomialForType((DataChecksum.Type)type);
        DataChecksum checksum = DataChecksum.newDataChecksum((DataChecksum.Type)type, (int)Integer.MAX_VALUE);
        checksum.update(data, 0, data.length);
        int fullCrc = (int)checksum.getValue();
        int compositeCrc = 0;
        int crcMonomial = useMonomial ? CrcUtil.getMonomial((long)chunkSize, (int)crcPolynomial) : 0;
        int offset = 0;
        while (offset + chunkSize <= data.length) {
            checksum.reset();
            checksum.update(data, offset, chunkSize);
            partialCrc = (int)checksum.getValue();
            compositeCrc = useMonomial ? CrcUtil.composeWithMonomial((int)compositeCrc, (int)partialCrc, (int)crcMonomial, (int)crcPolynomial) : CrcUtil.compose((int)compositeCrc, (int)partialCrc, (long)chunkSize, (int)crcPolynomial);
            offset += chunkSize;
        }
        int partialChunkSize = data.length % chunkSize;
        if (partialChunkSize > 0) {
            checksum.reset();
            checksum.update(data, data.length - partialChunkSize, partialChunkSize);
            partialCrc = (int)checksum.getValue();
            compositeCrc = CrcUtil.compose((int)compositeCrc, (int)partialCrc, (long)partialChunkSize, (int)crcPolynomial);
        }
        Assert.assertEquals((String)String.format("Using CRC type '%s' with crcPolynomial '0x%08x' and chunkSize '%d', expected '0x%08x', got '0x%08x'", type, crcPolynomial, chunkSize, fullCrc, compositeCrc), (long)fullCrc, (long)compositeCrc);
    }

    private static void doTestComposeCrcZerolength(DataChecksum.Type type) throws IOException {
        int crcA = -889274641;
        int crcPolynomial = DataChecksum.getCrcPolynomialForType((DataChecksum.Type)type);
        DataChecksum checksum = DataChecksum.newDataChecksum((DataChecksum.Type)type, (int)Integer.MAX_VALUE);
        int crcB = (int)checksum.getValue();
        Assert.assertEquals((long)crcA, (long)CrcUtil.compose((int)crcA, (int)crcB, (long)0L, (int)crcPolynomial));
        int monomial = CrcUtil.getMonomial((long)0L, (int)crcPolynomial);
        Assert.assertEquals((long)crcA, (long)CrcUtil.composeWithMonomial((int)crcA, (int)crcB, (int)monomial, (int)crcPolynomial));
    }

    @Test
    public void testIntSerialization() throws IOException {
        byte[] bytes = CrcUtil.intToBytes((int)-889274641);
        Assert.assertEquals((long)-889274641L, (long)CrcUtil.readInt((byte[])bytes, (int)0));
        bytes = new byte[8];
        CrcUtil.writeInt((byte[])bytes, (int)0, (int)-889274641);
        Assert.assertEquals((long)-889274641L, (long)CrcUtil.readInt((byte[])bytes, (int)0));
        CrcUtil.writeInt((byte[])bytes, (int)4, (int)-1412584499);
        Assert.assertEquals((long)-1412584499L, (long)CrcUtil.readInt((byte[])bytes, (int)4));
        Assert.assertEquals((long)-1091589171L, (long)CrcUtil.readInt((byte[])bytes, (int)2));
    }

    @Test
    public void testToSingleCrcStringBadLength() throws Exception {
        LambdaTestUtils.intercept(IOException.class, "length", () -> CrcUtil.toSingleCrcString((byte[])new byte[8]));
    }

    @Test
    public void testToSingleCrcString() throws IOException {
        byte[] buf = CrcUtil.intToBytes((int)-889274641);
        Assert.assertEquals((Object)"0xcafebeef", (Object)CrcUtil.toSingleCrcString((byte[])buf));
    }

    @Test
    public void testToMultiCrcStringBadLength() throws Exception {
        LambdaTestUtils.intercept(IOException.class, "length", () -> CrcUtil.toMultiCrcString((byte[])new byte[6]));
    }

    @Test
    public void testToMultiCrcStringMultipleElements() throws IOException {
        byte[] buf = new byte[12];
        CrcUtil.writeInt((byte[])buf, (int)0, (int)-889274641);
        CrcUtil.writeInt((byte[])buf, (int)4, (int)-1414804276);
        CrcUtil.writeInt((byte[])buf, (int)8, (int)-572657681);
        Assert.assertEquals((Object)"[0xcafebeef, 0xababcccc, 0xddddefef]", (Object)CrcUtil.toMultiCrcString((byte[])buf));
    }

    @Test
    public void testToMultiCrcStringSingleElement() throws IOException {
        byte[] buf = new byte[4];
        CrcUtil.writeInt((byte[])buf, (int)0, (int)-889274641);
        Assert.assertEquals((Object)"[0xcafebeef]", (Object)CrcUtil.toMultiCrcString((byte[])buf));
    }

    @Test
    public void testToMultiCrcStringNoElements() throws IOException {
        Assert.assertEquals((Object)"[]", (Object)CrcUtil.toMultiCrcString((byte[])new byte[0]));
    }
}

