/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.net.ServerSocketUtil;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.server.api.ResourceTracker;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.UnRegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.UnRegisterNodeManagerResponse;
import org.apache.hadoop.yarn.server.api.records.NodeStatus;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryServer;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.MemoryApplicationHistoryStore;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.DeletionService;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.NodeManager;
import org.apache.hadoop.yarn.server.nodemanager.NodeStatusUpdater;
import org.apache.hadoop.yarn.server.nodemanager.NodeStatusUpdaterImpl;
import org.apache.hadoop.yarn.server.nodemanager.amrmproxy.AMRMProxyService;
import org.apache.hadoop.yarn.server.nodemanager.amrmproxy.DefaultRequestInterceptor;
import org.apache.hadoop.yarn.server.nodemanager.amrmproxy.RequestInterceptor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.ContainerManagerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ContainersMonitor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ContainersMonitorImpl;
import org.apache.hadoop.yarn.server.nodemanager.health.NodeHealthCheckerService;
import org.apache.hadoop.yarn.server.nodemanager.metrics.NodeManagerMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceTrackerService;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptRegistrationEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptUnregistrationEvent;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.server.security.http.RMAuthenticationFilterInitializer;
import org.apache.hadoop.yarn.server.timeline.MemoryTimelineStore;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.apache.hadoop.yarn.server.timeline.recovery.MemoryTimelineStateStore;
import org.apache.hadoop.yarn.server.timeline.recovery.TimelineStateStore;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.util.timeline.TimelineUtils;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class MiniYARNCluster
extends CompositeService {
    private static final Logger LOG = LoggerFactory.getLogger(MiniYARNCluster.class);
    private NodeManager[] nodeManagers;
    private ResourceManager[] resourceManagers;
    private String[] rmIds;
    private ApplicationHistoryServer appHistoryServer;
    private boolean useFixedPorts;
    private boolean useRpc = false;
    private int failoverTimeout;
    private ConcurrentMap<ApplicationAttemptId, Long> appMasters = new ConcurrentHashMap<ApplicationAttemptId, Long>(16, 0.75f, 2);
    private File testWorkDir;
    private int numLocalDirs;
    private int numLogDirs;
    private boolean enableAHS;

    @Deprecated
    public MiniYARNCluster(String testName, int numResourceManagers, int numNodeManagers, int numLocalDirs, int numLogDirs, boolean enableAHS) {
        super(testName.replace("$", ""));
        this.numLocalDirs = numLocalDirs;
        this.numLogDirs = numLogDirs;
        this.enableAHS = enableAHS;
        String yarnFolderName = String.format("yarn-%d", Time.monotonicNow());
        File targetWorkDirRoot = GenericTestUtils.getTestDir((String)this.getName());
        targetWorkDirRoot.mkdirs();
        File targetWorkDir = new File(targetWorkDirRoot, yarnFolderName);
        try {
            FileContext.getLocalFSFileContext().delete(new Path(targetWorkDir.getAbsolutePath()), true);
        }
        catch (Exception e) {
            LOG.warn("COULD NOT CLEANUP", (Throwable)e);
            throw new YarnRuntimeException("could not cleanup test dir: " + e, (Throwable)e);
        }
        if (Shell.WINDOWS) {
            String targetPath = targetWorkDir.getAbsolutePath();
            File link = new File(System.getProperty("java.io.tmpdir"), String.valueOf(System.currentTimeMillis()));
            String linkPath = link.getAbsolutePath();
            try {
                FileContext.getLocalFSFileContext().delete(new Path(linkPath), true);
            }
            catch (IOException e) {
                throw new YarnRuntimeException("could not cleanup symlink: " + linkPath, (Throwable)e);
            }
            targetWorkDir.mkdirs();
            Shell.ShellCommandExecutor shexec = new Shell.ShellCommandExecutor(Shell.getSymlinkCommand((String)targetPath, (String)linkPath));
            try {
                shexec.execute();
            }
            catch (IOException e) {
                throw new YarnRuntimeException(String.format("failed to create symlink from %s to %s, shell output: %s", linkPath, targetPath, shexec.getOutput()), (Throwable)e);
            }
            this.testWorkDir = link;
        } else {
            this.testWorkDir = targetWorkDir;
        }
        this.resourceManagers = new ResourceManager[numResourceManagers];
        this.nodeManagers = new NodeManager[numNodeManagers];
    }

    public MiniYARNCluster(String testName, int numResourceManagers, int numNodeManagers, int numLocalDirs, int numLogDirs) {
        this(testName, numResourceManagers, numNodeManagers, numLocalDirs, numLogDirs, false);
    }

    public MiniYARNCluster(String testName, int numNodeManagers, int numLocalDirs, int numLogDirs) {
        this(testName, 1, numNodeManagers, numLocalDirs, numLogDirs);
    }

    public void serviceInit(Configuration conf) throws Exception {
        this.useFixedPorts = conf.getBoolean("yarn.minicluster.fixed.ports", false);
        if (!this.useFixedPorts) {
            String hostname = MiniYARNCluster.getHostname();
            conf.set("yarn.timeline-service.address", hostname + ":0");
            conf.set("yarn.timeline-service.webapp.address", hostname + ":" + ServerSocketUtil.getPort((int)9188, (int)10));
        }
        this.useRpc = conf.getBoolean("yarn.minicluster.use-rpc", false);
        this.failoverTimeout = conf.getInt("yarn.resourcemanager.zk-timeout-ms", 10000);
        if (conf.getBoolean("yarn.test.reset-resource-types", true)) {
            ResourceUtils.resetResourceTypes((Configuration)conf);
        }
        if (this.useRpc && !this.useFixedPorts) {
            throw new YarnRuntimeException("Invalid configuration! Minicluster can use rpc only when configured to use fixed ports");
        }
        conf.setBoolean("yarn.is.minicluster", true);
        if (this.resourceManagers.length > 1) {
            conf.setBoolean("yarn.resourcemanager.ha.enabled", true);
            if (conf.get("yarn.resourcemanager.ha.rm-ids") == null) {
                StringBuilder rmIds = new StringBuilder();
                for (int i = 0; i < this.resourceManagers.length; ++i) {
                    if (i != 0) {
                        rmIds.append(",");
                    }
                    rmIds.append("rm" + i);
                }
                conf.set("yarn.resourcemanager.ha.rm-ids", rmIds.toString());
            }
            Collection rmIdsCollection = HAUtil.getRMHAIds((Configuration)conf);
            this.rmIds = rmIdsCollection.toArray(new String[rmIdsCollection.size()]);
        }
        for (int i = 0; i < this.resourceManagers.length; ++i) {
            this.resourceManagers[i] = this.createResourceManager();
            if (!this.useFixedPorts) {
                if (HAUtil.isHAEnabled((Configuration)conf)) {
                    this.setHARMConfigurationWithEphemeralPorts(i, conf);
                } else {
                    this.setNonHARMConfigurationWithEphemeralPorts(conf);
                }
            }
            this.addService((Service)new ResourceManagerWrapper(i));
        }
        for (int index = 0; index < this.nodeManagers.length; ++index) {
            this.nodeManagers[index] = this.useRpc ? new CustomNodeManager() : new ShortCircuitedNodeManager();
            this.addService((Service)new NodeManagerWrapper(index));
        }
        if (conf.getBoolean("yarn.timeline-service.enabled", false) || this.enableAHS) {
            this.addService((Service)new ApplicationHistoryServerWrapper());
        }
        if (conf.get("yarn.node-attribute.fs-store.root-dir") == null) {
            File nodeAttrDir = new File(this.getTestWorkDir(), "nodeattributes");
            conf.set("yarn.node-attribute.fs-store.root-dir", nodeAttrDir.getCanonicalPath());
        }
        super.serviceInit((Configuration)(conf instanceof YarnConfiguration ? conf : new YarnConfiguration(conf)));
    }

    protected synchronized void serviceStart() throws Exception {
        super.serviceStart();
        this.waitForNodeManagersToConnect(5000L);
    }

    private void setNonHARMConfigurationWithEphemeralPorts(Configuration conf) {
        String hostname = MiniYARNCluster.getHostname();
        conf.set("yarn.resourcemanager.address", hostname + ":0");
        conf.set("yarn.resourcemanager.admin.address", hostname + ":0");
        conf.set("yarn.resourcemanager.scheduler.address", hostname + ":0");
        conf.set("yarn.resourcemanager.resource-tracker.address", hostname + ":0");
        WebAppUtils.setRMWebAppHostnameAndPort((Configuration)conf, (String)hostname, (int)0);
    }

    private void setHARMConfigurationWithEphemeralPorts(int index, Configuration conf) {
        String hostname = MiniYARNCluster.getHostname();
        for (String confKey : YarnConfiguration.getServiceAddressConfKeys((Configuration)conf)) {
            conf.set(HAUtil.addSuffix((String)confKey, (String)this.rmIds[index]), hostname + ":0");
        }
    }

    private synchronized void initResourceManager(int index, Configuration conf) {
        Configuration newConf;
        Object object = newConf = this.resourceManagers.length > 1 ? new YarnConfiguration(conf) : conf;
        if (HAUtil.isHAEnabled((Configuration)newConf)) {
            newConf.set("yarn.resourcemanager.ha.id", this.rmIds[index]);
        }
        this.resourceManagers[index].init(newConf);
        this.resourceManagers[index].getRMContext().getDispatcher().register(RMAppAttemptEventType.class, (EventHandler)new EventHandler<RMAppAttemptEvent>(){

            public void handle(RMAppAttemptEvent event) {
                if (event instanceof RMAppAttemptRegistrationEvent) {
                    MiniYARNCluster.this.appMasters.put(event.getApplicationAttemptId(), event.getTimestamp());
                } else if (event instanceof RMAppAttemptUnregistrationEvent) {
                    MiniYARNCluster.this.appMasters.remove(event.getApplicationAttemptId());
                }
            }
        });
    }

    private synchronized void startResourceManager(int index) {
        try {
            this.resourceManagers[index].start();
            if (this.resourceManagers[index].getServiceState() != Service.STATE.STARTED) {
                throw new IOException("ResourceManager failed to start. Final state is " + this.resourceManagers[index].getServiceState());
            }
        }
        catch (Throwable t) {
            throw new YarnRuntimeException(t);
        }
        Configuration conf = this.resourceManagers[index].getConfig();
        LOG.info("MiniYARN ResourceManager address: " + conf.get("yarn.resourcemanager.address"));
        LOG.info("MiniYARN ResourceManager web address: " + WebAppUtils.getRMWebAppURLWithoutScheme((Configuration)conf));
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public synchronized void stopResourceManager(int index) {
        if (this.resourceManagers[index] != null) {
            this.resourceManagers[index].stop();
            this.resourceManagers[index] = null;
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public synchronized void restartResourceManager(int index) throws InterruptedException {
        if (this.resourceManagers[index] != null) {
            this.resourceManagers[index].stop();
            this.resourceManagers[index] = null;
        }
        this.resourceManagers[index] = new ResourceManager();
        this.initResourceManager(index, this.getConfig());
        this.startResourceManager(index);
    }

    public File getTestWorkDir() {
        return this.testWorkDir;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public int getActiveRMIndex() {
        if (this.resourceManagers.length == 1) {
            return 0;
        }
        int numRetriesForRMBecomingActive = this.failoverTimeout / 100;
        while (numRetriesForRMBecomingActive-- > 0) {
            for (int i = 0; i < this.resourceManagers.length; ++i) {
                if (this.resourceManagers[i] == null) continue;
                try {
                    if (HAServiceProtocol.HAServiceState.ACTIVE != this.resourceManagers[i].getRMContext().getRMAdminService().getServiceStatus().getState()) continue;
                    return i;
                }
                catch (IOException e) {
                    throw new YarnRuntimeException("Couldn't read the status of a ResourceManger in the HA ensemble.", (Throwable)e);
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new YarnRuntimeException("Interrupted while waiting for one of the ResourceManagers to become active");
            }
        }
        return -1;
    }

    public ResourceManager getResourceManager() {
        int activeRMIndex = this.getActiveRMIndex();
        return activeRMIndex == -1 ? null : this.resourceManagers[activeRMIndex];
    }

    public ResourceManager getResourceManager(int i) {
        return this.resourceManagers[i];
    }

    public NodeManager getNodeManager(int i) {
        return this.nodeManagers[i];
    }

    public static String getHostname() {
        return "localhost";
    }

    public boolean waitForNodeManagersToConnect(long timeout) throws YarnException, InterruptedException {
        GetClusterMetricsRequest req = GetClusterMetricsRequest.newInstance();
        int i = 0;
        while ((long)i < timeout / 10L) {
            ResourceManager rm = this.getResourceManager();
            if (rm == null) {
                throw new YarnException("Can not find the active RM.");
            }
            if (this.nodeManagers.length == rm.getClientRMService().getClusterMetrics(req).getClusterMetrics().getNumNodeManagers()) {
                LOG.info("All Node Managers connected in MiniYARNCluster");
                return true;
            }
            Thread.sleep(10L);
            ++i;
        }
        LOG.info("Node Managers did not connect within 5000ms");
        return false;
    }

    public ApplicationHistoryServer getApplicationHistoryServer() {
        return this.appHistoryServer;
    }

    protected ResourceManager createResourceManager() {
        return new ResourceManager(){

            protected void doSecureLogin() throws IOException {
            }
        };
    }

    public int getNumOfResourceManager() {
        return this.resourceManagers.length;
    }

    static {
        DefaultMetricsSystem.setMiniClusterMode((boolean)true);
    }

    private class ShortCircuitedAMRMProxy
    extends AMRMProxyService {
        public ShortCircuitedAMRMProxy(Context context, AsyncDispatcher dispatcher) {
            super(context, dispatcher);
        }

        protected void initializePipeline(ApplicationAttemptId applicationAttemptId, String user, Token<AMRMTokenIdentifier> amrmToken, Token<AMRMTokenIdentifier> localToken, Map<String, byte[]> recoveredDataMap, boolean isRecovery, Credentials credentials) {
            super.initializePipeline(applicationAttemptId, user, amrmToken, localToken, recoveredDataMap, isRecovery, credentials);
            RequestInterceptor rt = ((AMRMProxyService.RequestInterceptorChainWrapper)this.getPipelines().get(applicationAttemptId.getApplicationId())).getRootInterceptor();
            while (rt.getNextInterceptor() != null) {
                rt = rt.getNextInterceptor();
            }
            if (rt instanceof DefaultRequestInterceptor) {
                ((DefaultRequestInterceptor)rt).setRMClient((ApplicationMasterProtocol)MiniYARNCluster.this.getResourceManager().getApplicationMasterService());
            }
        }
    }

    private class CustomQueueingContainerManagerImpl
    extends ContainerManagerImpl {
        public CustomQueueingContainerManagerImpl(Context context, ContainerExecutor exec, DeletionService del, NodeStatusUpdater nodeStatusUpdater, NodeManagerMetrics metrics, LocalDirsHandlerService dirsHandler) {
            super(context, exec, del, nodeStatusUpdater, metrics, dirsHandler);
        }

        protected void createAMRMProxyService(Configuration conf) {
            boolean bl = this.amrmProxyEnabled = conf.getBoolean("yarn.nodemanager.amrmproxy.enabled", false) || conf.getBoolean("yarn.nodemanager.distributed-scheduling.enabled", false);
            if (this.amrmProxyEnabled) {
                LOG.info("CustomAMRMProxyService is enabled. All the AM->RM requests will be intercepted by the proxy");
                AMRMProxyService amrmProxyService = MiniYARNCluster.this.useRpc ? new AMRMProxyService(this.getContext(), this.dispatcher) : new ShortCircuitedAMRMProxy(this.getContext(), this.dispatcher);
                this.setAMRMProxyService(amrmProxyService);
                this.addService((Service)this.getAMRMProxyService());
            } else {
                LOG.info("CustomAMRMProxyService is disabled");
            }
        }

        protected ContainersMonitor createContainersMonitor(ContainerExecutor exec) {
            return new ContainersMonitorImpl(exec, this.dispatcher, this.context){

                public float getVmemRatio() {
                    return 2.0f;
                }

                public long getVmemAllocatedForContainers() {
                    return 0x400000000L;
                }

                public long getPmemAllocatedForContainers() {
                    return 0x200000000L;
                }

                public long getVCoresAllocatedForContainers() {
                    return 10L;
                }
            };
        }
    }

    private class CustomContainerManagerImpl
    extends ContainerManagerImpl {
        public CustomContainerManagerImpl(Context context, ContainerExecutor exec, DeletionService del, NodeStatusUpdater nodeStatusUpdater, NodeManagerMetrics metrics, LocalDirsHandlerService dirsHandler) {
            super(context, exec, del, nodeStatusUpdater, metrics, dirsHandler);
        }

        protected void createAMRMProxyService(Configuration conf) {
            boolean bl = this.amrmProxyEnabled = conf.getBoolean("yarn.nodemanager.amrmproxy.enabled", false) || conf.getBoolean("yarn.nodemanager.distributed-scheduling.enabled", false);
            if (this.amrmProxyEnabled) {
                LOG.info("CustomAMRMProxyService is enabled. All the AM->RM requests will be intercepted by the proxy");
                AMRMProxyService amrmProxyService = MiniYARNCluster.this.useRpc ? new AMRMProxyService(this.getContext(), this.dispatcher) : new ShortCircuitedAMRMProxy(this.getContext(), this.dispatcher);
                this.setAMRMProxyService(amrmProxyService);
                this.addService((Service)this.getAMRMProxyService());
            } else {
                LOG.info("CustomAMRMProxyService is disabled");
            }
        }
    }

    private class ApplicationHistoryServerWrapper
    extends AbstractService {
        public ApplicationHistoryServerWrapper() {
            super(ApplicationHistoryServerWrapper.class.getName());
        }

        protected synchronized void serviceInit(Configuration conf) throws Exception {
            MiniYARNCluster.this.appHistoryServer = new ApplicationHistoryServer();
            conf.setClass("yarn.timeline-service.generic-application-history.store-class", MemoryApplicationHistoryStore.class, ApplicationHistoryStore.class);
            if (!TimelineUtils.timelineServiceV1_5Enabled((Configuration)conf)) {
                conf.setClass("yarn.timeline-service.store-class", MemoryTimelineStore.class, TimelineStore.class);
            }
            conf.setClass("yarn.timeline-service.state-store-class", MemoryTimelineStateStore.class, TimelineStateStore.class);
            MiniYARNCluster.this.appHistoryServer.init(conf);
            super.serviceInit(conf);
        }

        protected synchronized void serviceStart() throws Exception {
            Configuration conf = this.getConfig();
            String filterInitializerConfKey = "hadoop.http.filter.initializers";
            String initializers = conf.get(filterInitializerConfKey, "");
            String[] parts = initializers.split(",");
            LinkedHashSet<String> target = new LinkedHashSet<String>();
            for (String filterInitializer : parts) {
                if ((filterInitializer = filterInitializer.trim()).equals(RMAuthenticationFilterInitializer.class.getName()) || filterInitializer.isEmpty()) continue;
                target.add(filterInitializer);
            }
            initializers = StringUtils.join(target, (String)",");
            conf.set(filterInitializerConfKey, initializers);
            MiniYARNCluster.this.appHistoryServer.start();
            if (MiniYARNCluster.this.appHistoryServer.getServiceState() != Service.STATE.STARTED) {
                IOException ioe = new IOException("ApplicationHistoryServer failed to start. Final state is " + MiniYARNCluster.this.appHistoryServer.getServiceState());
                ioe.initCause(MiniYARNCluster.this.appHistoryServer.getFailureCause());
                throw ioe;
            }
            LOG.info("MiniYARN ApplicationHistoryServer address: " + this.getConfig().get("yarn.timeline-service.address"));
            LOG.info("MiniYARN ApplicationHistoryServer web address: " + this.getConfig().get("yarn.timeline-service.webapp.address"));
            super.serviceStart();
        }

        protected synchronized void serviceStop() throws Exception {
            if (MiniYARNCluster.this.appHistoryServer != null) {
                MiniYARNCluster.this.appHistoryServer.stop();
            }
        }
    }

    private class ShortCircuitedNodeManager
    extends CustomNodeManager {
        private ShortCircuitedNodeManager() {
        }

        @Override
        protected NodeStatusUpdater createNodeStatusUpdater(Context context, Dispatcher dispatcher, NodeHealthCheckerService healthChecker) {
            return new NodeStatusUpdaterImpl(context, dispatcher, healthChecker, this.metrics){

                protected NodeStatus getNodeStatus(int responseId) throws IOException {
                    return ShortCircuitedNodeManager.this.getSimulatedNodeStatus(super.getNodeStatus(responseId));
                }

                protected ResourceTracker getRMClient() {
                    final ResourceTrackerService rt = MiniYARNCluster.this.getResourceManager().getResourceTrackerService();
                    final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
                    return new ResourceTracker(){

                        public NodeHeartbeatResponse nodeHeartbeat(NodeHeartbeatRequest request) throws YarnException, IOException {
                            NodeHeartbeatResponse response;
                            try {
                                response = rt.nodeHeartbeat(request);
                            }
                            catch (YarnException e) {
                                LOG.info("Exception in heartbeat from node " + request.getNodeStatus().getNodeId(), (Throwable)e);
                                throw e;
                            }
                            return response;
                        }

                        public RegisterNodeManagerResponse registerNodeManager(RegisterNodeManagerRequest request) throws YarnException, IOException {
                            RegisterNodeManagerResponse response;
                            try {
                                response = rt.registerNodeManager(request);
                            }
                            catch (YarnException e) {
                                LOG.info("Exception in node registration from " + request.getNodeId().toString(), (Throwable)e);
                                throw e;
                            }
                            return response;
                        }

                        public UnRegisterNodeManagerResponse unRegisterNodeManager(UnRegisterNodeManagerRequest request) throws YarnException, IOException {
                            return (UnRegisterNodeManagerResponse)recordFactory.newRecordInstance(UnRegisterNodeManagerResponse.class);
                        }
                    };
                }

                protected void stopRMProxy() {
                }
            };
        }

        protected ContainerManagerImpl createContainerManager(Context context, ContainerExecutor exec, DeletionService del, NodeStatusUpdater nodeStatusUpdater, ApplicationACLsManager aclsManager, LocalDirsHandlerService dirsHandler) {
            if (this.getConfig().getInt("yarn.nodemanager.opportunistic-containers-max-queue-length", 0) > 0) {
                return new CustomQueueingContainerManagerImpl(context, exec, del, nodeStatusUpdater, this.metrics, dirsHandler);
            }
            return new CustomContainerManagerImpl(context, exec, del, nodeStatusUpdater, this.metrics, dirsHandler);
        }
    }

    public class CustomNodeManager
    extends NodeManager {
        protected NodeStatus nodeStatus;

        public void setNodeStatus(NodeStatus status) {
            this.nodeStatus = status;
        }

        protected NodeStatus getSimulatedNodeStatus(NodeStatus currentStatus) {
            if (this.nodeStatus == null) {
                return currentStatus;
            }
            this.nodeStatus.setResponseId(currentStatus.getResponseId());
            return this.nodeStatus;
        }

        protected void doSecureLogin() throws IOException {
        }

        protected NodeStatusUpdater createNodeStatusUpdater(Context context, Dispatcher dispatcher, NodeHealthCheckerService healthChecker) {
            return new NodeStatusUpdaterImpl(context, dispatcher, healthChecker, this.metrics){

                protected NodeStatus getNodeStatus(int responseId) throws IOException {
                    return CustomNodeManager.this.getSimulatedNodeStatus(super.getNodeStatus(responseId));
                }
            };
        }
    }

    private class NodeManagerWrapper
    extends AbstractService {
        int index;

        public NodeManagerWrapper(int i) {
            super(NodeManagerWrapper.class.getName() + "_" + i);
            this.index = 0;
            this.index = i;
        }

        protected synchronized void serviceInit(Configuration conf) throws Exception {
            YarnConfiguration config = new YarnConfiguration(conf);
            String localDirsString = this.prepareDirs("local", MiniYARNCluster.this.numLocalDirs);
            config.set("yarn.nodemanager.local-dirs", localDirsString);
            String logDirsString = this.prepareDirs("log", MiniYARNCluster.this.numLogDirs);
            config.set("yarn.nodemanager.log-dirs", logDirsString);
            config.setInt("yarn.nodemanager.resource.memory-mb", config.getInt("yarn.minicluster.yarn.nodemanager.resource.memory-mb", 4096));
            config.set("yarn.nodemanager.address", MiniYARNCluster.getHostname() + ":0");
            config.set("yarn.nodemanager.localizer.address", MiniYARNCluster.getHostname() + ":0");
            config.set("yarn.nodemanager.collector-service.address", MiniYARNCluster.getHostname() + ":" + ServerSocketUtil.getPort((int)8048, (int)10));
            WebAppUtils.setNMWebAppHostNameAndPort((Configuration)config, (String)MiniYARNCluster.getHostname(), (int)0);
            config.setBoolean("yarn.nodemanager.resource.detect-hardware-capabilities", false);
            if (!config.getBoolean("yarn.minicluster.control-resource-monitoring", false)) {
                config.setBoolean("yarn.nodemanager.container-monitor.enabled", false);
                config.setLong("yarn.nodemanager.resource-monitor.interval-ms", 0L);
            }
            LOG.info("Starting NM: " + this.index);
            MiniYARNCluster.this.nodeManagers[this.index].init((Configuration)config);
            super.serviceInit((Configuration)config);
        }

        private String prepareDirs(String dirType, int numDirs) {
            File[] dirs = new File[numDirs];
            String dirsString = "";
            for (int i = 0; i < numDirs; ++i) {
                dirs[i] = new File(MiniYARNCluster.this.testWorkDir, MiniYARNCluster.this.getName() + "-" + dirType + "Dir-nm-" + this.index + "_" + i);
                dirs[i].mkdirs();
                LOG.info("Created " + dirType + "Dir in " + dirs[i].getAbsolutePath());
                String delimiter = i > 0 ? "," : "";
                dirsString = dirsString.concat(delimiter + dirs[i].getAbsolutePath());
            }
            return dirsString;
        }

        protected synchronized void serviceStart() throws Exception {
            MiniYARNCluster.this.nodeManagers[this.index].start();
            if (MiniYARNCluster.this.nodeManagers[this.index].getServiceState() != Service.STATE.STARTED) {
                throw new IOException("NodeManager " + this.index + " failed to start");
            }
            super.serviceStart();
        }

        protected synchronized void serviceStop() throws Exception {
            if (MiniYARNCluster.this.nodeManagers[this.index] != null) {
                MiniYARNCluster.this.nodeManagers[this.index].stop();
            }
            super.serviceStop();
        }
    }

    private class ResourceManagerWrapper
    extends AbstractService {
        private int index;

        public ResourceManagerWrapper(int i) {
            super(ResourceManagerWrapper.class.getName() + "_" + i);
            this.index = i;
        }

        protected synchronized void serviceInit(Configuration conf) throws Exception {
            MiniYARNCluster.this.initResourceManager(this.index, conf);
            super.serviceInit(conf);
        }

        protected synchronized void serviceStart() throws Exception {
            MiniYARNCluster.this.startResourceManager(this.index);
            if (this.index == 0 && MiniYARNCluster.this.resourceManagers[this.index].getRMContext().isHAEnabled()) {
                MiniYARNCluster.this.resourceManagers[this.index].getRMContext().getRMAdminService().transitionToActive(new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER_FORCED));
            }
            Configuration conf = MiniYARNCluster.this.resourceManagers[this.index].getConfig();
            LOG.info("Starting resourcemanager " + this.index);
            LOG.info("MiniYARN ResourceManager address: " + conf.get("yarn.resourcemanager.address"));
            LOG.info("MiniYARN ResourceManager web address: " + WebAppUtils.getRMWebAppURLWithoutScheme((Configuration)conf));
            super.serviceStart();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitForAppMastersToFinish(long timeoutMillis) throws InterruptedException {
            long started = System.currentTimeMillis();
            ConcurrentMap concurrentMap = MiniYARNCluster.this.appMasters;
            synchronized (concurrentMap) {
                while (!MiniYARNCluster.this.appMasters.isEmpty() && System.currentTimeMillis() - started < timeoutMillis) {
                    MiniYARNCluster.this.appMasters.wait(1000L);
                }
            }
            if (!MiniYARNCluster.this.appMasters.isEmpty()) {
                LOG.warn("Stopping RM while some app masters are still alive");
            }
        }

        protected synchronized void serviceStop() throws Exception {
            if (MiniYARNCluster.this.resourceManagers[this.index] != null) {
                this.waitForAppMastersToFinish(5000L);
                MiniYARNCluster.this.resourceManagers[this.index].stop();
            }
            if (Shell.WINDOWS) {
                String testWorkDirPath = MiniYARNCluster.this.testWorkDir.getAbsolutePath();
                try {
                    FileContext.getLocalFSFileContext().delete(new Path(testWorkDirPath), true);
                }
                catch (IOException e) {
                    LOG.warn("could not cleanup symlink: " + MiniYARNCluster.this.testWorkDir.getAbsolutePath());
                }
            }
            super.serviceStop();
        }
    }
}

