/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.types;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.types.DataType;
import org.apache.hadoop.hbase.types.FixedLengthWrapper;
import org.apache.hadoop.hbase.types.RawBytes;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Order;
import org.apache.hadoop.hbase.util.PositionedByteRange;
import org.apache.hadoop.hbase.util.SimplePositionedMutableByteRange;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestFixedLengthWrapper {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFixedLengthWrapper.class);
    static final byte[][] VALUES = new byte[][]{Bytes.toBytes((String)""), Bytes.toBytes((String)"1"), Bytes.toBytes((String)"22"), Bytes.toBytes((String)"333"), Bytes.toBytes((String)"4444"), Bytes.toBytes((String)"55555"), Bytes.toBytes((String)"666666"), Bytes.toBytes((String)"7777777"), Bytes.toBytes((String)"88888888"), Bytes.toBytes((String)"999999999")};
    static final int[] limits = new int[]{9, 12, 15};

    @Test
    public void testReadWrite() {
        for (int limit : limits) {
            SimplePositionedMutableByteRange buff = new SimplePositionedMutableByteRange(limit);
            for (Order ord : new Order[]{Order.ASCENDING, Order.DESCENDING}) {
                for (byte[] val : VALUES) {
                    buff.setPosition(0);
                    FixedLengthWrapper type = new FixedLengthWrapper((DataType)new RawBytes(ord), limit);
                    Assert.assertEquals((long)limit, (long)type.encode((PositionedByteRange)buff, (Object)val));
                    buff.setPosition(0);
                    byte[] actual = (byte[])type.decode((PositionedByteRange)buff);
                    Assert.assertTrue((String)"Decoding output differs from expected", (boolean)Bytes.equals((byte[])val, (int)0, (int)val.length, (byte[])actual, (int)0, (int)val.length));
                    buff.setPosition(0);
                    Assert.assertEquals((long)limit, (long)type.skip((PositionedByteRange)buff));
                }
            }
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInsufficientRemainingRead() {
        SimplePositionedMutableByteRange buff = new SimplePositionedMutableByteRange(0);
        FixedLengthWrapper type = new FixedLengthWrapper((DataType)new RawBytes(), 3);
        type.decode((PositionedByteRange)buff);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInsufficientRemainingWrite() {
        SimplePositionedMutableByteRange buff = new SimplePositionedMutableByteRange(0);
        FixedLengthWrapper type = new FixedLengthWrapper((DataType)new RawBytes(), 3);
        type.encode((PositionedByteRange)buff, (Object)Bytes.toBytes((String)""));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOverflowPassthrough() {
        SimplePositionedMutableByteRange buff = new SimplePositionedMutableByteRange(3);
        FixedLengthWrapper type = new FixedLengthWrapper((DataType)new RawBytes(), 0);
        type.encode((PositionedByteRange)buff, (Object)Bytes.toBytes((String)"foo"));
    }
}

