/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.trace;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.apache.htrace.core.Span;
import org.apache.htrace.core.SpanId;

public class TraceTree {
    private final SpansByParent spansByParent;
    private final SpansByProcessId spansByProcessId;

    public TraceTree(Collection<Span> spans) {
        if (spans == null) {
            spans = Collections.emptySet();
        }
        this.spansByParent = new SpansByParent(spans);
        this.spansByProcessId = new SpansByProcessId(spans);
    }

    public SpansByParent getSpansByParent() {
        return this.spansByParent;
    }

    public SpansByProcessId getSpansByProcessId() {
        return this.spansByProcessId;
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        String prefix = "";
        Iterator<Span> iter = this.spansByParent.iterator();
        while (iter.hasNext()) {
            Span span = iter.next();
            bld.append(prefix).append(span.toString());
            prefix = "\n";
        }
        return bld.toString();
    }

    public static class SpansByProcessId {
        private static Comparator<Span> COMPARATOR = new Comparator<Span>(){

            @Override
            public int compare(Span a, Span b) {
                return a.getSpanId().compareTo(b.getSpanId());
            }
        };
        private final TreeSet<Span> treeSet;

        SpansByProcessId(Collection<Span> spans) {
            TreeSet<Span> treeSet = new TreeSet<Span>(COMPARATOR);
            for (Span span : spans) {
                treeSet.add(span);
            }
            this.treeSet = treeSet;
        }

        public Iterator<Span> iterator() {
            return Collections.unmodifiableSortedSet(this.treeSet).iterator();
        }
    }

    public static class SpansByParent {
        private static Comparator<Span> COMPARATOR = new Comparator<Span>(){

            @Override
            public int compare(Span a, Span b) {
                return a.getSpanId().compareTo(b.getSpanId());
            }
        };
        private final TreeSet<Span> treeSet;
        private final HashMap<SpanId, LinkedList<Span>> parentToSpans;

        SpansByParent(Collection<Span> spans) {
            TreeSet<Span> treeSet = new TreeSet<Span>(COMPARATOR);
            this.parentToSpans = new HashMap();
            for (Span span : spans) {
                treeSet.add(span);
                for (SpanId parent : span.getParents()) {
                    LinkedList<Object> list = this.parentToSpans.get(parent);
                    if (list == null) {
                        list = new LinkedList();
                        this.parentToSpans.put(parent, list);
                    }
                    list.add(span);
                }
                if (span.getParents().length != 0) continue;
                LinkedList<Object> list = this.parentToSpans.get(SpanId.INVALID);
                if (list == null) {
                    list = new LinkedList();
                    this.parentToSpans.put(SpanId.INVALID, list);
                }
                list.add(span);
            }
            this.treeSet = treeSet;
        }

        public List<Span> find(SpanId parentId) {
            LinkedList<Span> spans = this.parentToSpans.get(parentId);
            if (spans == null) {
                return new LinkedList<Span>();
            }
            return spans;
        }

        public Iterator<Span> iterator() {
            return Collections.unmodifiableSortedSet(this.treeSet).iterator();
        }
    }
}

