/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.replication.BaseReplicationEndpoint;
import org.apache.hadoop.hbase.replication.ReplicationEndpoint;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.regionserver.Replication;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSource;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ReplicationTests.class, MediumTests.class})
public class TestRaceWhenCreatingReplicationSource {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRaceWhenCreatingReplicationSource.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static String PEER_ID = "1";
    private static TableName TABLE_NAME = TableName.valueOf((String)"race");
    private static byte[] CF = Bytes.toBytes((String)"CF");
    private static byte[] CQ = Bytes.toBytes((String)"CQ");
    private static FileSystem FS;
    private static Path LOG_PATH;
    private static WALProvider.Writer WRITER;
    private static volatile boolean NULL_UUID;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        UTIL.getConfiguration().set("hbase.wal.provider", "multiwal");
        UTIL.getConfiguration().setInt("hbase.wal.regiongrouping.numgroups", 8);
        UTIL.startMiniCluster(3);
        Path dir = UTIL.getDataTestDirOnTestFS();
        FS = UTIL.getTestFileSystem();
        LOG_PATH = new Path(dir, "replicated");
        WRITER = WALFactory.createWALWriter((FileSystem)FS, (Path)LOG_PATH, (Configuration)UTIL.getConfiguration());
        UTIL.getAdmin().addReplicationPeer(PEER_ID, ReplicationPeerConfig.newBuilder().setClusterKey("127.0.0.1:2181:/hbase").setReplicationEndpointImpl(LocalReplicationEndpoint.class.getName()).build(), true);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testRace() throws Exception {
        UTIL.waitFor(30000L, (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){

            public boolean evaluate() throws Exception {
                for (JVMClusterUtil.RegionServerThread t : UTIL.getMiniHBaseCluster().getRegionServerThreads()) {
                    ReplicationSource source = (ReplicationSource)((Replication)t.getRegionServer().getReplicationSourceService()).getReplicationManager().getSource(PEER_ID);
                    if (source != null && source.getReplicationEndpoint() != null) continue;
                    return false;
                }
                return true;
            }

            public String explainFailure() throws Exception {
                return "Replication source has not been initialized yet";
            }
        });
        UTIL.getAdmin().createTable(TableDescriptorBuilder.newBuilder((TableName)TABLE_NAME).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])CF).setScope(1).build()).build());
        UTIL.waitTableAvailable(TABLE_NAME);
        try (Table table = UTIL.getConnection().getTable(TABLE_NAME);){
            table.put(new Put(Bytes.toBytes((int)1)).addColumn(CF, CQ, Bytes.toBytes((int)1)));
        }
        NULL_UUID = false;
        UTIL.waitFor(30000L, (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean evaluate() throws Exception {
                try (WAL.Reader reader = WALFactory.createReader((FileSystem)FS, (Path)LOG_PATH, (Configuration)UTIL.getConfiguration());){
                    boolean bl = reader.next() != null;
                    return bl;
                }
                catch (IOException e) {
                    return false;
                }
            }

            public String explainFailure() throws Exception {
                return "Replication has not catched up";
            }
        });
        var2_2 = null;
        try (WAL.Reader reader = WALFactory.createReader((FileSystem)FS, (Path)LOG_PATH, (Configuration)UTIL.getConfiguration());){
            Cell cell = (Cell)reader.next().getEdit().getCells().get(0);
            Assert.assertEquals((long)1L, (long)Bytes.toInt((byte[])cell.getRowArray(), (int)cell.getRowOffset(), (int)cell.getRowLength()));
            Assert.assertArrayEquals((byte[])CF, (byte[])CellUtil.cloneFamily((Cell)cell));
            Assert.assertArrayEquals((byte[])CQ, (byte[])CellUtil.cloneQualifier((Cell)cell));
            Assert.assertEquals((long)1L, (long)Bytes.toInt((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    static {
        NULL_UUID = true;
    }

    public static final class LocalReplicationEndpoint
    extends BaseReplicationEndpoint {
        private static final UUID PEER_UUID;

        public UUID getPeerUUID() {
            if (NULL_UUID) {
                return null;
            }
            return PEER_UUID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean replicate(ReplicationEndpoint.ReplicateContext replicateContext) {
            WALProvider.Writer writer = WRITER;
            synchronized (writer) {
                try {
                    for (WAL.Entry entry : replicateContext.getEntries()) {
                        WRITER.append(entry);
                    }
                    WRITER.sync(false);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            return true;
        }

        public void start() {
            this.startAsync();
        }

        public void stop() {
            this.stopAsync();
        }

        protected void doStart() {
            this.notifyStarted();
        }

        protected void doStop() {
            this.notifyStopped();
        }

        public boolean canReplicateToSameCluster() {
            return true;
        }

        static {
            UTIL;
            PEER_UUID = HBaseTestingUtility.getRandomUUID();
        }
    }
}

