/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.replication.SerialReplicationTestBase;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ReplicationTests.class, MediumTests.class})
public class TestSerialReplicationFailover
extends SerialReplicationTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSerialReplicationFailover.class);

    @Before
    public void setUp() throws IOException, CommonFSUtils.StreamLacksCapabilityException {
        this.setupWALWriter();
        this.addPeer(false);
    }

    @Test
    public void testKillRS() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        UTIL.getAdmin().createTable(TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])CF).setScope(1).build()).build());
        UTIL.waitTableAvailable(tableName);
        try (Table table = UTIL.getConnection().getTable(tableName);){
            for (int i = 0; i < 100; ++i) {
                table.put(new Put(Bytes.toBytes((int)i)).addColumn(CF, CQ, Bytes.toBytes((int)i)));
            }
        }
        JVMClusterUtil.RegionServerThread thread = UTIL.getMiniHBaseCluster().getRegionServerThreads().stream().filter(t -> !t.getRegionServer().getRegions(tableName).isEmpty()).findFirst().get();
        thread.getRegionServer().abort("for testing");
        thread.join();
        try (Table table = UTIL.getConnection().getTable(tableName);){
            for (int i = 100; i < 200; ++i) {
                table.put(new Put(Bytes.toBytes((int)i)).addColumn(CF, CQ, Bytes.toBytes((int)i)));
            }
        }
        this.enablePeerAndWaitUntilReplicationDone(200);
        this.checkOrder(200);
    }
}

