/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.SampleRegionWALCoprocessor;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.FlushPolicy;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.wal.AbstractFSWAL;
import org.apache.hadoop.hbase.regionserver.wal.TestWALReplay;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.regionserver.wal.WALCoprocessorHost;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTestFSWAL {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractTestFSWAL.class);
    protected static Configuration CONF;
    protected static FileSystem FS;
    protected static Path DIR;
    protected static final HBaseTestingUtility TEST_UTIL;
    @Rule
    public final TestName currentTest = new TestName();
    private static final Set<byte[]> STORES_TO_FLUSH;

    @Before
    public void setUp() throws Exception {
        FileStatus[] entries;
        for (FileStatus dir : entries = FS.listStatus(new Path("/"))) {
            FS.delete(dir.getPath(), true);
        }
        Path hbaseDir = TEST_UTIL.createRootDir();
        Path hbaseWALDir = TEST_UTIL.createWALRootDir();
        DIR = new Path(hbaseWALDir, this.currentTest.getMethodName());
        Assert.assertNotEquals((Object)hbaseDir, (Object)hbaseWALDir);
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("dfs.blocksize", 0x100000);
        TEST_UTIL.getConfiguration().setInt("dfs.namenode.heartbeat.recheck-interval", 5000);
        TEST_UTIL.getConfiguration().setInt("dfs.heartbeat.interval", 1);
        TEST_UTIL.getConfiguration().setInt("dfs.client.socket-timeout", 5000);
        TEST_UTIL.getConfiguration().setInt("hbase.ipc.client.connect.max.retries", 1);
        TEST_UTIL.getConfiguration().setInt("dfs.client.block.recovery.retries", 1);
        TEST_UTIL.getConfiguration().setInt("hbase.ipc.client.connection.maxidletime", 500);
        TEST_UTIL.getConfiguration().set("hbase.coprocessor.wal.classes", SampleRegionWALCoprocessor.class.getName());
        TEST_UTIL.startMiniDFSCluster(3);
        CONF = TEST_UTIL.getConfiguration();
        FS = TEST_UTIL.getDFSCluster().getFileSystem();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    protected abstract AbstractFSWAL<?> newWAL(FileSystem var1, Path var2, String var3, String var4, Configuration var5, List<WALActionsListener> var6, boolean var7, String var8, String var9) throws IOException;

    protected abstract AbstractFSWAL<?> newSlowWAL(FileSystem var1, Path var2, String var3, String var4, Configuration var5, List<WALActionsListener> var6, boolean var7, String var8, String var9, Runnable var10) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWALCoprocessorLoaded() throws Exception {
        try (AbstractFSWAL<?> wal = null;){
            wal = this.newWAL(FS, CommonFSUtils.getWALRootDir((Configuration)CONF), DIR.toString(), "oldWALs", CONF, null, true, null, null);
            WALCoprocessorHost host = wal.getCoprocessorHost();
            Coprocessor c = host.findCoprocessor(SampleRegionWALCoprocessor.class);
            Assert.assertNotNull((Object)c);
        }
    }

    protected void addEdits(WAL log, RegionInfo hri, TableDescriptor htd, int times, MultiVersionConcurrencyControl mvcc, NavigableMap<byte[], Integer> scopes, String cf) throws IOException {
        byte[] row = Bytes.toBytes((String)cf);
        for (int i = 0; i < times; ++i) {
            long timestamp = System.currentTimeMillis();
            WALEdit cols = new WALEdit();
            cols.add((Cell)new KeyValue(row, row, row, timestamp, row));
            WALKeyImpl key = new WALKeyImpl(hri.getEncodedNameAsBytes(), htd.getTableName(), -1L, timestamp, WALKey.EMPTY_UUIDS, 0L, 0L, mvcc, scopes);
            log.appendData(hri, key, cols);
        }
        log.sync();
    }

    protected void flushRegion(WAL wal, byte[] regionEncodedName, Set<byte[]> flushedFamilyNames) {
        wal.startCacheFlush(regionEncodedName, flushedFamilyNames);
        wal.completeCacheFlush(regionEncodedName, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWALComparator() throws Exception {
        AbstractFSWAL<?> wal1 = null;
        AbstractFSWAL<?> walMeta = null;
        try {
            wal1 = this.newWAL(FS, CommonFSUtils.getWALRootDir((Configuration)CONF), DIR.toString(), "oldWALs", CONF, null, true, null, null);
            LOG.debug("Log obtained is: " + wal1);
            Comparator comp = wal1.LOG_NAME_COMPARATOR;
            Path p1 = wal1.computeFilename(11L);
            Path p2 = wal1.computeFilename(12L);
            Assert.assertTrue((comp.compare(p1, p1) == 0 ? 1 : 0) != 0);
            Assert.assertTrue((comp.compare(p1, p2) < 0 ? 1 : 0) != 0);
            walMeta = this.newWAL(FS, CommonFSUtils.getWALRootDir((Configuration)CONF), DIR.toString(), "oldWALs", CONF, null, true, null, ".meta");
            Comparator compMeta = walMeta.LOG_NAME_COMPARATOR;
            Path p1WithMeta = walMeta.computeFilename(11L);
            Path p2WithMeta = walMeta.computeFilename(12L);
            Assert.assertTrue((compMeta.compare(p1WithMeta, p1WithMeta) == 0 ? 1 : 0) != 0);
            Assert.assertTrue((compMeta.compare(p1WithMeta, p2WithMeta) < 0 ? 1 : 0) != 0);
            boolean ex = false;
            try {
                comp.compare(p1WithMeta, p2);
            }
            catch (IllegalArgumentException e) {
                ex = true;
            }
            Assert.assertTrue((String)"Comparator doesn't complain while checking meta log files", (boolean)ex);
            boolean exMeta = false;
            try {
                compMeta.compare(p1WithMeta, p2);
            }
            catch (IllegalArgumentException e) {
                exMeta = true;
            }
            Assert.assertTrue((String)"Meta comparator doesn't complain while checking log files", (boolean)exMeta);
        }
        finally {
            if (wal1 != null) {
                wal1.close();
            }
            if (walMeta != null) {
                walMeta.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFindMemStoresEligibleForFlush() throws Exception {
        Object fam;
        Object fam22;
        LOG.debug("testFindMemStoresEligibleForFlush");
        Configuration conf1 = HBaseConfiguration.create((Configuration)CONF);
        conf1.setInt("hbase.regionserver.maxlogs", 1);
        AbstractFSWAL<?> wal = this.newWAL(FS, CommonFSUtils.getWALRootDir((Configuration)conf1), DIR.toString(), "oldWALs", conf1, null, true, null, null);
        String cf1 = "cf1";
        String cf2 = "cf2";
        String cf3 = "cf3";
        TableDescriptor t1 = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)"t1")).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)cf1)).build();
        TableDescriptor t2 = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)"t2")).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)cf1)).build();
        RegionInfo hri1 = RegionInfoBuilder.newBuilder((TableName)t1.getTableName()).build();
        RegionInfo hri2 = RegionInfoBuilder.newBuilder((TableName)t2.getTableName()).build();
        ArrayList<ColumnFamilyDescriptor> cfs = new ArrayList<ColumnFamilyDescriptor>();
        cfs.add(ColumnFamilyDescriptorBuilder.of((String)cf1));
        cfs.add(ColumnFamilyDescriptorBuilder.of((String)cf2));
        TableDescriptor t3 = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)"t3")).setColumnFamilies(cfs).build();
        RegionInfo hri3 = RegionInfoBuilder.newBuilder((TableName)t3.getTableName()).build();
        MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl();
        TreeMap<byte[], Integer> scopes1 = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        for (Object fam22 : t1.getColumnFamilyNames()) {
            scopes1.put((byte[])fam22, 0);
        }
        TreeMap<byte[], Integer> scopes2 = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        fam22 = t2.getColumnFamilyNames().iterator();
        while (fam22.hasNext()) {
            fam = (byte[])fam22.next();
            scopes2.put((byte[])fam, 0);
        }
        TreeMap<byte[], Integer> scopes3 = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        fam = t3.getColumnFamilyNames().iterator();
        while (fam.hasNext()) {
            byte[] fam3 = (byte[])fam.next();
            scopes3.put(fam3, 0);
        }
        try {
            this.addEdits((WAL)wal, hri1, t1, 2, mvcc, (NavigableMap<byte[], Integer>)scopes1, cf1);
            wal.rollWriter();
            this.addEdits((WAL)wal, hri1, t1, 2, mvcc, (NavigableMap<byte[], Integer>)scopes1, cf1);
            wal.rollWriter();
            Assert.assertTrue((wal.getNumRolledLogFiles() == 2 ? 1 : 0) != 0);
            Map regionsToFlush = wal.findRegionsToForceFlush();
            Assert.assertEquals((long)1L, (long)regionsToFlush.size());
            Assert.assertEquals((Object)hri1.getEncodedNameAsBytes(), (Object)((byte[])regionsToFlush.keySet().toArray()[0]));
            this.addEdits((WAL)wal, hri2, t2, 2, mvcc, (NavigableMap<byte[], Integer>)scopes2, cf1);
            regionsToFlush = wal.findRegionsToForceFlush();
            Assert.assertEquals((long)1L, (long)regionsToFlush.size());
            Assert.assertEquals((Object)hri1.getEncodedNameAsBytes(), (Object)((byte[])regionsToFlush.keySet().toArray()[0]));
            this.flushRegion((WAL)wal, hri1.getEncodedNameAsBytes(), t1.getColumnFamilyNames());
            wal.rollWriter();
            Assert.assertEquals((long)1L, (long)wal.getNumRolledLogFiles());
            this.flushRegion((WAL)wal, hri2.getEncodedNameAsBytes(), t2.getColumnFamilyNames());
            wal.rollWriter(true);
            Assert.assertEquals((long)0L, (long)wal.getNumRolledLogFiles());
            this.addEdits((WAL)wal, hri1, t1, 2, mvcc, (NavigableMap<byte[], Integer>)scopes1, cf1);
            this.addEdits((WAL)wal, hri2, t2, 2, mvcc, (NavigableMap<byte[], Integer>)scopes2, cf1);
            wal.rollWriter();
            Assert.assertEquals((long)1L, (long)wal.getNumRolledLogFiles());
            this.addEdits((WAL)wal, hri1, t1, 2, mvcc, (NavigableMap<byte[], Integer>)scopes1, cf1);
            wal.rollWriter();
            regionsToFlush = wal.findRegionsToForceFlush();
            Assert.assertEquals((long)2L, (long)regionsToFlush.size());
            this.flushRegion((WAL)wal, hri1.getEncodedNameAsBytes(), t1.getColumnFamilyNames());
            this.flushRegion((WAL)wal, hri2.getEncodedNameAsBytes(), t2.getColumnFamilyNames());
            wal.rollWriter(true);
            Assert.assertEquals((long)0L, (long)wal.getNumRolledLogFiles());
            this.addEdits((WAL)wal, hri1, t1, 2, mvcc, (NavigableMap<byte[], Integer>)scopes1, cf1);
            wal.startCacheFlush(hri1.getEncodedNameAsBytes(), t1.getColumnFamilyNames());
            wal.rollWriter();
            wal.completeCacheFlush(hri1.getEncodedNameAsBytes(), -1L);
            Assert.assertEquals((long)1L, (long)wal.getNumRolledLogFiles());
            this.flushRegion((WAL)wal, hri1.getEncodedNameAsBytes(), t1.getColumnFamilyNames());
            wal.rollWriter(true);
            this.addEdits((WAL)wal, hri3, t3, 2, mvcc, (NavigableMap<byte[], Integer>)scopes3, cf1);
            this.addEdits((WAL)wal, hri3, t3, 2, mvcc, (NavigableMap<byte[], Integer>)scopes3, cf2);
            this.addEdits((WAL)wal, hri3, t3, 2, mvcc, (NavigableMap<byte[], Integer>)scopes3, cf3);
            wal.rollWriter();
            this.addEdits((WAL)wal, hri3, t3, 2, mvcc, (NavigableMap<byte[], Integer>)scopes3, cf1);
            wal.rollWriter();
            Assert.assertEquals((long)2L, (long)wal.getNumRolledLogFiles());
            HashSet<byte[]> flushedFamilyNames = new HashSet<byte[]>();
            flushedFamilyNames.add(Bytes.toBytes((String)cf1));
            this.flushRegion((WAL)wal, hri3.getEncodedNameAsBytes(), (Set<byte[]>)flushedFamilyNames);
            regionsToFlush = wal.findRegionsToForceFlush();
            Assert.assertEquals((long)1L, (long)regionsToFlush.size());
            Assert.assertEquals((Object)hri3.getEncodedNameAsBytes(), (Object)((byte[])regionsToFlush.keySet().toArray()[0]));
            Assert.assertEquals((long)2L, (long)((List)regionsToFlush.get(hri3.getEncodedNameAsBytes())).size());
        }
        finally {
            if (wal != null) {
                wal.close();
            }
        }
    }

    @Test(expected=IOException.class)
    public void testFailedToCreateWALIfParentRenamed() throws IOException, CommonFSUtils.StreamLacksCapabilityException {
        String name = "testFailedToCreateWALIfParentRenamed";
        AbstractFSWAL<?> wal = this.newWAL(FS, CommonFSUtils.getWALRootDir((Configuration)CONF), "testFailedToCreateWALIfParentRenamed", "oldWALs", CONF, null, true, null, null);
        long filenum = System.currentTimeMillis();
        Path path = wal.computeFilename(filenum);
        wal.createWriterInstance(path);
        Path parent = path.getParent();
        path = wal.computeFilename(filenum + 1L);
        Path newPath = new Path(parent.getParent(), parent.getName() + "-splitting");
        FS.rename(parent, newPath);
        wal.createWriterInstance(path);
        Assert.fail((String)"It should fail to create the new WAL");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlushSequenceIdIsGreaterThanAllEditsInHFile() throws IOException {
        String testName = this.currentTest.getMethodName();
        TableName tableName = TableName.valueOf((String)testName);
        RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)tableName).build();
        byte[] rowName = tableName.getName();
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"f")).build();
        HRegion r = HBaseTestingUtility.createRegionAndWAL(hri, TEST_UTIL.getDefaultRootDirPath(), TEST_UTIL.getConfiguration(), htd);
        HBaseTestingUtility.closeRegionAndWAL(r);
        int countPerFamily = 10;
        final AtomicBoolean goslow = new AtomicBoolean(false);
        TreeMap<byte[], Integer> scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        for (byte[] fam : htd.getColumnFamilyNames()) {
            scopes.put(fam, 0);
        }
        AbstractFSWAL<?> wal = this.newSlowWAL(FS, CommonFSUtils.getWALRootDir((Configuration)CONF), DIR.toString(), testName, CONF, null, true, null, null, new Runnable(){

            @Override
            public void run() {
                if (goslow.get()) {
                    Threads.sleep((long)100L);
                    LOG.debug("Sleeping before appending 100ms");
                }
            }
        });
        HRegion region = HRegion.openHRegion((Configuration)TEST_UTIL.getConfiguration(), (FileSystem)TEST_UTIL.getTestFileSystem(), (Path)TEST_UTIL.getDefaultRootDirPath(), (RegionInfo)hri, (TableDescriptor)htd, wal);
        EnvironmentEdge ee = EnvironmentEdgeManager.getDelegate();
        try {
            List<Put> puts = null;
            for (byte[] fam : htd.getColumnFamilyNames()) {
                puts = TestWALReplay.addRegionEdits(rowName, fam, 10, ee, (Region)region, "x");
            }
            Get g = new Get(rowName);
            Result result = region.get(g);
            Assert.assertEquals((long)(10 * htd.getColumnFamilyNames().size()), (long)result.size());
            WALEdit edits = new WALEdit();
            for (Put p : puts) {
                CellScanner cs = p.cellScanner();
                while (cs.advance()) {
                    edits.add(cs.current());
                }
            }
            ArrayList<UUID> clusterIds = new ArrayList<UUID>(1);
            clusterIds.add(TEST_UTIL.getRandomUUID());
            goslow.set(true);
            for (int i = 0; i < 10; ++i) {
                RegionInfo info = region.getRegionInfo();
                WALKeyImpl logkey = new WALKeyImpl(info.getEncodedNameAsBytes(), tableName, System.currentTimeMillis(), clusterIds, -1L, -1L, region.getMVCC(), scopes);
                wal.append(info, logkey, edits, true);
                region.getMVCC().completeAndWait(logkey.getWriteEntry());
            }
            region.flush(true);
            long currentSequenceId = region.getReadPoint(null);
            goslow.set(false);
            Assert.assertTrue((currentSequenceId >= region.getReadPoint(null) ? 1 : 0) != 0);
        }
        finally {
            region.close(true);
            wal.close();
        }
    }

    @Test
    public void testSyncNoAppend() throws IOException {
        String testName = this.currentTest.getMethodName();
        wal.init();
        try (AbstractFSWAL<?> wal = this.newWAL(FS, CommonFSUtils.getWALRootDir((Configuration)CONF), DIR.toString(), testName, CONF, null, true, null, null);){
            wal.sync();
        }
    }

    @Test
    public void testWriteEntryCanBeNull() throws IOException {
        String testName = this.currentTest.getMethodName();
        AbstractFSWAL<?> wal = this.newWAL(FS, CommonFSUtils.getWALRootDir((Configuration)CONF), DIR.toString(), testName, CONF, null, true, null, null);
        wal.close();
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)"table")).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"row")).build();
        RegionInfo ri = RegionInfoBuilder.newBuilder((TableName)td.getTableName()).build();
        MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl();
        TreeMap<byte[], Integer> scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        for (byte[] fam : td.getColumnFamilyNames()) {
            scopes.put(fam, 0);
        }
        long timestamp = System.currentTimeMillis();
        byte[] row = Bytes.toBytes((String)"row");
        WALEdit cols = new WALEdit();
        cols.add((Cell)new KeyValue(row, row, row, timestamp, row));
        WALKeyImpl key = new WALKeyImpl(ri.getEncodedNameAsBytes(), td.getTableName(), -1L, timestamp, WALKey.EMPTY_UUIDS, 0L, 0L, mvcc, scopes);
        try {
            wal.append(ri, key, cols, true);
            Assert.fail((String)"Should fail since the wal has already been closed");
        }
        catch (IOException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"log is closed"));
            Assert.assertNull((Object)key.getWriteEntry());
        }
    }

    private AbstractFSWAL<?> createHoldingWAL(String testName, final AtomicBoolean startHoldingForAppend, final CountDownLatch holdAppend) throws IOException {
        AbstractFSWAL<?> wal = this.newWAL(FS, CommonFSUtils.getRootDir((Configuration)CONF), testName, "oldWALs", CONF, null, true, null, null);
        wal.init();
        wal.registerWALActionsListener(new WALActionsListener(){

            public void visitLogEntryBeforeWrite(WALKey logKey, WALEdit logEdit) throws IOException {
                if (startHoldingForAppend.get()) {
                    try {
                        holdAppend.await();
                    }
                    catch (InterruptedException e) {
                        LOG.error(e.toString(), (Throwable)e);
                    }
                }
            }
        });
        return wal;
    }

    private HRegion createHoldingHRegion(Configuration conf, TableDescriptor htd, WAL wal) throws IOException {
        RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)htd.getTableName()).build();
        ChunkCreator.initialize((int)0x200000, (boolean)false, (long)0L, (float)0.0f, (float)0.0f, null, (float)0.1f);
        TEST_UTIL.createLocalHRegion(hri, CONF, htd, wal).close();
        RegionServerServices rsServices = (RegionServerServices)Mockito.mock(RegionServerServices.class);
        Mockito.when((Object)rsServices.getServerName()).thenReturn((Object)ServerName.valueOf((String)"localhost:12345", (long)123456L));
        Mockito.when((Object)rsServices.getConfiguration()).thenReturn((Object)conf);
        return HRegion.openHRegion((Path)TEST_UTIL.getDataTestDir(), (RegionInfo)hri, (TableDescriptor)htd, (WAL)wal, (Configuration)conf, (RegionServerServices)rsServices, null);
    }

    private void doPutWithAsyncWAL(ExecutorService exec, HRegion region, Put put, Runnable flushOrCloseRegion, AtomicBoolean startHoldingForAppend, CountDownLatch flushOrCloseFinished, CountDownLatch holdAppend) throws InterruptedException, IOException {
        region.put(put);
        startHoldingForAppend.set(true);
        region.put(new Put(put).setDurability(Durability.ASYNC_WAL));
        Threads.sleep((long)3000L);
        exec.submit(flushOrCloseRegion);
        Threads.sleep((long)3000L);
        holdAppend.countDown();
        flushOrCloseFinished.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnflushedSeqIdTrackingWithAsyncWal() throws IOException, InterruptedException {
        String testName = this.currentTest.getMethodName();
        byte[] b = Bytes.toBytes((String)"b");
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)"table")).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])b)).build();
        AtomicBoolean startHoldingForAppend = new AtomicBoolean(false);
        CountDownLatch holdAppend = new CountDownLatch(1);
        CountDownLatch closeFinished = new CountDownLatch(1);
        ExecutorService exec = Executors.newFixedThreadPool(1);
        AbstractFSWAL<?> wal = this.createHoldingWAL(testName, startHoldingForAppend, holdAppend);
        HRegion region = this.createHoldingHRegion(TEST_UTIL.getConfiguration(), htd, (WAL)wal);
        try {
            this.doPutWithAsyncWAL(exec, region, new Put(b).addColumn(b, b, b), () -> {
                try {
                    Map closeResult = region.close();
                    LOG.info("Close result:" + closeResult);
                    closeFinished.countDown();
                }
                catch (IOException e) {
                    LOG.error(e.toString(), (Throwable)e);
                }
            }, startHoldingForAppend, closeFinished, holdAppend);
            long seqId = wal.getEarliestMemStoreSeqNum(region.getRegionInfo().getEncodedNameAsBytes());
            Assert.assertEquals((String)"Found seqId for the region which is already closed", (long)-1L, (long)seqId);
        }
        finally {
            exec.shutdownNow();
            region.close();
            wal.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaxFlushedSequenceIdGoBackwards() throws IOException, InterruptedException {
        String testName = this.currentTest.getMethodName();
        byte[] a = Bytes.toBytes((String)"a");
        byte[] b = Bytes.toBytes((String)"b");
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)"table")).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])a)).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])b)).build();
        AtomicBoolean startHoldingForAppend = new AtomicBoolean(false);
        CountDownLatch holdAppend = new CountDownLatch(1);
        CountDownLatch flushFinished = new CountDownLatch(1);
        ExecutorService exec = Executors.newFixedThreadPool(2);
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.setClass("hbase.regionserver.flush.policy", FlushSpecificStoresPolicy.class, FlushPolicy.class);
        AbstractFSWAL<?> wal = this.createHoldingWAL(testName, startHoldingForAppend, holdAppend);
        HRegion region = this.createHoldingHRegion(conf, htd, (WAL)wal);
        try {
            Put put = new Put(a).addColumn(a, a, a).addColumn(b, b, b);
            this.doPutWithAsyncWAL(exec, region, put, () -> {
                try {
                    HRegion.FlushResult flushResult = region.flush(true);
                    LOG.info("Flush result:" + flushResult.getResult());
                    LOG.info("Flush succeeded:" + flushResult.isFlushSucceeded());
                    flushFinished.countDown();
                }
                catch (IOException e) {
                    LOG.error(e.toString(), (Throwable)e);
                }
            }, startHoldingForAppend, flushFinished, holdAppend);
            long maxFlushedSeqId1 = region.getMaxFlushedSeqId();
            region.put(put);
            STORES_TO_FLUSH.add(a);
            region.flush(false);
            long maxFlushedSeqId2 = region.getMaxFlushedSeqId();
            Assert.assertTrue((String)("maxFlushedSeqId1(" + maxFlushedSeqId1 + ") is not greater than or equal to maxFlushedSeqId2(" + maxFlushedSeqId2 + ")"), (maxFlushedSeqId1 <= maxFlushedSeqId2 ? 1 : 0) != 0);
        }
        finally {
            exec.shutdownNow();
            region.close();
            wal.close();
        }
    }

    static {
        TEST_UTIL = new HBaseTestingUtility();
        STORES_TO_FLUSH = Collections.newSetFromMap(new ConcurrentSkipListMap(Bytes.BYTES_COMPARATOR));
    }

    public static final class FlushSpecificStoresPolicy
    extends FlushPolicy {
        public Collection<HStore> selectStoresToFlush() {
            if (STORES_TO_FLUSH.isEmpty()) {
                return this.region.getStores();
            }
            return STORES_TO_FLUSH.stream().map(arg_0 -> ((HRegion)this.region).getStore(arg_0)).collect(Collectors.toList());
        }
    }
}

