/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Optional;
import java.util.TimerTask;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestRegionServerAbortTimeout {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionServerAbortTimeout.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRegionServerAbortTimeout.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = TableName.valueOf((String)"RSAbort");
    private static byte[] CF = Bytes.toBytes((String)"cf");
    private static byte[] CQ = Bytes.toBytes((String)"cq");
    private static final int REGIONS_NUM = 5;
    private static final int SLEEP_TIME_WHEN_CLOSE_REGION = 1000;
    private static volatile boolean abortTimeoutTaskScheduled = false;

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.setLong("hbase.regionserver.abort.timeout", 1000L);
        conf.set("hbase.regionserver.abort.timeout.task", TestAbortTimeoutTask.class.getName());
        StartMiniClusterOption option = StartMiniClusterOption.builder().numRegionServers(2).build();
        UTIL.startMiniCluster(option);
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)TABLE_NAME).setCoprocessor(SleepWhenCloseCoprocessor.class.getName()).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])CF).build()).build();
        UTIL.getAdmin().createTable(td, Bytes.toBytes((String)"0"), Bytes.toBytes((String)"9"), 5);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testAbortTimeout() throws Exception {
        Thread writer = new Thread(() -> {
            try (Table table = UTIL.getConnection().getTable(TABLE_NAME);){
                for (int i = 0; i < 10000; ++i) {
                    table.put(new Put(Bytes.toBytes((int)i)).addColumn(CF, CQ, Bytes.toBytes((int)i)));
                }
            }
            catch (IOException e) {
                LOG.warn("Failed to load data");
            }
        });
        writer.setDaemon(true);
        writer.start();
        UTIL.getMiniHBaseCluster().getRegionServer(0).abort("Abort RS for test");
        long startTime = System.currentTimeMillis();
        long timeout = 50000L;
        while (System.currentTimeMillis() - startTime < timeout) {
            if (UTIL.getMiniHBaseCluster().getLiveRegionServerThreads().size() == 1) {
                Assert.assertTrue((String)"Abort timer task should be scheduled", (boolean)abortTimeoutTaskScheduled);
                return;
            }
            Threads.sleep((long)1000L);
        }
        Assert.fail((String)("Failed to abort a region server in " + timeout + " ms"));
    }

    public static class SleepWhenCloseCoprocessor
    implements RegionCoprocessor,
    RegionObserver {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void preClose(ObserverContext<RegionCoprocessorEnvironment> c, boolean abortRequested) throws IOException {
            Threads.sleep((long)1000L);
        }
    }

    static class TestAbortTimeoutTask
    extends TimerTask {
        @Override
        public void run() {
            LOG.info("TestAbortTimeoutTask was scheduled");
            abortTimeoutTaskScheduled = true;
        }
    }
}

