/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.executor.ExecutorType;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class, RegionServerTests.class})
public class TestRegionOpen {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionOpen.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRegionOpen.class);
    private static final int NB_SERVERS = 1;
    private static final HBaseTestingUtility HTU = new HBaseTestingUtility();
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void before() throws Exception {
        HTU.startMiniCluster(1);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        HTU.shutdownMiniCluster();
    }

    private static HRegionServer getRS() {
        return HTU.getHBaseCluster().getLiveRegionServerThreads().get(0).getRegionServer();
    }

    @Test
    public void testPriorityRegionIsOpenedWithSeparateThreadPool() throws Exception {
        TableName tableName = TableName.valueOf((String)TestRegionOpen.class.getSimpleName());
        ThreadPoolExecutor exec = TestRegionOpen.getRS().getExecutorService().getExecutorThreadPool(ExecutorType.RS_OPEN_PRIORITY_REGION);
        long completed = exec.getCompletedTaskCount();
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.setPriority(200);
        htd.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        try (Connection connection = ConnectionFactory.createConnection((Configuration)HTU.getConfiguration());
             Admin admin = connection.getAdmin();){
            admin.createTable((TableDescriptor)htd);
        }
        Assert.assertEquals((long)(completed + 1L), (long)exec.getCompletedTaskCount());
    }

    @Test
    public void testNonExistentRegionReplica() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[] FAMILYNAME = Bytes.toBytes((String)"fam");
        FileSystem fs = HTU.getTestFileSystem();
        Admin admin = HTU.getAdmin();
        Configuration conf = HTU.getConfiguration();
        Path rootDir = HTU.getDataTestDirOnTestFS();
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor(FAMILYNAME));
        admin.createTable((TableDescriptor)htd);
        HTU.waitUntilNoRegionsInTransition(60000L);
        HRegionInfo hri = new HRegionInfo(htd.getTableName(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"B"), false, System.currentTimeMillis(), 2);
        HRegionFileSystem regionFs = HRegionFileSystem.createRegionOnFileSystem((Configuration)conf, (FileSystem)fs, (Path)CommonFSUtils.getTableDir((Path)rootDir, (TableName)hri.getTable()), (RegionInfo)hri);
        Path regionDir = regionFs.getRegionDir();
        try {
            HRegionFileSystem.loadRegionInfoFileContent((FileSystem)fs, (Path)regionDir);
        }
        catch (IOException e) {
            LOG.info("Caught expected IOE due missing .regioninfo file, due: " + e.getMessage() + " skipping region open.");
            List regions = admin.getTableRegions(tableName);
            LOG.info("Regions: " + regions);
            if (regions.size() != 1) {
                Assert.fail((String)("Table " + tableName + " should have only one region, but got more: " + regions));
            }
            return;
        }
        Assert.fail((String)"Should have thrown IOE when attempting to open a non-existing region.");
    }
}

