/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestOpenSeqNumUnexpectedIncrease {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestOpenSeqNumUnexpectedIncrease.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static AtomicInteger FAILED_OPEN = new AtomicInteger(0);
    private static TableName TABLE_NAME = TableName.valueOf((String)"test");
    private static byte[] CF = Bytes.toBytes((String)"CF");

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.getConfiguration().setInt("hbase.rpc.timeout", 600000);
        UTIL.getConfiguration().setClass("hbase.hregion.impl", MockHRegion.class, HRegion.class);
        UTIL.startMiniCluster(3);
        UTIL.createTable(TABLE_NAME, CF);
        UTIL.getAdmin().balancerSwitch(false, true);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws IOException, InterruptedException {
        HRegion region = UTIL.getMiniHBaseCluster().getRegions(TABLE_NAME).get(0);
        long openSeqNum = region.getOpenSeqNum();
        HRegionServer src = UTIL.getRSForFirstRegionInTable(TABLE_NAME);
        HRegionServer dst = UTIL.getOtherRegionServer(src);
        FAILED_OPEN.set(2);
        UTIL.getAdmin().move(region.getRegionInfo().getEncodedNameAsBytes(), dst.getServerName());
        UTIL.waitTableAvailable(TABLE_NAME);
        HRegion region1 = UTIL.getMiniHBaseCluster().getRegions(TABLE_NAME).get(0);
        long openSeqNum1 = region1.getOpenSeqNum();
        Assert.assertEquals((long)(openSeqNum + 2L), (long)openSeqNum1);
    }

    public static final class MockHRegion
    extends HRegion {
        public MockHRegion(Path tableDir, WAL wal, FileSystem fs, Configuration confParam, RegionInfo regionInfo, TableDescriptor htd, RegionServerServices rsServices) {
            super(tableDir, wal, fs, confParam, regionInfo, htd, rsServices);
        }

        protected void writeRegionOpenMarker(WAL wal, long openSeqId) throws IOException {
            if (this.getRegionInfo().getTable().equals((Object)TABLE_NAME) && FAILED_OPEN.get() > 0) {
                FAILED_OPEN.decrementAndGet();
                this.rsServices.abort("for testing", (Throwable)new Exception("Inject error for testing"));
                throw new IOException("Inject error for testing");
            }
        }

        public Map<byte[], List<HStoreFile>> close() throws IOException {
            return null;
        }
    }
}

