/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.region;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.master.region.MasterRegionTestBase;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestMasterRegionWALRecovery
extends MasterRegionTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestMasterRegionWALRecovery.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterRegionWALRecovery.class);
    private Path masterRegionDir;

    @Override
    protected void postSetUp() throws IOException {
        Configuration conf = this.htu.getConfiguration();
        Path testDir = this.htu.getDataTestDir();
        FileSystem fs = testDir.getFileSystem(conf);
        this.masterRegionDir = new Path(testDir, REGION_DIR_NAME);
    }

    @Test
    public void test() throws IOException, InterruptedException {
        this.region.update(r -> r.put(new Put(Bytes.toBytes((int)1)).addColumn(CF1, QUALIFIER, Bytes.toBytes((int)1))));
        this.region.flush(true);
        Path testDir = this.htu.getDataTestDir();
        FileSystem fs = testDir.getFileSystem(this.htu.getConfiguration());
        this.region.close(false);
        Path masterRegionWalDir = new Path(this.masterRegionDir, "WALs");
        LOG.info("WAL dir: {}", (Object)masterRegionWalDir);
        Assert.assertTrue((boolean)fs.exists(masterRegionWalDir));
        Object[] files = fs.listStatus(masterRegionWalDir);
        LOG.info("WAL files: {}", (Object)Arrays.toString(files));
        Assert.assertEquals((long)1L, (long)files.length);
        LOG.info("Deleting {}", (Object)masterRegionWalDir);
        fs.delete(masterRegionWalDir, true);
        this.createMasterRegion();
        Result r2 = this.region.get(new Get(Bytes.toBytes((int)1)));
        Cell c = r2.getColumnLatestCell(CF1, QUALIFIER);
        Assert.assertArrayEquals((byte[])Bytes.toBytes((int)1), (byte[])CellUtil.cloneValue((Cell)c));
    }
}

