/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.List;
import java.util.NavigableSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, LargeTests.class})
public class TestMasterRestartAfterDisablingTable {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterRestartAfterDisablingTable.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestMasterRestartAfterDisablingTable.class);
    @Rule
    public TestName name = new TestName();

    @Test
    public void testForCheckingIfEnableAndDisableWorksFineAfterSwitch() throws Exception {
        int NUM_MASTERS = 2;
        int NUM_REGIONS_TO_CREATE = 4;
        this.log("Starting cluster");
        Configuration conf = HBaseConfiguration.create();
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility(conf);
        StartMiniClusterOption option = StartMiniClusterOption.builder().numMasters(2).build();
        TEST_UTIL.startMiniCluster(option);
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        this.log("Waiting for active/ready master");
        cluster.waitForActiveAndReadyMaster();
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[] family = Bytes.toBytes((String)"family");
        this.log("Creating table with 4 regions");
        Table ht = TEST_UTIL.createMultiRegionTable(tableName, family, 4);
        int numRegions = -1;
        try (RegionLocator r = TEST_UTIL.getConnection().getRegionLocator(tableName);){
            numRegions = r.getStartKeys().length;
        }
        ++numRegions;
        this.log("Waiting for no more RIT\n");
        TEST_UTIL.waitUntilNoRegionsInTransition(60000L);
        this.log("Disabling table\n");
        TEST_UTIL.getAdmin().disableTable(tableName);
        NavigableSet<String> regions = HBaseTestingUtility.getAllOnlineRegions(cluster);
        Assert.assertEquals((String)"The number of regions for the table tableRestart should be 0 and onlythe catalog and namespace tables should be present.", (long)2L, (long)regions.size());
        List<JVMClusterUtil.MasterThread> masterThreads = cluster.getMasterThreads();
        JVMClusterUtil.MasterThread activeMaster = null;
        activeMaster = masterThreads.get(0).getMaster().isActiveMaster() ? masterThreads.get(0) : masterThreads.get(1);
        activeMaster.getMaster().stop("stopping the active master so that the backup can become active");
        cluster.hbaseCluster.waitOnMaster(activeMaster);
        cluster.waitForActiveAndReadyMaster();
        Assert.assertTrue((String)"The table should not be in enabled state", (boolean)cluster.getMaster().getTableStateManager().isTableState(TableName.valueOf((String)this.name.getMethodName()), new TableState.State[]{TableState.State.DISABLED, TableState.State.DISABLING}));
        this.log("Enabling table\n");
        Admin admin = TEST_UTIL.getAdmin();
        admin.enableTable(tableName);
        admin.close();
        this.log("Waiting for no more RIT\n");
        TEST_UTIL.waitUntilNoRegionsInTransition(60000L);
        this.log("Verifying there are " + numRegions + " assigned on cluster\n");
        regions = HBaseTestingUtility.getAllOnlineRegions(cluster);
        Assert.assertEquals((String)"The assigned regions were not onlined after master switch except for the catalog and namespace tables.", (long)6L, (long)regions.size());
        Assert.assertTrue((String)"The table should be in enabled state", (boolean)cluster.getMaster().getTableStateManager().isTableState(TableName.valueOf((String)this.name.getMethodName()), new TableState.State[]{TableState.State.ENABLED}));
        ht.close();
        TEST_UTIL.shutdownMiniCluster();
    }

    private void log(String msg) {
        LOG.debug("\n\nTRR: " + msg + "\n");
    }
}

