/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.balancer.StochasticLoadBalancer;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;

@Category(value={MasterTests.class, MediumTests.class})
public class TestMasterBalancerNPE {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterBalancerNPE.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] FAMILYNAME = Bytes.toBytes((String)"fam");
    @Rule
    public TestName name = new TestName();

    @Before
    public void setupConfiguration() {
        HMaster.setDisableBalancerChoreForTest((boolean)true);
    }

    @After
    public void shutdown() throws Exception {
        HMaster.setDisableBalancerChoreForTest((boolean)false);
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBalancerNPE() throws Exception {
        TEST_UTIL.startMiniCluster(2);
        TEST_UTIL.getAdmin().balancerSwitch(false, true);
        TableName tableName = this.createTable(this.name.getMethodName());
        HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
        List regionInfos = TEST_UTIL.getAdmin().getRegions(tableName);
        Assert.assertTrue((regionInfos.size() == 1 ? 1 : 0) != 0);
        ServerName serverName1 = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0).getServerName();
        ServerName serverName2 = TEST_UTIL.getMiniHBaseCluster().getRegionServer(1).getServerName();
        RegionInfo regionInfo = (RegionInfo)regionInfos.get(0);
        StochasticLoadBalancer loadBalancer = (StochasticLoadBalancer)master.getLoadBalancer();
        StochasticLoadBalancer spiedLoadBalancer = (StochasticLoadBalancer)Mockito.spy((Object)loadBalancer);
        AtomicReference regionPlanRef = new AtomicReference();
        ((StochasticLoadBalancer)Mockito.doAnswer(invocation -> {
            Map regionServerNameToRegionInfos = (Map)invocation.getArgument(1);
            ArrayList assignedRegionServerNames = new ArrayList();
            for (Map.Entry entry : regionServerNameToRegionInfos.entrySet()) {
                if (entry.getValue() == null) continue;
                ((List)entry.getValue()).stream().forEach(reginInfo -> {
                    if (reginInfo.getTable().equals((Object)tableName)) {
                        assignedRegionServerNames.add(entry.getKey());
                    }
                });
            }
            Assert.assertTrue((assignedRegionServerNames.size() == 1 ? 1 : 0) != 0);
            ServerName assignedRegionServerName = (ServerName)assignedRegionServerNames.get(0);
            ServerName notAssignedRegionServerName = assignedRegionServerName.equals((Object)serverName1) ? serverName2 : serverName1;
            RegionPlan regionPlan = new RegionPlan(regionInfo, assignedRegionServerName, notAssignedRegionServerName);
            regionPlanRef.set(regionPlan);
            return Arrays.asList(regionPlan);
        }).when((Object)spiedLoadBalancer)).balanceTable((TableName)Mockito.eq((Object)HConstants.ENSEMBLE_TABLE_NAME), Mockito.anyMap());
        AssignmentManager assignmentManager = master.getAssignmentManager();
        AssignmentManager spiedAssignmentManager = (AssignmentManager)Mockito.spy((Object)assignmentManager);
        CyclicBarrier cyclicBarrier = new CyclicBarrier(2);
        ((AssignmentManager)Mockito.doAnswer(invocation -> {
            RegionPlan regionPlan = (RegionPlan)invocation.getArgument(0);
            RegionPlan referedRegionPlan = (RegionPlan)regionPlanRef.get();
            Assert.assertTrue((referedRegionPlan != null ? 1 : 0) != 0);
            if (referedRegionPlan.equals((Object)regionPlan)) {
                cyclicBarrier.await();
                cyclicBarrier.await();
            }
            return invocation.callRealMethod();
        }).when((Object)spiedAssignmentManager)).balance((RegionPlan)Mockito.any());
        try {
            AtomicReference<Object> exceptionRef = new AtomicReference<Object>(null);
            Thread unassignThread = new Thread(() -> {
                try {
                    cyclicBarrier.await();
                    spiedAssignmentManager.unassign(regionInfo);
                    Assert.assertTrue((spiedAssignmentManager.getRegionStates().getRegionAssignments().get(regionInfo) == null ? 1 : 0) != 0);
                    cyclicBarrier.await();
                }
                catch (Exception e) {
                    exceptionRef.set(e);
                }
            });
            unassignThread.setName("UnassignThread");
            unassignThread.start();
            master.setLoadBalancer((LoadBalancer)spiedLoadBalancer);
            master.setAssignmentManager(spiedAssignmentManager);
            TEST_UTIL.getAdmin().balancerSwitch(true, false);
            master.balance();
            unassignThread.join();
            Assert.assertTrue((exceptionRef.get() == null ? 1 : 0) != 0);
        }
        finally {
            master.setLoadBalancer((LoadBalancer)loadBalancer);
            master.setAssignmentManager(assignmentManager);
        }
    }

    private TableName createTable(String table) throws IOException {
        TableName tableName = TableName.valueOf((String)table);
        TEST_UTIL.createTable(tableName, FAMILYNAME);
        return tableName;
    }
}

