/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.testclassification.CoprocessorTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;

@Category(value={CoprocessorTests.class, MediumTests.class})
public class TestCoprocessorInterface {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCoprocessorInterface.class);
    @Rule
    public TestName name = new TestName();
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    static final Path DIR = TEST_UTIL.getDataTestDir();

    @Test
    public void testSharedData() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] families = new byte[][]{HBaseTestingUtility.fam1, HBaseTestingUtility.fam2, HBaseTestingUtility.fam3};
        Configuration hc = this.initConfig();
        HRegion region = this.initHRegion(tableName, this.name.getMethodName(), hc, new Class[0], families);
        for (int i = 0; i < 3; ++i) {
            HBaseTestCase.addContent((Region)region, HBaseTestingUtility.fam3);
            region.flush(true);
        }
        region.compact(false);
        region = this.reopenRegion(region, CoprocessorImpl.class, CoprocessorII.class);
        Coprocessor c = region.getCoprocessorHost().findCoprocessor(CoprocessorImpl.class);
        Coprocessor c2 = region.getCoprocessorHost().findCoprocessor(CoprocessorII.class);
        Object o = ((CoprocessorImpl)c).getSharedData().get("test1");
        Object o2 = ((CoprocessorII)c2).getSharedData().get("test2");
        Assert.assertNotNull((Object)o);
        Assert.assertNotNull((Object)o2);
        Assert.assertFalse((((CoprocessorImpl)c).getSharedData() == ((CoprocessorII)c2).getSharedData() ? 1 : 0) != 0);
        c = region.getCoprocessorHost().findCoprocessor(CoprocessorImpl.class);
        c2 = region.getCoprocessorHost().findCoprocessor(CoprocessorII.class);
        Assert.assertTrue((((CoprocessorImpl)c).getSharedData().get("test1") == o ? 1 : 0) != 0);
        Assert.assertTrue((((CoprocessorII)c2).getSharedData().get("test2") == o2 ? 1 : 0) != 0);
        try {
            byte[] r = region.getRegionInfo().getStartKey();
            if (r == null || r.length <= 0) {
                r = new byte[]{0};
            }
            Get g = new Get(r);
            region.get(g);
            Assert.fail();
        }
        catch (DoNotRetryIOException r) {
            // empty catch block
        }
        Assert.assertNull((Object)region.getCoprocessorHost().findCoprocessor(CoprocessorII.class));
        c = region.getCoprocessorHost().findCoprocessor(CoprocessorImpl.class);
        Assert.assertTrue((((CoprocessorImpl)c).getSharedData().get("test1") == o ? 1 : 0) != 0);
        c2 = null;
        c = null;
        System.gc();
        region = this.reopenRegion(region, CoprocessorImpl.class, CoprocessorII.class);
        c = region.getCoprocessorHost().findCoprocessor(CoprocessorImpl.class);
        Assert.assertTrue((((CoprocessorImpl)c).getSharedData().get("test1") == o ? 1 : 0) != 0);
        c2 = region.getCoprocessorHost().findCoprocessor(CoprocessorII.class);
        Object o3 = ((CoprocessorII)c2).getSharedData().get("test2");
        Assert.assertFalse((o3 == o2 ? 1 : 0) != 0);
        HBaseTestingUtility.closeRegionAndWAL(region);
    }

    @Test
    public void testCoprocessorInterface() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] families = new byte[][]{HBaseTestingUtility.fam1, HBaseTestingUtility.fam2, HBaseTestingUtility.fam3};
        Configuration hc = this.initConfig();
        HRegion region = this.initHRegion(tableName, this.name.getMethodName(), hc, new Class[]{CoprocessorImpl.class}, families);
        for (int i = 0; i < 3; ++i) {
            HBaseTestCase.addContent((Region)region, HBaseTestingUtility.fam3);
            region.flush(true);
        }
        region.compact(false);
        Scan s = new Scan();
        RegionScanner scanner = region.getCoprocessorHost().postScannerOpen(s, (RegionScanner)region.getScanner(s));
        Assert.assertTrue((boolean)(scanner instanceof CustomScanner));
        scanner.next(new ArrayList());
        HBaseTestingUtility.closeRegionAndWAL(region);
        Coprocessor c = region.getCoprocessorHost().findCoprocessor(CoprocessorImpl.class);
        Assert.assertTrue((String)"Coprocessor not started", (boolean)((CoprocessorImpl)c).wasStarted());
        Assert.assertTrue((String)"Coprocessor not stopped", (boolean)((CoprocessorImpl)c).wasStopped());
        Assert.assertTrue((boolean)((CoprocessorImpl)c).wasOpened());
        Assert.assertTrue((boolean)((CoprocessorImpl)c).wasClosed());
        Assert.assertTrue((boolean)((CoprocessorImpl)c).wasFlushed());
        Assert.assertTrue((boolean)((CoprocessorImpl)c).wasCompacted());
    }

    HRegion reopenRegion(HRegion closedRegion, Class<?> ... implClasses) throws IOException {
        HRegion r = HRegion.openHRegion((HRegion)closedRegion, null);
        Configuration conf = TEST_UTIL.getConfiguration();
        RegionCoprocessorHost host = new RegionCoprocessorHost(r, (RegionServerServices)Mockito.mock(RegionServerServices.class), conf);
        r.setCoprocessorHost(host);
        for (Class<?> implClass : implClasses) {
            host.load(implClass.asSubclass(RegionCoprocessor.class), 0x3FFFFFFF, conf);
        }
        host.preOpen();
        host.postOpen();
        return r;
    }

    HRegion initHRegion(TableName tableName, String callingMethod, Configuration conf, Class<?>[] implClasses, byte[][] families) throws IOException {
        HTableDescriptor htd = new HTableDescriptor(tableName);
        for (byte[] family : families) {
            htd.addFamily(new HColumnDescriptor(family));
        }
        ChunkCreator.initialize((int)0x200000, (boolean)false, (long)0L, (float)0.0f, (float)0.0f, null, (float)0.1f);
        RegionInfo info = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(null).setEndKey(null).setSplit(false).build();
        Path path = new Path(DIR + callingMethod);
        HRegion r = HBaseTestingUtility.createRegionAndWAL(info, path, conf, (TableDescriptor)htd);
        RegionCoprocessorHost host = new RegionCoprocessorHost(r, (RegionServerServices)Mockito.mock(RegionServerServices.class), conf);
        r.setCoprocessorHost(host);
        for (Class<?> implClass : implClasses) {
            host.load(implClass.asSubclass(RegionCoprocessor.class), 0x3FFFFFFF, conf);
            Coprocessor c = host.findCoprocessor(implClass.getName());
            Assert.assertNotNull((Object)c);
        }
        host.preOpen();
        host.postOpen();
        return r;
    }

    private Configuration initConfig() {
        TEST_UTIL.getConfiguration().setInt("hbase.hstore.compactionThreshold", 2);
        TEST_UTIL.getConfiguration().setInt("hbase.client.scanner.timeout.period", 10000);
        TEST_UTIL.getConfiguration().setLong("hbase.client.pause", 15000L);
        TEST_UTIL.getConfiguration().setLong("hbase.hregion.max.filesize", 131072L);
        TEST_UTIL.getConfiguration().setBoolean("hbase.coprocessor.abortonerror", false);
        return TEST_UTIL.getConfiguration();
    }

    public static class CoprocessorII
    implements RegionCoprocessor {
        private ConcurrentMap<String, Object> sharedData;

        public void start(CoprocessorEnvironment e) {
            this.sharedData = ((RegionCoprocessorEnvironment)e).getSharedData();
            this.sharedData.putIfAbsent("test2", new Object());
        }

        public void stop(CoprocessorEnvironment e) {
            this.sharedData = null;
        }

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(new RegionObserver(){

                public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
                    throw new RuntimeException();
                }
            });
        }

        Map<String, Object> getSharedData() {
            return this.sharedData;
        }
    }

    public static class CoprocessorImpl
    implements RegionCoprocessor,
    RegionObserver {
        private boolean startCalled;
        private boolean stopCalled;
        private boolean preOpenCalled;
        private boolean postOpenCalled;
        private boolean preCloseCalled;
        private boolean postCloseCalled;
        private boolean preCompactCalled;
        private boolean postCompactCalled;
        private boolean preFlushCalled;
        private boolean postFlushCalled;
        private ConcurrentMap<String, Object> sharedData;

        public void start(CoprocessorEnvironment e) {
            this.sharedData = ((RegionCoprocessorEnvironment)e).getSharedData();
            this.sharedData.putIfAbsent("test1", new Object());
            this.startCalled = true;
        }

        public void stop(CoprocessorEnvironment e) {
            this.sharedData = null;
            this.stopCalled = true;
        }

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void preOpen(ObserverContext<RegionCoprocessorEnvironment> e) {
            this.preOpenCalled = true;
        }

        public void postOpen(ObserverContext<RegionCoprocessorEnvironment> e) {
            this.postOpenCalled = true;
        }

        public void preClose(ObserverContext<RegionCoprocessorEnvironment> e, boolean abortRequested) {
            this.preCloseCalled = true;
        }

        public void postClose(ObserverContext<RegionCoprocessorEnvironment> e, boolean abortRequested) {
            this.postCloseCalled = true;
        }

        public InternalScanner preCompact(ObserverContext<RegionCoprocessorEnvironment> e, Store store, InternalScanner scanner, ScanType scanType, CompactionLifeCycleTracker tracker, CompactionRequest request) {
            this.preCompactCalled = true;
            return scanner;
        }

        public void postCompact(ObserverContext<RegionCoprocessorEnvironment> e, Store store, StoreFile resultFile, CompactionLifeCycleTracker tracker, CompactionRequest request) {
            this.postCompactCalled = true;
        }

        public void preFlush(ObserverContext<RegionCoprocessorEnvironment> e, FlushLifeCycleTracker tracker) {
            this.preFlushCalled = true;
        }

        public void postFlush(ObserverContext<RegionCoprocessorEnvironment> e, FlushLifeCycleTracker tracker) {
            this.postFlushCalled = true;
        }

        public RegionScanner postScannerOpen(ObserverContext<RegionCoprocessorEnvironment> e, Scan scan, RegionScanner s) throws IOException {
            return new CustomScanner(s);
        }

        boolean wasStarted() {
            return this.startCalled;
        }

        boolean wasStopped() {
            return this.stopCalled;
        }

        boolean wasOpened() {
            return this.preOpenCalled && this.postOpenCalled;
        }

        boolean wasClosed() {
            return this.preCloseCalled && this.postCloseCalled;
        }

        boolean wasFlushed() {
            return this.preFlushCalled && this.postFlushCalled;
        }

        boolean wasCompacted() {
            return this.preCompactCalled && this.postCompactCalled;
        }

        Map<String, Object> getSharedData() {
            return this.sharedData;
        }
    }

    private static class CustomScanner
    implements RegionScanner {
        private RegionScanner delegate;

        public CustomScanner(RegionScanner delegate) {
            this.delegate = delegate;
        }

        public boolean next(List<Cell> results) throws IOException {
            return this.delegate.next(results);
        }

        public boolean next(List<Cell> result, ScannerContext scannerContext) throws IOException {
            return this.delegate.next(result, scannerContext);
        }

        public boolean nextRaw(List<Cell> result) throws IOException {
            return this.delegate.nextRaw(result);
        }

        public boolean nextRaw(List<Cell> result, ScannerContext context) throws IOException {
            return this.delegate.nextRaw(result, context);
        }

        public void close() throws IOException {
            this.delegate.close();
        }

        public RegionInfo getRegionInfo() {
            return this.delegate.getRegionInfo();
        }

        public boolean isFilterDone() throws IOException {
            return this.delegate.isFilterDone();
        }

        public boolean reseek(byte[] row) throws IOException {
            return false;
        }

        public long getMaxResultSize() {
            return this.delegate.getMaxResultSize();
        }

        public long getMvccReadPoint() {
            return this.delegate.getMvccReadPoint();
        }

        public int getBatch() {
            return this.delegate.getBatch();
        }
    }
}

