/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HTestConst;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.ColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueExcludeFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class})
public class TestServerSideScanMetricsFromClientSide {
    private static final Logger LOG = LoggerFactory.getLogger(TestServerSideScanMetricsFromClientSide.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestServerSideScanMetricsFromClientSide.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static Table TABLE = null;
    private static TableName TABLE_NAME = TableName.valueOf((String)"testTable");
    private static int NUM_ROWS = 10;
    private static byte[] ROW = Bytes.toBytes((String)"testRow");
    private static byte[][] ROWS = HTestConst.makeNAscii(ROW, NUM_ROWS);
    private static int NUM_FAMILIES = 1;
    private static byte[] FAMILY = Bytes.toBytes((String)"testFamily");
    private static byte[][] FAMILIES = HTestConst.makeNAscii(FAMILY, NUM_FAMILIES);
    private static int NUM_QUALIFIERS = 1;
    private static byte[] QUALIFIER = Bytes.toBytes((String)"testQualifier");
    private static byte[][] QUALIFIERS = HTestConst.makeNAscii(QUALIFIER, NUM_QUALIFIERS);
    private static int VALUE_SIZE = 10;
    private static byte[] VALUE = Bytes.createMaxByteArray((int)VALUE_SIZE);
    private static int NUM_COLS = NUM_FAMILIES * NUM_QUALIFIERS;
    private static long CELL_HEAP_SIZE = -1L;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(3);
        TABLE = TestServerSideScanMetricsFromClientSide.createTestTable(TABLE_NAME, ROWS, FAMILIES, QUALIFIERS, VALUE);
    }

    static Table createTestTable(TableName name, byte[][] rows, byte[][] families, byte[][] qualifiers, byte[] cellValue) throws IOException {
        Table ht = TEST_UTIL.createTable(name, families);
        ArrayList<Put> puts = TestServerSideScanMetricsFromClientSide.createPuts(rows, families, qualifiers, cellValue);
        ht.put(puts);
        return ht;
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    static ArrayList<Put> createPuts(byte[][] rows, byte[][] families, byte[][] qualifiers, byte[] value) throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int row = 0; row < rows.length; ++row) {
            Put put = new Put(rows[row]);
            for (int fam = 0; fam < families.length; ++fam) {
                for (int qual = 0; qual < qualifiers.length; ++qual) {
                    KeyValue kv = new KeyValue(rows[row], families[fam], qualifiers[qual], (long)qual, value);
                    put.add((Cell)kv);
                }
            }
            puts.add(put);
        }
        return puts;
    }

    private long getCellHeapSize() throws Exception {
        if (CELL_HEAP_SIZE == -1L) {
            Scan scan = new Scan();
            scan.setMaxResultSize(1L);
            scan.setAllowPartialResults(true);
            ResultScanner scanner = TABLE.getScanner(scan);
            Result result = scanner.next();
            Assert.assertTrue((result != null ? 1 : 0) != 0);
            Assert.assertTrue((result.rawCells() != null ? 1 : 0) != 0);
            Assert.assertTrue((result.rawCells().length == 1 ? 1 : 0) != 0);
            CELL_HEAP_SIZE = result.rawCells()[0].heapSize();
            scanner.close();
        }
        return CELL_HEAP_SIZE;
    }

    @Test
    public void testRowsSeenMetricWithSync() throws Exception {
        this.testRowsSeenMetric(false);
    }

    @Test
    public void testRowsSeenMetricWithAsync() throws Exception {
        this.testRowsSeenMetric(true);
    }

    private void testRowsSeenMetric(boolean async) throws Exception {
        Scan baseScan = new Scan();
        baseScan.setScanMetricsEnabled(true);
        baseScan.setAsyncPrefetch(async);
        try {
            this.testRowsSeenMetric(baseScan);
            baseScan.setCaching(1);
            this.testRowsSeenMetric(baseScan);
            baseScan.setMaxResultSize(1L);
            this.testRowsSeenMetric(baseScan);
            baseScan.setCaching(NUM_ROWS);
            baseScan.setMaxResultSize(this.getCellHeapSize() * (long)(NUM_COLS - 1));
            this.testRowsSeenMetric(baseScan);
        }
        catch (Throwable t) {
            LOG.error("FAIL", t);
            throw t;
        }
    }

    public void testRowsSeenMetric(Scan baseScan) throws Exception {
        int i;
        Scan scan = new Scan(baseScan);
        this.testMetric(scan, "ROWS_SCANNED", NUM_ROWS);
        for (i = 0; i < ROWS.length - 1; ++i) {
            scan = new Scan(baseScan);
            scan.withStartRow(ROWS[0]);
            scan.withStopRow(ROWS[i + 1]);
            this.testMetric(scan, "ROWS_SCANNED", i + 1);
        }
        for (i = ROWS.length - 1; i > 0; --i) {
            scan = new Scan(baseScan);
            scan.withStartRow(ROWS[i - 1]);
            scan.withStopRow(ROWS[ROWS.length - 1]);
            this.testMetric(scan, "ROWS_SCANNED", ROWS.length - i);
        }
        RowFilter filter = new RowFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"xyz")));
        scan = new Scan(baseScan);
        scan.setFilter((Filter)filter);
        this.testMetric(scan, "ROWS_SCANNED", ROWS.length);
        SingleColumnValueFilter singleColumnValueFilter = new SingleColumnValueFilter(FAMILIES[0], QUALIFIERS[0], CompareOperator.EQUAL, VALUE);
        scan = new Scan(baseScan);
        scan.setFilter((Filter)singleColumnValueFilter);
        this.testMetric(scan, "ROWS_SCANNED", ROWS.length);
        singleColumnValueFilter = new SingleColumnValueFilter(FAMILIES[0], QUALIFIERS[0], CompareOperator.NOT_EQUAL, VALUE);
        scan = new Scan(baseScan);
        scan.setFilter((Filter)singleColumnValueFilter);
        this.testMetric(scan, "ROWS_SCANNED", ROWS.length);
    }

    @Test
    public void testRowsFilteredMetric() throws Exception {
        Scan baseScan = new Scan();
        baseScan.setScanMetricsEnabled(true);
        this.testRowsFilteredMetric(baseScan);
        baseScan.setCaching(1);
        this.testRowsFilteredMetric(baseScan);
        baseScan.setMaxResultSize(1L);
        this.testRowsFilteredMetric(baseScan);
        baseScan.setCaching(NUM_ROWS);
        baseScan.setMaxResultSize(this.getCellHeapSize() * (long)(NUM_COLS - 1));
        this.testRowsSeenMetric(baseScan);
    }

    public void testRowsFilteredMetric(Scan baseScan) throws Exception {
        this.testRowsFilteredMetric(baseScan, null, 0);
        RowFilter filter = new RowFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"xyz")));
        this.testRowsFilteredMetric(baseScan, (Filter)filter, ROWS.length);
        filter = new FirstKeyOnlyFilter();
        this.testRowsFilteredMetric(baseScan, (Filter)filter, 0);
        filter = new ColumnPrefixFilter(QUALIFIERS[0]);
        this.testRowsFilteredMetric(baseScan, (Filter)filter, 0);
        filter = new ColumnPrefixFilter(Bytes.toBytes((String)"xyz"));
        this.testRowsFilteredMetric(baseScan, (Filter)filter, ROWS.length);
        filter = new SingleColumnValueFilter(FAMILIES[0], QUALIFIERS[0], CompareOperator.EQUAL, VALUE);
        this.testRowsFilteredMetric(baseScan, (Filter)filter, 0);
        filter = new SingleColumnValueFilter(FAMILIES[0], QUALIFIERS[0], CompareOperator.NOT_EQUAL, VALUE);
        this.testRowsFilteredMetric(baseScan, (Filter)filter, ROWS.length);
        ArrayList<Object> filters = new ArrayList<Object>();
        filters.add(new RowFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(ROWS[0])));
        filters.add(new RowFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(ROWS[3])));
        int numberOfMatchingRowFilters = filters.size();
        filter = new FilterList(FilterList.Operator.MUST_PASS_ONE, filters);
        this.testRowsFilteredMetric(baseScan, (Filter)filter, ROWS.length - numberOfMatchingRowFilters);
        filters.clear();
        for (int family = 0; family < FAMILIES.length; ++family) {
            for (int qualifier = 0; qualifier < QUALIFIERS.length; ++qualifier) {
                filters.add(new SingleColumnValueExcludeFilter(FAMILIES[family], QUALIFIERS[qualifier], CompareOperator.EQUAL, VALUE));
            }
        }
        filter = new FilterList(FilterList.Operator.MUST_PASS_ONE, filters);
        this.testRowsFilteredMetric(baseScan, (Filter)filter, ROWS.length);
    }

    public void testRowsFilteredMetric(Scan baseScan, Filter filter, int expectedNumFiltered) throws Exception {
        Scan scan = new Scan(baseScan);
        if (filter != null) {
            scan.setFilter(filter);
        }
        this.testMetric(scan, "ROWS_FILTERED", expectedNumFiltered);
    }

    public void testMetric(Scan scan, String metricKey, long expectedValue) throws Exception {
        Assert.assertTrue((String)"Scan should be configured to record metrics", (boolean)scan.isScanMetricsEnabled());
        ResultScanner scanner = TABLE.getScanner(scan);
        while (scanner.next() != null) {
        }
        scanner.close();
        ScanMetrics metrics = scanner.getScanMetrics();
        Assert.assertTrue((String)"Metrics are null", (metrics != null ? 1 : 0) != 0);
        Assert.assertTrue((String)("Metric : " + metricKey + " does not exist"), (boolean)metrics.hasCounter(metricKey));
        long actualMetricValue = metrics.getCounter(metricKey).get();
        Assert.assertEquals((String)("Metric: " + metricKey + " Expected: " + expectedValue + " Actual: " + actualMetricValue), (long)expectedValue, (long)actualMetricValue);
    }
}

