/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.hadoop;

import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.mapreduce.hadoop.mapreduce.TaskAttemptContextImpl;

public final class IDConverter {
    private IDConverter() {
    }

    public static JobID toMRJobId(TezDAGID dagId) {
        return new JobID(Long.toString(dagId.getApplicationId().getClusterTimestamp()), dagId.getApplicationId().getId());
    }

    public static TaskID toMRTaskId(TezTaskID taskid) {
        return new TaskID((org.apache.hadoop.mapreduce.JobID)IDConverter.toMRJobId(taskid.getDAGID()), taskid.getVertexID().getId() == 0 ? TaskType.MAP : TaskType.REDUCE, taskid.getId());
    }

    public static TaskID toMRTaskIdForOutput(TezTaskID taskid) {
        return TaskAttemptContextImpl.createMockTaskAttemptIDFromTezTaskId(taskid, taskid.getVertexID().getId() == 0);
    }

    public static org.apache.hadoop.mapred.TaskAttemptID toMRTaskAttemptId(TezTaskAttemptID taskAttemptId) {
        return new org.apache.hadoop.mapred.TaskAttemptID(IDConverter.toMRTaskId(taskAttemptId.getTaskID()), taskAttemptId.getId());
    }

    public static TezDAGID fromMRJobId(org.apache.hadoop.mapreduce.JobID jobId) {
        return TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)Long.parseLong(jobId.getJtIdentifier()), (int)jobId.getId()), (int)1);
    }

    public static TezTaskID fromMRTaskId(org.apache.hadoop.mapreduce.TaskID taskid) {
        return TezTaskID.getInstance((TezVertexID)TezVertexID.getInstance((TezDAGID)IDConverter.fromMRJobId(taskid.getJobID()), (int)(taskid.getTaskType() == TaskType.MAP ? 0 : 1)), (int)taskid.getId());
    }

    public static TezTaskAttemptID fromMRTaskAttemptId(TaskAttemptID taskAttemptId) {
        return TezTaskAttemptID.getInstance((TezTaskID)IDConverter.fromMRTaskId(taskAttemptId.getTaskID()), (int)taskAttemptId.getId());
    }
}

