/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark.plan;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.CollectableLoadFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.IndexableLoadFunc;
import org.apache.pig.LoadFunc;
import org.apache.pig.OrderedLoadFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MergeJoinIndexer;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.ScalarPhyFinder;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.UDFFinder;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ConstantExpression;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POUserFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POBroadcastSpark;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POCollectedGroup;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POCounter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POCross;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PODistinct;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFRJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFRJoinSpark;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFilter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POForEach;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POGlobalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLimit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POMergeCogroup;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POMergeJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PONative;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PORank;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSkewedJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSort;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSplit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStream;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POUnion;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.Packager;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.util.PlanHelper;
import org.apache.pig.backend.hadoop.executionengine.spark.SparkUtil;
import org.apache.pig.backend.hadoop.executionengine.spark.operator.NativeSparkOperator;
import org.apache.pig.backend.hadoop.executionengine.spark.operator.POGlobalRearrangeSpark;
import org.apache.pig.backend.hadoop.executionengine.spark.operator.POPoissonSampleSpark;
import org.apache.pig.backend.hadoop.executionengine.spark.operator.POSampleSortSpark;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkCompilerException;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOperPlan;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOperator;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.builtin.DefaultIndexableLoader;
import org.apache.pig.impl.builtin.GetMemNumRows;
import org.apache.pig.impl.builtin.PartitionSkewedKeys;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.OperatorPlan;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.newplan.logical.relational.LOJoin;

public class SparkCompiler
extends PhyPlanVisitor {
    private static final Log LOG = LogFactory.getLog(SparkCompiler.class);
    private PigContext pigContext;
    private Properties pigProperties;
    private PhysicalPlan physicalPlan;
    private SparkOperPlan sparkPlan;
    private SparkOperator curSparkOp;
    private String scope;
    private SparkOperator[] compiledInputs = null;
    private Map<OperatorKey, SparkOperator> splitsSeen;
    private NodeIdGenerator nig;
    private Map<PhysicalOperator, SparkOperator> phyToSparkOpMap;
    private UDFFinder udfFinder;

    public SparkCompiler(PhysicalPlan physicalPlan, PigContext pigContext) {
        super(physicalPlan, (PlanWalker<PhysicalOperator, PhysicalPlan>)new DepthFirstWalker<PhysicalOperator, PhysicalPlan>(physicalPlan));
        this.physicalPlan = physicalPlan;
        this.pigContext = pigContext;
        this.pigProperties = pigContext.getProperties();
        this.sparkPlan = new SparkOperPlan();
        this.phyToSparkOpMap = new HashMap<PhysicalOperator, SparkOperator>();
        this.udfFinder = new UDFFinder();
        this.nig = NodeIdGenerator.getGenerator();
        this.splitsSeen = new HashMap<OperatorKey, SparkOperator>();
    }

    public void compile() throws IOException, PlanException, VisitorException {
        ArrayList<PhysicalOperator> ops;
        List roots = this.physicalPlan.getRoots();
        if (roots == null || roots.size() <= 0) {
            int errCode = 2053;
            String msg = "Internal error. Did not find roots in the physical physicalPlan.";
            throw new SparkCompilerException(msg, errCode, 4);
        }
        this.scope = ((PhysicalOperator)roots.get(0)).getOperatorKey().getScope();
        List leaves = this.physicalPlan.getLeaves();
        if (!this.pigContext.inIllustrator) {
            for (PhysicalOperator op : leaves) {
                if (op instanceof POStore) continue;
                int errCode = 2025;
                String msg = "Expected leaf of reduce physicalPlan to always be POStore. Found " + op.getClass().getSimpleName();
                throw new SparkCompilerException(msg, errCode, 4);
            }
        }
        LinkedList<POStore> stores = PlanHelper.getPhysicalOperators(this.physicalPlan, POStore.class);
        LinkedList<PONative> nativeSparks = PlanHelper.getPhysicalOperators(this.physicalPlan, PONative.class);
        if (!this.pigContext.inIllustrator) {
            ops = new ArrayList<PhysicalOperator>(stores.size() + nativeSparks.size());
            ops.addAll(stores);
        } else {
            ops = new ArrayList(leaves.size() + nativeSparks.size());
            ops.addAll(leaves);
        }
        ops.addAll(nativeSparks);
        Collections.sort(ops);
        for (PhysicalOperator op : ops) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Starting compile of leaf-level operator " + op));
            }
            this.compile(op);
        }
    }

    private void compile(PhysicalOperator op) throws IOException, PlanException, VisitorException {
        SparkOperator[] prevCompInp = this.compiledInputs;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Compiling physical operator " + op + ". Current spark operator is " + this.curSparkOp));
        }
        List<PhysicalOperator> predecessors = this.physicalPlan.getPredecessors(op);
        if (!(op instanceof PONative)) {
            if (predecessors != null && predecessors.size() > 0) {
                if (op instanceof POLoad) {
                    if (predecessors.size() != 1) {
                        int errCode = 2125;
                        String msg = "Expected at most one predecessor of load. Got " + predecessors.size();
                        throw new PlanException(msg, errCode, 4);
                    }
                    PhysicalOperator p = predecessors.get(0);
                    SparkOperator oper = null;
                    if (!(p instanceof POStore) && !(p instanceof PONative)) {
                        int errCode = 2126;
                        String msg = "Predecessor of load should be a store or spark operator. Got " + p.getClass();
                        throw new PlanException(msg, errCode, 4);
                    }
                    oper = this.phyToSparkOpMap.get(p);
                    this.curSparkOp = this.getSparkOp();
                    this.curSparkOp.add(op);
                    this.sparkPlan.add(this.curSparkOp);
                    this.physicalPlan.disconnect(op, p);
                    this.sparkPlan.connect(oper, this.curSparkOp);
                    this.phyToSparkOpMap.put(op, this.curSparkOp);
                    return;
                }
                Collections.sort(predecessors);
                this.compiledInputs = new SparkOperator[predecessors.size()];
                int i = -1;
                for (PhysicalOperator pred : predecessors) {
                    if (pred instanceof POSplit && this.splitsSeen.containsKey(pred.getOperatorKey())) {
                        POSplit split = (POSplit)pred;
                        this.compiledInputs[++i] = this.startNew(split.getSplitStore(), this.splitsSeen.get(pred.getOperatorKey()), null);
                        continue;
                    }
                    this.compile(pred);
                    this.compiledInputs[++i] = this.curSparkOp;
                }
            } else {
                this.curSparkOp = this.getSparkOp();
                this.curSparkOp.add(op);
                if (op != null && op instanceof POLoad && ((POLoad)op).getLFile() != null && ((POLoad)op).getLFile().getFuncSpec() != null) {
                    this.curSparkOp.UDFs.add(((POLoad)op).getLFile().getFuncSpec().toString());
                }
                this.sparkPlan.add(this.curSparkOp);
                this.phyToSparkOpMap.put(op, this.curSparkOp);
                return;
            }
        }
        op.visit(this);
        this.compiledInputs = prevCompInp;
    }

    private SparkOperator getSparkOp() {
        SparkOperator op = new SparkOperator(OperatorKey.genOpKey(this.scope));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Created new Spark operator " + op));
        }
        return op;
    }

    public SparkOperPlan getSparkPlan() {
        return this.sparkPlan;
    }

    public void connectSoftLink() throws PlanException, IOException {
        for (PhysicalOperator op : this.physicalPlan) {
            if (this.physicalPlan.getSoftLinkPredecessors(op) == null) continue;
            for (PhysicalOperator pred : this.physicalPlan.getSoftLinkPredecessors(op)) {
                SparkOperator to;
                SparkOperator from = this.phyToSparkOpMap.get(pred);
                if (from == (to = this.phyToSparkOpMap.get(op)) || this.sparkPlan.getPredecessors(to) != null && this.sparkPlan.getPredecessors(to).contains(from)) continue;
                this.sparkPlan.connect(from, to);
            }
        }
    }

    private SparkOperator startNew(FileSpec fSpec, SparkOperator old, OperatorKey operatorKey) throws PlanException {
        POLoad ld = this.getLoad(operatorKey);
        ld.setLFile(fSpec);
        SparkOperator ret = this.getSparkOp();
        ret.add(ld);
        this.sparkPlan.add(ret);
        this.sparkPlan.connect(old, ret);
        return ret;
    }

    private POLoad getLoad(OperatorKey operatorKey) {
        POLoad ld = null;
        ld = operatorKey != null ? new POLoad(operatorKey) : new POLoad(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
        ld.setPc(this.pigContext);
        ld.setIsTmpLoad(true);
        return ld;
    }

    @Override
    public void visitSplit(POSplit op) throws VisitorException {
        try {
            List<POSplit> preds = this.physicalPlan.getPredecessors(op);
            OperatorKey predOperatorKey = null;
            if (preds != null && preds.size() > 0) {
                predOperatorKey = ((PhysicalOperator)preds.get(0)).getOperatorKey();
            }
            FileSpec fSpec = op.getSplitStore();
            SparkOperator sparkOp = this.endSingleInputPlanWithStr(fSpec);
            sparkOp.setSplitter(true);
            this.splitsSeen.put(op.getOperatorKey(), sparkOp);
            this.curSparkOp = this.startNew(fSpec, sparkOp, predOperatorKey);
            this.phyToSparkOpMap.put(op, this.curSparkOp);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new SparkCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitDistinct(PODistinct op) throws VisitorException {
        try {
            this.addToPlan(op);
            this.phyToSparkOpMap.put(op, this.curSparkOp);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new SparkCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    private SparkOperator endSingleInputPlanWithStr(FileSpec fSpec) throws PlanException {
        if (this.compiledInputs.length > 1) {
            int errCode = 2023;
            String msg = "Received a multi input physicalPlan when expecting only a single input one.";
            throw new PlanException(msg, errCode, 4);
        }
        SparkOperator sparkOp = this.compiledInputs[0];
        POStore str = this.getStore();
        str.setSFile(fSpec);
        sparkOp.physicalPlan.addAsLeaf(str);
        return sparkOp;
    }

    private POStore getStore() {
        POStore st = new POStore(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
        st.setIsTmpStore(true);
        return st;
    }

    @Override
    public void visitLoad(POLoad op) throws VisitorException {
        try {
            this.addToPlan(op);
            this.phyToSparkOpMap.put(op, this.curSparkOp);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new SparkCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitNative(PONative op) throws VisitorException {
        try {
            NativeSparkOperator nativesparkOpper = this.getNativeSparkOp(op.getNativeMRjar(), op.getParams());
            nativesparkOpper.markNative();
            this.sparkPlan.add(nativesparkOpper);
            this.sparkPlan.connect(this.curSparkOp, nativesparkOpper);
            this.phyToSparkOpMap.put(op, nativesparkOpper);
            this.curSparkOp = nativesparkOpper;
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new SparkCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    private NativeSparkOperator getNativeSparkOp(String sparkJar, String[] parameters) {
        return new NativeSparkOperator(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)), sparkJar, parameters);
    }

    @Override
    public void visitStore(POStore op) throws VisitorException {
        try {
            this.addToPlan(op);
            this.phyToSparkOpMap.put(op, this.curSparkOp);
            if (op.getSFile() != null && op.getSFile().getFuncSpec() != null) {
                this.curSparkOp.UDFs.add(op.getSFile().getFuncSpec().toString());
            }
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new SparkCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitFilter(POFilter op) throws VisitorException {
        try {
            this.addToPlan(op);
            this.processUDFs(op.getPlan());
            this.phyToSparkOpMap.put(op, this.curSparkOp);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new SparkCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitCross(POCross op) throws VisitorException {
        try {
            this.addToPlan(op);
            this.phyToSparkOpMap.put(op, this.curSparkOp);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new SparkCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitStream(POStream op) throws VisitorException {
        try {
            this.addToPlan(op);
            this.phyToSparkOpMap.put(op, this.curSparkOp);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new SparkCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitSort(POSort op) throws VisitorException {
        try {
            this.addToPlan(op);
            POSort sort = op;
            long limit = sort.getLimit();
            if (limit != -1L) {
                POLimit pLimit2 = new POLimit(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
                pLimit2.setLimit(limit);
                this.curSparkOp.physicalPlan.addAsLeaf(pLimit2);
                this.curSparkOp.markLimitAfterSort();
            }
            this.phyToSparkOpMap.put(op, this.curSparkOp);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new SparkCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitLimit(POLimit op) throws VisitorException {
        try {
            this.addToPlan(op);
            this.curSparkOp.markLimit();
            this.phyToSparkOpMap.put(op, this.curSparkOp);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new SparkCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitLocalRearrange(POLocalRearrange op) throws VisitorException {
        try {
            this.addToPlan(op);
            List<PhysicalPlan> plans = op.getPlans();
            if (plans != null) {
                for (PhysicalPlan ep : plans) {
                    this.processUDFs(ep);
                }
            }
            this.phyToSparkOpMap.put(op, this.curSparkOp);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new SparkCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitCollectedGroup(POCollectedGroup op) throws VisitorException {
        List roots = this.curSparkOp.physicalPlan.getRoots();
        if (roots.size() != 1) {
            int errCode = 2171;
            String errMsg = "Expected one but found more then one root physical operator in physical physicalPlan.";
            throw new SparkCompilerException(errMsg, errCode, 4);
        }
        PhysicalOperator phyOp = (PhysicalOperator)roots.get(0);
        if (!(phyOp instanceof POLoad)) {
            int errCode = 2172;
            String errMsg = "Expected physical operator at root to be POLoad. Found : " + phyOp.getClass().getCanonicalName();
            throw new SparkCompilerException(errMsg, errCode, 4);
        }
        LoadFunc loadFunc = ((POLoad)phyOp).getLoadFunc();
        try {
            if (!CollectableLoadFunc.class.isAssignableFrom(loadFunc.getClass())) {
                int errCode = 2249;
                throw new SparkCompilerException("While using 'collected' on group; data must be loaded via loader implementing CollectableLoadFunc.", errCode);
            }
            ((CollectableLoadFunc)((Object)loadFunc)).ensureAllKeyInstancesInSameSplit();
        }
        catch (SparkCompilerException e) {
            throw e;
        }
        catch (IOException e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new SparkCompilerException(msg, errCode, 4, (Throwable)e);
        }
        try {
            this.addToPlan(op);
            this.phyToSparkOpMap.put(op, this.curSparkOp);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new SparkCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitPOForEach(POForEach op) throws VisitorException {
        try {
            this.addToPlan(op);
            List<PhysicalPlan> plans = op.getInputPlans();
            if (plans != null) {
                for (PhysicalPlan ep : plans) {
                    this.processUDFs(ep);
                }
            }
            this.phyToSparkOpMap.put(op, this.curSparkOp);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new SparkCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitCounter(POCounter op) throws VisitorException {
        try {
            this.addToPlan(op);
            this.phyToSparkOpMap.put(op, this.curSparkOp);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new SparkCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitRank(PORank op) throws VisitorException {
        try {
            this.addToPlan(op);
            this.phyToSparkOpMap.put(op, this.curSparkOp);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new SparkCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitGlobalRearrange(POGlobalRearrange op) throws VisitorException {
        try {
            POGlobalRearrangeSpark glbOp = new POGlobalRearrangeSpark(op);
            this.addToPlan(glbOp);
            if (op.isCross()) {
                this.curSparkOp.addCrossKey(op.getOperatorKey().toString());
            }
            this.curSparkOp.customPartitioner = op.getCustomPartitioner();
            this.phyToSparkOpMap.put(op, this.curSparkOp);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new SparkCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitPackage(POPackage op) throws VisitorException {
        try {
            this.addToPlan(op);
            this.phyToSparkOpMap.put(op, this.curSparkOp);
            if (op.getPkgr().getPackageType() == Packager.PackageType.JOIN) {
                this.curSparkOp.markRegularJoin();
            } else if (op.getPkgr().getPackageType() == Packager.PackageType.GROUP) {
                if (op.getNumInps() == 1) {
                    this.curSparkOp.markGroupBy();
                } else if (op.getNumInps() > 1) {
                    this.curSparkOp.markCogroup();
                }
            }
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new SparkCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitUnion(POUnion op) throws VisitorException {
        try {
            this.addToPlan(op);
            this.phyToSparkOpMap.put(op, this.curSparkOp);
            this.curSparkOp.markUnion();
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new SparkCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitSkewedJoin(POSkewedJoin op) throws VisitorException {
        try {
            Random r = new Random();
            String pigKeyDistFile = "pig.keyDistFile" + r.nextInt();
            SparkOperator sampleSparkOp = this.getSkewedJoinSampleJob(op);
            this.buildBroadcastForSkewedJoin(sampleSparkOp, pigKeyDistFile);
            sampleSparkOp.markSampler();
            this.sparkPlan.add(sampleSparkOp);
            this.addToPlan(op);
            this.curSparkOp.setSkewedJoinPartitionFile(pigKeyDistFile);
            this.sparkPlan.connect(sampleSparkOp, this.curSparkOp);
            this.phyToSparkOpMap.put(op, this.curSparkOp);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new SparkCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitFRJoin(POFRJoin op) throws VisitorException {
        try {
            this.curSparkOp = this.phyToSparkOpMap.get(op.getInputs().get(op.getFragment()));
            for (int i = 0; i < this.compiledInputs.length; ++i) {
                SparkOperator sparkOperator = this.compiledInputs[i];
                if (this.curSparkOp.equals(sparkOperator)) continue;
                OperatorKey broadcastKey = new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope));
                POBroadcastSpark poBroadcastSpark = new POBroadcastSpark(broadcastKey);
                poBroadcastSpark.setBroadcastedVariableName(broadcastKey.toString());
                sparkOperator.physicalPlan.addAsLeaf(poBroadcastSpark);
            }
            POFRJoinSpark poFRJoinSpark = new POFRJoinSpark(op);
            this.addToPlan(poFRJoinSpark);
            this.phyToSparkOpMap.put(op, this.curSparkOp);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new SparkCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitMergeJoin(POMergeJoin joinOp) throws VisitorException {
        try {
            PhysicalPlan rightPipelinePlan;
            if (this.compiledInputs.length != 2 || joinOp.getInputs().size() != 2) {
                int errCode = 1101;
                throw new SparkCompilerException("Merge Join must have exactly two inputs. Found : " + this.compiledInputs.length, errCode);
            }
            this.curSparkOp = this.phyToSparkOpMap.get(joinOp.getInputs().get(0));
            SparkOperator rightSparkOp = this.curSparkOp.equals(this.compiledInputs[0]) ? this.compiledInputs[1] : this.compiledInputs[0];
            PhysicalPlan rightPhyPlan = rightSparkOp.physicalPlan;
            if (rightPhyPlan.getRoots().size() != 1) {
                int errCode = 2171;
                String errMsg = "Expected one but found more then one root physical operator in physical plan.";
                throw new SparkCompilerException(errMsg, errCode);
            }
            PhysicalOperator rightPhyLoader = (PhysicalOperator)rightPhyPlan.getRoots().get(0);
            if (!(rightPhyLoader instanceof POLoad)) {
                int errCode = 2172;
                String errMsg = "Expected physical operator at root to be POLoad. Found : " + rightPhyLoader.getClass().getCanonicalName();
                throw new SparkCompilerException(errMsg, errCode);
            }
            if (rightPhyPlan.getSuccessors(rightPhyLoader) == null || rightPhyPlan.getSuccessors(rightPhyLoader).isEmpty()) {
                rightPipelinePlan = null;
            } else {
                rightPipelinePlan = rightPhyPlan.clone();
                PhysicalOperator root = (PhysicalOperator)rightPipelinePlan.getRoots().get(0);
                rightPipelinePlan.disconnect(root, (Operator)rightPipelinePlan.getSuccessors(root).get(0));
                rightPipelinePlan.remove(root);
                rightPhyPlan.trimBelow(rightPhyLoader);
            }
            joinOp.setupRightPipeline(rightPipelinePlan);
            rightSparkOp.setRequestedParallelism(1);
            POLoad rightLoader = (POLoad)rightSparkOp.physicalPlan.getRoots().get(0);
            joinOp.setSignature(rightLoader.getSignature());
            LoadFunc rightLoadFunc = rightLoader.getLoadFunc();
            if (IndexableLoadFunc.class.isAssignableFrom(rightLoadFunc.getClass())) {
                joinOp.setRightLoaderFuncSpec(rightLoader.getLFile().getFuncSpec());
                joinOp.setRightInputFileName(rightLoader.getLFile().getFileName());
                this.curSparkOp.UDFs.add(rightLoader.getLFile().getFuncSpec().toString());
                this.sparkPlan.remove(rightSparkOp);
                if (rightSparkOp == this.compiledInputs[0]) {
                    this.compiledInputs[0] = null;
                } else if (rightSparkOp == this.compiledInputs[1]) {
                    this.compiledInputs[1] = null;
                }
                int numInputs = ((PhysicalPlan)this.mPlan).getPredecessors(joinOp).size();
                for (int i = 0; i < numInputs; ++i) {
                    List<PhysicalPlan> keyPlans = joinOp.getInnerPlansOf(i);
                    for (PhysicalPlan keyPlan : keyPlans) {
                        for (PhysicalOperator op : keyPlan) {
                            if (op instanceof POProject) continue;
                            int errCode = 1106;
                            String errMsg = "Merge join is possible only for simple column or '*' join keys when using " + rightLoader.getLFile().getFuncSpec() + " as the loader";
                            throw new SparkCompilerException(errMsg, errCode, 2);
                        }
                    }
                }
            } else {
                if (joinOp.getJoinType() == LOJoin.JOINTYPE.MERGESPARSE) {
                    int errCode = 1104;
                    String errMsg = "Right input of merge-join must implement IndexableLoadFunc. The specified loader " + rightLoadFunc + " doesn't implement it";
                    throw new SparkCompilerException(errMsg, errCode);
                }
                if (!OrderedLoadFunc.class.isAssignableFrom(rightLoadFunc.getClass())) {
                    int errCode = 1104;
                    String errMsg = "Right input of merge-join must implement OrderedLoadFunc interface. The specified loader " + rightLoadFunc + " doesn't implement it";
                    throw new SparkCompilerException(errMsg, errCode);
                }
                String[] indexerArgs = new String[6];
                List<PhysicalPlan> rightInpPlans = joinOp.getInnerPlansOf(1);
                FileSpec origRightLoaderFileSpec = rightLoader.getLFile();
                indexerArgs[0] = origRightLoaderFileSpec.getFuncSpec().toString();
                indexerArgs[1] = ObjectSerializer.serialize((Serializable)((Object)rightInpPlans));
                indexerArgs[2] = ObjectSerializer.serialize(rightPipelinePlan);
                indexerArgs[3] = rightLoader.getSignature();
                indexerArgs[4] = rightLoader.getOperatorKey().scope;
                indexerArgs[5] = Boolean.toString(true);
                FileSpec lFile = new FileSpec(rightLoader.getLFile().getFileName(), new FuncSpec(MergeJoinIndexer.class.getName(), indexerArgs));
                rightLoader.setLFile(lFile);
                rightSparkOp.useTypedComparator(true);
                POStore idxStore = this.getStore();
                FileSpec idxStrFile = this.getTempFileSpec();
                idxStore.setSFile(idxStrFile);
                rightSparkOp.physicalPlan.addAsLeaf(idxStore);
                rightSparkOp.markIndexer();
                this.curSparkOp.UDFs.add(origRightLoaderFileSpec.getFuncSpec().toString());
                this.sparkPlan.connect(rightSparkOp, this.curSparkOp);
                String[] defaultIndexableLoaderArgs = new String[]{origRightLoaderFileSpec.getFuncSpec().toString(), idxStrFile.getFileName(), idxStrFile.getFuncSpec().toString(), joinOp.getOperatorKey().scope, origRightLoaderFileSpec.getFileName()};
                joinOp.setRightLoaderFuncSpec(new FuncSpec(DefaultIndexableLoader.class.getName(), defaultIndexableLoaderArgs));
                joinOp.setRightInputFileName(origRightLoaderFileSpec.getFileName());
                joinOp.setIndexFile(idxStrFile.getFileName());
            }
            this.curSparkOp.physicalPlan.addAsLeaf(joinOp);
            this.phyToSparkOpMap.put(joinOp, this.curSparkOp);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + joinOp.getClass().getSimpleName();
            throw new SparkCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    private void processUDFs(PhysicalPlan plan) throws VisitorException {
        if (plan != null) {
            ScalarPhyFinder scalarPhyFinder = new ScalarPhyFinder(plan);
            scalarPhyFinder.visit();
            this.curSparkOp.scalars.addAll(scalarPhyFinder.getScalars());
            this.udfFinder.setPlan(plan);
            this.udfFinder.visit();
            this.curSparkOp.UDFs.addAll(this.udfFinder.getUDFs());
        }
    }

    private void addToPlan(PhysicalOperator op) throws PlanException, IOException {
        SparkOperator sparkOp = null;
        sparkOp = this.compiledInputs.length == 1 ? this.compiledInputs[0] : this.merge(this.compiledInputs);
        sparkOp.physicalPlan.addAsLeaf(op);
        this.curSparkOp = sparkOp;
    }

    private SparkOperator merge(SparkOperator[] compiledInputs) throws PlanException {
        SparkOperator ret = this.getSparkOp();
        this.sparkPlan.add(ret);
        HashSet<SparkOperator> toBeConnected = new HashSet<SparkOperator>();
        ArrayList<SparkOperator> toBeRemoved = new ArrayList<SparkOperator>();
        ArrayList<PhysicalPlan> toBeMerged = new ArrayList<PhysicalPlan>();
        for (SparkOperator sparkOperator : compiledInputs) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Merging Spark operator" + sparkOperator));
            }
            toBeRemoved.add(sparkOperator);
            toBeMerged.add(sparkOperator.physicalPlan);
            List<SparkOperator> predecessors = this.sparkPlan.getPredecessors(sparkOperator);
            if (predecessors == null) continue;
            for (SparkOperator predecessorSparkOp : predecessors) {
                toBeConnected.add(predecessorSparkOp);
            }
        }
        this.merge(ret.physicalPlan, toBeMerged);
        Iterator it = toBeConnected.iterator();
        while (it.hasNext()) {
            this.sparkPlan.connect((Operator)it.next(), ret);
        }
        for (SparkOperator removeSparkOp : toBeRemoved) {
            if (removeSparkOp.requestedParallelism > ret.requestedParallelism) {
                ret.requestedParallelism = removeSparkOp.requestedParallelism;
            }
            for (String udf : removeSparkOp.UDFs) {
                if (ret.UDFs.contains(udf)) continue;
                ret.UDFs.add(udf);
            }
            for (PhysicalOperator physOp : removeSparkOp.scalars) {
                if (ret.scalars.contains(physOp)) continue;
                ret.scalars.add(physOp);
            }
            if (removeSparkOp.getCrossKeys() != null) {
                for (String crossKey : removeSparkOp.getCrossKeys()) {
                    ret.addCrossKey(crossKey);
                }
            }
            HashSet<PhysicalOperator> hashSet = new HashSet<PhysicalOperator>();
            for (Map.Entry<PhysicalOperator, SparkOperator> entry : this.phyToSparkOpMap.entrySet()) {
                if (entry.getValue() != removeSparkOp) continue;
                hashSet.add(entry.getKey());
            }
            for (PhysicalOperator op : hashSet) {
                this.phyToSparkOpMap.put(op, ret);
            }
            this.sparkPlan.remove(removeSparkOp);
        }
        return ret;
    }

    private <O extends Operator<?>, E extends OperatorPlan<O>> void merge(E finPlan, List<E> plans) throws PlanException {
        for (OperatorPlan e : plans) {
            finPlan.merge(e);
        }
        Collections.sort(finPlan.getLeaves());
    }

    @Override
    public void visitMergeCoGroup(POMergeCogroup poCoGrp) throws VisitorException {
        if (this.compiledInputs.length < 2) {
            int errCode = 2251;
            String errMsg = "Merge Cogroup work on two or more relations.To use map-side group-by on single relation, use 'collected' qualifier.";
            throw new SparkCompilerException(errMsg, errCode);
        }
        ArrayList<FuncSpec> funcSpecs = new ArrayList<FuncSpec>(this.compiledInputs.length - 1);
        ArrayList<String> fileSpecs = new ArrayList<String>(this.compiledInputs.length - 1);
        ArrayList<String> loaderSigns = new ArrayList<String>(this.compiledInputs.length - 1);
        try {
            poCoGrp.setEndOfRecordMark((byte)1);
            for (int i = 0; i < this.compiledInputs.length; ++i) {
                SparkOperator sparkOper = this.compiledInputs[i];
                PhysicalPlan plan = sparkOper.physicalPlan;
                if (plan.getRoots().size() != 1) {
                    int errCode = 2171;
                    String errMsg = "Expected one but found more then one root physical operator in physical plan.";
                    throw new SparkCompilerException(errMsg, errCode, 4);
                }
                PhysicalOperator rootPOOp = (PhysicalOperator)plan.getRoots().get(0);
                if (!(rootPOOp instanceof POLoad)) {
                    int errCode = 2172;
                    String errMsg = "Expected physical operator at root to be POLoad. Found : " + rootPOOp.getClass().getCanonicalName();
                    throw new SparkCompilerException(errMsg, errCode);
                }
                POLoad sideLoader = (POLoad)rootPOOp;
                FileSpec loadFileSpec = sideLoader.getLFile();
                FuncSpec funcSpec = loadFileSpec.getFuncSpec();
                LoadFunc loadfunc = sideLoader.getLoadFunc();
                if (i == 0) {
                    if (!CollectableLoadFunc.class.isAssignableFrom(loadfunc.getClass())) {
                        int errCode = 2252;
                        throw new SparkCompilerException("Base loader in Cogroup must implement CollectableLoadFunc.", errCode);
                    }
                    ((CollectableLoadFunc)((Object)loadfunc)).ensureAllKeyInstancesInSameSplit();
                    continue;
                }
                if (!IndexableLoadFunc.class.isAssignableFrom(loadfunc.getClass())) {
                    int errCode = 2253;
                    throw new SparkCompilerException("Side loaders in cogroup must implement IndexableLoadFunc.", errCode);
                }
                funcSpecs.add(funcSpec);
                fileSpecs.add(loadFileSpec.getFileName());
                loaderSigns.add(sideLoader.getSignature());
                this.sparkPlan.remove(sparkOper);
            }
            poCoGrp.setSideLoadFuncs(funcSpecs);
            poCoGrp.setSideFileSpecs(fileSpecs);
            poCoGrp.setLoaderSignatures(loaderSigns);
            SparkOperator baseSparkOp = this.phyToSparkOpMap.get(poCoGrp.getInputs().get(0));
            SparkOperator indexerSparkOp = this.getSparkOp();
            FileSpec idxFileSpec = this.getIndexingJob(indexerSparkOp, baseSparkOp, poCoGrp.getLRInnerPlansOf(0));
            poCoGrp.setIdxFuncSpec(idxFileSpec.getFuncSpec());
            poCoGrp.setIndexFileName(idxFileSpec.getFileName());
            baseSparkOp.physicalPlan.addAsLeaf(poCoGrp);
            for (FuncSpec funcSpec : funcSpecs) {
                baseSparkOp.UDFs.add(funcSpec.toString());
            }
            this.sparkPlan.add(indexerSparkOp);
            this.sparkPlan.connect(indexerSparkOp, baseSparkOp);
            this.phyToSparkOpMap.put(poCoGrp, baseSparkOp);
            this.curSparkOp = baseSparkOp;
        }
        catch (ExecException e) {
            throw new SparkCompilerException(e.getDetailedMessage(), e.getErrorCode(), e.getErrorSource(), (Throwable)e);
        }
        catch (SparkCompilerException mrce) {
            throw mrce;
        }
        catch (CloneNotSupportedException e) {
            throw new SparkCompilerException(e);
        }
        catch (PlanException e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + poCoGrp.getClass().getCanonicalName();
            throw new SparkCompilerException(msg, errCode, 4, (Throwable)e);
        }
        catch (IOException e) {
            int errCode = 3000;
            String errMsg = "IOException caught while compiling POMergeCoGroup";
            throw new SparkCompilerException(errMsg, errCode, e);
        }
    }

    private FileSpec getIndexingJob(SparkOperator indexerSparkOp, SparkOperator baseSparkOp, List<PhysicalPlan> mapperLRInnerPlans) throws SparkCompilerException, PlanException, ExecException, IOException, CloneNotSupportedException {
        PhysicalPlan phyPlan;
        PhysicalPlan baseMapPlan = baseSparkOp.physicalPlan;
        POLoad baseLoader = (POLoad)baseMapPlan.getRoots().get(0);
        FileSpec origLoaderFileSpec = baseLoader.getLFile();
        FuncSpec funcSpec = origLoaderFileSpec.getFuncSpec();
        LoadFunc loadFunc = baseLoader.getLoadFunc();
        if (!OrderedLoadFunc.class.isAssignableFrom(loadFunc.getClass())) {
            int errCode = 1104;
            String errMsg = "Base relation of merge-coGroup must implement OrderedLoadFunc interface. The specified loader " + funcSpec + " doesn't implement it";
            throw new SparkCompilerException(errMsg, errCode);
        }
        String[] indexerArgs = new String[6];
        indexerArgs[0] = funcSpec.toString();
        indexerArgs[1] = ObjectSerializer.serialize((Serializable)((Object)mapperLRInnerPlans));
        indexerArgs[3] = baseLoader.getSignature();
        indexerArgs[4] = baseLoader.getOperatorKey().scope;
        indexerArgs[5] = Boolean.toString(false);
        if (baseMapPlan.getSuccessors(baseLoader) == null || baseMapPlan.getSuccessors(baseLoader).isEmpty()) {
            phyPlan = null;
        } else {
            phyPlan = baseMapPlan.clone();
            PhysicalOperator root = (PhysicalOperator)phyPlan.getRoots().get(0);
            phyPlan.disconnect(root, (Operator)phyPlan.getSuccessors(root).get(0));
            phyPlan.remove(root);
        }
        indexerArgs[2] = ObjectSerializer.serialize(phyPlan);
        POLoad idxJobLoader = this.getLoad(null);
        idxJobLoader.setLFile(new FileSpec(origLoaderFileSpec.getFileName(), new FuncSpec(MergeJoinIndexer.class.getName(), indexerArgs)));
        indexerSparkOp.physicalPlan.add(idxJobLoader);
        indexerSparkOp.UDFs.add(baseLoader.getLFile().getFuncSpec().toString());
        SparkUtil.createIndexerSparkNode(indexerSparkOp, this.scope, this.nig);
        POStore st = this.getStore();
        FileSpec strFile = this.getTempFileSpec();
        st.setSFile(strFile);
        indexerSparkOp.physicalPlan.addAsLeaf(st);
        return strFile;
    }

    private FileSpec getTempFileSpec() throws IOException {
        return new FileSpec(FileLocalizer.getTemporaryPath(this.pigContext).toString(), new FuncSpec(Utils.getTmpFileCompressorName(this.pigContext)));
    }

    private void addSampleOperatorForSkewedJoin(SparkOperator sampleSparkOp) throws PlanException {
        Configuration conf = ConfigurationUtil.toConfiguration(this.pigProperties);
        int sampleRate = conf.getInt("pig.sksampler.samplerate", 17);
        float heapPerc = conf.getFloat("pig.skewedjoin.reduce.memusage", 0.3f);
        long totalMemory = conf.getLong("pig.skewedjoin.reduce.mem", -1L);
        POPoissonSampleSpark poSample = new POPoissonSampleSpark(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)), -1, sampleRate, heapPerc, totalMemory);
        sampleSparkOp.physicalPlan.addAsLeaf(poSample);
    }

    private SparkOperator getSortJob(POSort sort, SparkOperator quantJob, FileSpec lFile, FileSpec quantFile, int rp, Pair<POProject, Byte>[] fields) throws PlanException {
        SparkOperator sparkOper = this.startNew(lFile, quantJob, null);
        ArrayList<PhysicalPlan> eps1 = new ArrayList<PhysicalPlan>();
        byte keyType = 0;
        if (fields == null) {
            PhysicalPlan ep = new PhysicalPlan();
            POProject prj = new POProject(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
            prj.setStar(true);
            prj.setOverloaded(false);
            prj.setResultType((byte)110);
            ep.add(prj);
            eps1.add(ep);
        } else {
            eps1.addAll(sort.getSortPlans());
            try {
                FindKeyTypeVisitor fktv = new FindKeyTypeVisitor(sort.getSortPlans().get(0));
                fktv.visit();
                keyType = fktv.keyType;
            }
            catch (VisitorException ve) {
                int errCode = 2035;
                String msg = "Internal error. Could not compute key type of sort operator.";
                throw new PlanException(msg, errCode, 4, (Throwable)ve);
            }
        }
        POLocalRearrange lr = new POLocalRearrange(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
        try {
            lr.setIndex(0);
        }
        catch (ExecException e) {
            int errCode = 2058;
            String msg = "Unable to set index on newly created POLocalRearrange.";
            throw new PlanException(msg, errCode, 4, (Throwable)e);
        }
        lr.setKeyType(fields == null || fields.length > 1 ? (byte)110 : keyType);
        lr.setPlans(eps1);
        lr.setResultType((byte)110);
        lr.addOriginalLocation(sort.getAlias(), sort.getOriginalLocations());
        sparkOper.physicalPlan.addAsLeaf(lr);
        sparkOper.setGlobalSort(true);
        this.pigContext.getProperties().setProperty("pig.reduce.keytype", Byte.toString(lr.getKeyType()));
        sparkOper.requestedParallelism = rp;
        sparkOper.physicalPlan.addAsLeaf(sort);
        long limit = sort.getLimit();
        if (limit != -1L) {
            POLimit pLimit2 = new POLimit(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
            pLimit2.setLimit(limit);
            sparkOper.physicalPlan.addAsLeaf(pLimit2);
            sparkOper.markLimitAfterSort();
        }
        return sparkOper;
    }

    private SparkOperator getSamplingJob(POSort sort, SparkOperator sampleOperator, List<PhysicalPlan> transformPlans, int rp, String udfClassName, String[] udfArgs) throws PlanException, VisitorException, ExecException {
        this.addSampleOperatorForSkewedJoin(sampleOperator);
        ArrayList<Boolean> flat1 = new ArrayList<Boolean>();
        ArrayList<PhysicalPlan> eps1 = new ArrayList<PhysicalPlan>();
        if (transformPlans == null) {
            Pair<POProject, Byte>[] sortProjs = null;
            sortProjs = this.getSortCols(sort.getSortPlans());
            if (sortProjs == null) {
                PhysicalPlan ep = new PhysicalPlan();
                POProject prj = new POProject(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
                prj.setStar(true);
                prj.setOverloaded(false);
                prj.setResultType((byte)110);
                ep.add(prj);
                eps1.add(ep);
                flat1.add(false);
            } else {
                for (Pair<POProject, Byte> sortProj : sortProjs) {
                    POProject prj;
                    if (sortProj == null) {
                        int errCode = 2174;
                        String msg = "Internal exception. Could not create a sampler job";
                        throw new SparkCompilerException(msg, errCode, 4);
                    }
                    PhysicalPlan ep = new PhysicalPlan();
                    try {
                        prj = ((POProject)sortProj.first).clone();
                    }
                    catch (CloneNotSupportedException e) {
                        throw new AssertionError((Object)("Error cloning project caught exception" + e));
                    }
                    ep.add(prj);
                    eps1.add(ep);
                    flat1.add(false);
                }
            }
        } else {
            for (int i = 0; i < transformPlans.size(); ++i) {
                eps1.add(transformPlans.get(i));
                flat1.add(i == transformPlans.size() - 1);
            }
        }
        POForEach nfe1 = new POForEach(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)), -1, eps1, flat1);
        sampleOperator.physicalPlan.addAsLeaf(nfe1);
        POSampleSortSpark poSparkSampleSort = new POSampleSortSpark(sort);
        sampleOperator.physicalPlan.addAsLeaf(poSparkSampleSort);
        PhysicalPlan fe2Plan = new PhysicalPlan();
        POProject topPrj = new POProject(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
        topPrj.setColumn(1);
        topPrj.setResultType((byte)120);
        topPrj.setOverloaded(true);
        fe2Plan.add(topPrj);
        PhysicalPlan rpep = new PhysicalPlan();
        ConstantExpression rpce = new ConstantExpression(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
        rpce.setRequestedParallelism(rp);
        rpce.setValue(rp);
        rpce.setResultType((byte)10);
        rpep.add(rpce);
        ArrayList<PhysicalPlan> genEps = new ArrayList<PhysicalPlan>();
        genEps.add(rpep);
        genEps.add(fe2Plan);
        ArrayList<Boolean> flattened2 = new ArrayList<Boolean>();
        flattened2.add(false);
        flattened2.add(false);
        POForEach nfe2 = new POForEach(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)), -1, genEps, flattened2);
        sampleOperator.physicalPlan.addAsLeaf(nfe2);
        PhysicalPlan ep4 = new PhysicalPlan();
        POProject prjStar4 = new POProject(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
        prjStar4.setResultType((byte)110);
        prjStar4.setStar(true);
        ep4.add(prjStar4);
        ArrayList<PhysicalOperator> ufInps = new ArrayList<PhysicalOperator>();
        ufInps.add(prjStar4);
        POUserFunc uf = new POUserFunc(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)), -1, ufInps, new FuncSpec(udfClassName, udfArgs));
        ep4.add(uf);
        ep4.connect(prjStar4, uf);
        ArrayList<PhysicalPlan> ep4s = new ArrayList<PhysicalPlan>();
        ep4s.add(ep4);
        ArrayList<Boolean> flattened3 = new ArrayList<Boolean>();
        flattened3.add(false);
        POForEach nfe3 = new POForEach(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)), -1, ep4s, flattened3);
        sampleOperator.physicalPlan.addAsLeaf(nfe3);
        sampleOperator.requestedParallelism = 1;
        sampleOperator.markSampler();
        return sampleOperator;
    }

    private Pair<POProject, Byte>[] getSortCols(List<PhysicalPlan> plans) throws PlanException, ExecException {
        if (plans != null) {
            Pair[] ret = new Pair[plans.size()];
            int i = -1;
            for (PhysicalPlan plan : plans) {
                POProject proj;
                PhysicalOperator op = (PhysicalOperator)plan.getLeaves().get(0);
                if (op instanceof POProject) {
                    if (((POProject)op).isStar()) {
                        return null;
                    }
                    proj = (POProject)op;
                } else {
                    proj = null;
                }
                byte type = op.getResultType();
                ret[++i] = new Pair<POProject, Byte>(proj, type);
            }
            return ret;
        }
        int errCode = 2026;
        String msg = "No expression plan found in POSort.";
        throw new PlanException(msg, errCode, 4);
    }

    private void buildBroadcastForSkewedJoin(SparkOperator sampleSparkOp, String pigKeyDistFile) throws PlanException {
        POBroadcastSpark poBroadcast = new POBroadcastSpark(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
        poBroadcast.setBroadcastedVariableName(pigKeyDistFile);
        sampleSparkOp.physicalPlan.addAsLeaf(poBroadcast);
    }

    private SparkOperator getSkewedJoinSampleJob(POSkewedJoin skewedJoin) throws PlanException, VisitorException {
        try {
            SparkOperator sampleOperator = new SparkOperator(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
            sampleOperator.physicalPlan = this.compiledInputs[0].physicalPlan.clone();
            MultiMap<PhysicalOperator, PhysicalPlan> joinPlans = skewedJoin.getJoinPlans();
            List<POSkewedJoin> l = this.physicalPlan.getPredecessors(skewedJoin);
            List<PhysicalPlan> groups = joinPlans.get(l.get(0));
            ArrayList<Boolean> ascCol = new ArrayList<Boolean>();
            for (int i = 0; i < groups.size(); ++i) {
                ascCol.add(false);
            }
            POSort sort = new POSort(skewedJoin.getOperatorKey(), skewedJoin.getRequestedParallelism(), null, groups, ascCol, null);
            ArrayList<PhysicalPlan> transformPlans = new ArrayList<PhysicalPlan>();
            transformPlans.addAll(groups);
            POProject prjStar = new POProject(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
            prjStar.setResultType((byte)110);
            prjStar.setStar(true);
            ArrayList<PhysicalOperator> ufInps = new ArrayList<PhysicalOperator>();
            ufInps.add(prjStar);
            PhysicalPlan ep = new PhysicalPlan();
            POUserFunc uf = new POUserFunc(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)), -1, ufInps, new FuncSpec(GetMemNumRows.class.getName(), (String[])null));
            uf.setResultType((byte)110);
            ep.add(uf);
            ep.add(prjStar);
            ep.connect(prjStar, uf);
            transformPlans.add(ep);
            String per = this.pigContext.getProperties().getProperty("pig.skewedjoin.reduce.memusage", String.valueOf(0.3f));
            String mc = this.pigContext.getProperties().getProperty("pig.skewedjoin.reduce.maxtuple", "0");
            return this.getSamplingJob(sort, sampleOperator, transformPlans, skewedJoin.getRequestedParallelism(), PartitionSkewedKeys.class.getName(), new String[]{per, mc});
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + skewedJoin.getClass().getSimpleName();
            throw new SparkCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    private static class FindKeyTypeVisitor
    extends PhyPlanVisitor {
        byte keyType = 0;

        FindKeyTypeVisitor(PhysicalPlan plan) {
            super(plan, (PlanWalker<PhysicalOperator, PhysicalPlan>)new DepthFirstWalker<PhysicalOperator, PhysicalPlan>(plan));
        }

        @Override
        public void visitProject(POProject p) throws VisitorException {
            this.keyType = p.getResultType();
        }
    }
}

