/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.stats.fs;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.stats.StatsAggregator;
import org.apache.hadoop.hive.ql.stats.StatsCollectionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSStatsAggregator
implements StatsAggregator {
    private final Logger LOG = LoggerFactory.getLogger((String)this.getClass().getName());
    private List<Map<String, Map<String, String>>> statsList;
    private Map<String, Map<String, String>> statsMap;
    private FileSystem fs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean connect(StatsCollectionContext scc) {
        List<String> statsDirs = scc.getStatsTmpDirs();
        assert (statsDirs.size() == 1) : "Found multiple stats dirs: " + statsDirs;
        Path statsDir = new Path(statsDirs.get(0));
        Utilities.FILE_OP_LOGGER.trace("About to read stats from {}", (Object)statsDir);
        this.statsMap = new HashMap<String, Map<String, String>>();
        try {
            FileStatus[] status;
            this.fs = statsDir.getFileSystem(scc.getHiveConf());
            this.statsList = new ArrayList<Map<String, Map<String, String>>>();
            for (FileStatus file : status = this.fs.listStatus(statsDir, new PathFilter(){

                public boolean accept(Path file) {
                    return file.getName().startsWith("tmpstats-");
                }
            })) {
                Utilities.FILE_OP_LOGGER.trace("About to read stats file {} ", (Object)file.getPath());
                Input in = new Input((InputStream)this.fs.open(file.getPath()));
                Kryo kryo = SerializationUtilities.borrowKryo();
                try {
                    this.statsMap = (Map)kryo.readObject(in, this.statsMap.getClass());
                }
                finally {
                    SerializationUtilities.releaseKryo(kryo);
                }
                Utilities.FILE_OP_LOGGER.trace("Read : {}", this.statsMap);
                this.statsList.add(this.statsMap);
                in.close();
            }
            return true;
        }
        catch (IOException e) {
            Utilities.FILE_OP_LOGGER.error("Failed to read stats from filesystem ", (Throwable)e);
            return false;
        }
    }

    @Override
    public String aggregateStats(String partID, String statType) {
        long counter = 0L;
        Utilities.FILE_OP_LOGGER.debug("Part ID: " + partID + "\t" + statType);
        for (Map<String, Map<String, String>> statsMap : this.statsList) {
            String statVal;
            Map<String, String> partStat = statsMap.get(partID);
            if (null == partStat || null == (statVal = partStat.get(statType))) continue;
            counter += Long.parseLong(statVal);
        }
        Utilities.FILE_OP_LOGGER.info("Read stats for : " + partID + "\t" + statType + "\t" + counter);
        return String.valueOf(counter);
    }

    @Override
    public boolean closeConnection(StatsCollectionContext scc) {
        List<String> statsDirs = scc.getStatsTmpDirs();
        assert (statsDirs.size() == 1) : "Found multiple stats dirs: " + statsDirs;
        Path statsDir = new Path(statsDirs.get(0));
        this.LOG.debug("About to delete stats tmp dir :" + statsDir);
        try {
            this.fs.delete(statsDir, true);
            return true;
        }
        catch (IOException e) {
            this.LOG.error("Failed to delete stats dir", (Throwable)e);
            return true;
        }
    }
}

