/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import org.apache.hadoop.hive.metastore.api.WMResourcePlan;
import org.apache.hadoop.hive.ql.plan.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Create ResourcePlan", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class CreateResourcePlanDesc
extends DDLDesc
implements Serializable {
    private static final long serialVersionUID = -3492803425541479414L;
    private WMResourcePlan resourcePlan;
    private String copyFromName;

    public CreateResourcePlanDesc() {
    }

    public CreateResourcePlanDesc(String planName, Integer queryParallelism, String copyFromName) {
        this.resourcePlan = new WMResourcePlan(planName);
        if (queryParallelism != null) {
            this.resourcePlan.setQueryParallelism(queryParallelism.intValue());
        }
        this.copyFromName = copyFromName;
    }

    @Explain(displayName="resourcePlan", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public WMResourcePlan getResourcePlan() {
        return this.resourcePlan;
    }

    @Explain(displayName="Copy from", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getCopyFromName() {
        return this.copyFromName;
    }
}

