/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.stats;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.SemiJoin;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMdSelectivity;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Pair;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveConfPlannerContext;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.FilterSelectivityEstimator;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdDistinctRowCount;

public class HiveRelMdSelectivity
extends RelMdSelectivity {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((Method)BuiltInMethod.SELECTIVITY.method, (MetadataHandler)new HiveRelMdSelectivity());

    private HiveRelMdSelectivity() {
    }

    public Double getSelectivity(HiveTableScan t, RelMetadataQuery mq, RexNode predicate) {
        if (predicate != null) {
            FilterSelectivityEstimator filterSelEstmator = new FilterSelectivityEstimator(t, mq);
            return filterSelEstmator.estimateSelectivity(predicate);
        }
        return 1.0;
    }

    public Double getSelectivity(Join j, RelMetadataQuery mq, RexNode predicate) {
        if (j.getJoinType().equals((Object)JoinRelType.INNER)) {
            return this.computeInnerJoinSelectivity(j, mq, predicate);
        }
        if (j.getJoinType().equals((Object)JoinRelType.LEFT) || j.getJoinType().equals((Object)JoinRelType.RIGHT)) {
            double left = mq.getRowCount(j.getLeft());
            double right = mq.getRowCount(j.getRight());
            double product = left * right;
            double innerJoinSelectivity = this.computeInnerJoinSelectivity(j, mq, predicate);
            if (j.getJoinType().equals((Object)JoinRelType.LEFT)) {
                return Math.max(innerJoinSelectivity, left / product);
            }
            return Math.max(innerJoinSelectivity, right / product);
        }
        return 1.0;
    }

    private Double computeInnerJoinSelectivity(Join j, RelMetadataQuery mq, RexNode predicate) {
        HiveCalciteUtil.JoinPredicateInfo jpi;
        Pair<Boolean, RexNode> predInfo = this.getCombinedPredicateForJoin(j, predicate);
        if (!((Boolean)predInfo.getKey()).booleanValue()) {
            return new FilterSelectivityEstimator((RelNode)j, mq).estimateSelectivity((RexNode)predInfo.getValue());
        }
        RexNode combinedPredicate = (RexNode)predInfo.getValue();
        try {
            jpi = HiveCalciteUtil.JoinPredicateInfo.constructJoinPredicateInfo(j, combinedPredicate);
        }
        catch (CalciteSemanticException e) {
            throw new RuntimeException(e);
        }
        ImmutableMap.Builder colStatMapBuilder = ImmutableMap.builder();
        int rightOffSet = j.getLeft().getRowType().getFieldCount();
        for (Integer ljk : jpi.getProjsFromLeftPartOfJoinKeysInChildSchema()) {
            colStatMapBuilder.put((Object)ljk, (Object)HiveRelMdDistinctRowCount.getDistinctRowCount(j.getLeft(), mq, ljk));
        }
        for (Integer rjk : jpi.getProjsFromRightPartOfJoinKeysInChildSchema()) {
            colStatMapBuilder.put((Object)(rjk + rightOffSet), (Object)HiveRelMdDistinctRowCount.getDistinctRowCount(j.getRight(), mq, rjk));
        }
        ImmutableMap colStatMap = colStatMapBuilder.build();
        List<HiveCalciteUtil.JoinLeafPredicateInfo> peLst = jpi.getEquiJoinPredicateElements();
        int noOfPE = peLst.size();
        double ndvEstimate = 1.0;
        if (noOfPE > 0) {
            boolean isCorrelatedColumns = ((HiveConfPlannerContext)j.getCluster().getPlanner().getContext().unwrap(HiveConfPlannerContext.class)).getIsCorrelatedColumns();
            ndvEstimate = noOfPE > 1 && isCorrelatedColumns ? this.maxNdvForCorrelatedColumns(peLst, (ImmutableMap<Integer, Double>)colStatMap) : this.exponentialBackoff(peLst, (ImmutableMap<Integer, Double>)colStatMap);
            if (j instanceof SemiJoin) {
                ndvEstimate = Math.min(mq.getRowCount(j.getLeft()), ndvEstimate);
            } else if (j instanceof HiveJoin) {
                ndvEstimate = Math.min(mq.getRowCount(j.getLeft()) * mq.getRowCount(j.getRight()), ndvEstimate);
            } else {
                throw new RuntimeException("Unexpected Join type: " + j.getClass().getName());
            }
        }
        return 1.0 / ndvEstimate;
    }

    protected double logSmoothing(List<HiveCalciteUtil.JoinLeafPredicateInfo> peLst, ImmutableMap<Integer, Double> colStatMap) {
        int noOfPE = peLst.size();
        double ndvCrossProduct = HiveRelMdSelectivity.getMaxNDVForJoinSelectivity(peLst.get(0), colStatMap);
        if (noOfPE > 1) {
            double maxNDVSoFar = ndvCrossProduct;
            for (int i = 1; i < noOfPE; ++i) {
                double ndvToBeSmoothed;
                double tmpNDV = HiveRelMdSelectivity.getMaxNDVForJoinSelectivity(peLst.get(i), colStatMap);
                if (tmpNDV > maxNDVSoFar) {
                    ndvToBeSmoothed = maxNDVSoFar;
                    maxNDVSoFar = tmpNDV;
                    ndvCrossProduct = ndvCrossProduct / ndvToBeSmoothed * tmpNDV;
                } else {
                    ndvToBeSmoothed = tmpNDV;
                }
                if (ndvToBeSmoothed > 3.0) {
                    ndvCrossProduct *= Math.log(ndvToBeSmoothed);
                    continue;
                }
                ndvCrossProduct *= ndvToBeSmoothed;
            }
        }
        return ndvCrossProduct;
    }

    protected double maxNdvForCorrelatedColumns(List<HiveCalciteUtil.JoinLeafPredicateInfo> peLst, ImmutableMap<Integer, Double> colStatMap) {
        int noOfPE = peLst.size();
        ArrayList<Double> ndvs = new ArrayList<Double>(noOfPE);
        for (int i = 0; i < noOfPE; ++i) {
            ndvs.add(HiveRelMdSelectivity.getMaxNDVForJoinSelectivity(peLst.get(i), colStatMap));
        }
        return (Double)Collections.max(ndvs);
    }

    protected double exponentialBackoff(List<HiveCalciteUtil.JoinLeafPredicateInfo> peLst, ImmutableMap<Integer, Double> colStatMap) {
        int noOfPE = peLst.size();
        ArrayList<Double> ndvs = new ArrayList<Double>(noOfPE);
        for (int i = 0; i < noOfPE; ++i) {
            ndvs.add(HiveRelMdSelectivity.getMaxNDVForJoinSelectivity(peLst.get(i), colStatMap));
        }
        Collections.sort(ndvs);
        Collections.reverse(ndvs);
        double ndvCrossProduct = 1.0;
        for (int i = 0; i < ndvs.size(); ++i) {
            double n = Math.pow((Double)ndvs.get(i), Math.pow(0.5, i));
            ndvCrossProduct *= n;
        }
        return ndvCrossProduct;
    }

    private Pair<Boolean, RexNode> getCombinedPredicateForJoin(Join j, RexNode additionalPredicate) {
        RexNode minusPred = RelMdUtil.minusPreds((RexBuilder)j.getCluster().getRexBuilder(), (RexNode)additionalPredicate, (RexNode)j.getCondition());
        if (minusPred != null) {
            ArrayList<RexNode> minusList = new ArrayList<RexNode>();
            minusList.add(j.getCondition());
            minusList.add(minusPred);
            return new Pair((Object)false, (Object)minusPred);
        }
        return new Pair((Object)true, (Object)j.getCondition());
    }

    private static Double getMaxNDVForJoinSelectivity(HiveCalciteUtil.JoinLeafPredicateInfo jlpi, ImmutableMap<Integer, Double> colStatMap) {
        Double maxNDVSoFar = 1.0;
        maxNDVSoFar = HiveRelMdSelectivity.getMaxNDVFromProjections(colStatMap, jlpi.getProjsFromLeftPartOfJoinKeysInJoinSchema(), maxNDVSoFar);
        maxNDVSoFar = HiveRelMdSelectivity.getMaxNDVFromProjections(colStatMap, jlpi.getProjsFromRightPartOfJoinKeysInJoinSchema(), maxNDVSoFar);
        return maxNDVSoFar;
    }

    private static Double getMaxNDVFromProjections(Map<Integer, Double> colStatMap, Set<Integer> projectionSet, Double defaultMaxNDV) {
        Double colNDV = null;
        Double maxNDVSoFar = defaultMaxNDV;
        for (Integer projIndx : projectionSet) {
            colNDV = colStatMap.get(projIndx);
            if (!(colNDV > maxNDVSoFar)) continue;
            maxNDVSoFar = colNDV;
        }
        return maxNDVSoFar;
    }
}

