/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerGenerateResultOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinBytesHashMap;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.VectorDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorMapJoinInnerStringOperator
extends VectorMapJoinInnerGenerateResultOperator {
    private static final long serialVersionUID = 1L;
    private static final String CLASS_NAME = VectorMapJoinInnerStringOperator.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    private transient VectorMapJoinBytesHashMap hashMap;
    private transient int singleJoinColumn;

    @Override
    protected String getLoggingPrefix() {
        return super.getLoggingPrefix(CLASS_NAME);
    }

    protected VectorMapJoinInnerStringOperator() {
    }

    public VectorMapJoinInnerStringOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    public VectorMapJoinInnerStringOperator(CompilationOpContext ctx, OperatorDesc conf, VectorizationContext vContext, VectorDesc vectorDesc) throws HiveException {
        super(ctx, conf, vContext, vectorDesc);
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        try {
            VectorizedRowBatch batch = (VectorizedRowBatch)row;
            this.alias = (byte)tag;
            if (this.needCommonSetup) {
                this.commonSetup(batch);
                this.singleJoinColumn = this.bigTableKeyColumnMap[0];
                this.needCommonSetup = false;
            }
            if (this.needHashTableSetup) {
                this.hashMap = (VectorMapJoinBytesHashMap)this.vectorMapJoinHashTable;
                this.needHashTableSetup = false;
            }
            ++this.batchCounter;
            this.innerPerBatchSetup(batch);
            for (VectorExpression ve : this.bigTableFilterExpressions) {
                ve.evaluate(batch);
            }
            int inputLogicalSize = batch.size;
            if (inputLogicalSize == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(CLASS_NAME + " batch #" + this.batchCounter + " empty");
                }
                return;
            }
            if (this.bigTableKeyExpressions != null) {
                for (VectorExpression ve : this.bigTableKeyExpressions) {
                    ve.evaluate(batch);
                }
            }
            BytesColumnVector joinColVector = (BytesColumnVector)batch.cols[this.singleJoinColumn];
            byte[][] vector = joinColVector.vector;
            int[] start = joinColVector.start;
            int[] length = joinColVector.length;
            boolean allKeyInputColumnsRepeating = joinColVector.isRepeating;
            if (allKeyInputColumnsRepeating) {
                JoinUtil.JoinResult joinResult;
                if (!joinColVector.noNulls && joinColVector.isNull[0]) {
                    joinResult = JoinUtil.JoinResult.NOMATCH;
                } else {
                    byte[] keyBytes = vector[0];
                    int keyStart = start[0];
                    int keyLength = length[0];
                    joinResult = this.hashMap.lookup(keyBytes, keyStart, keyLength, this.hashMapResults[0]);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(CLASS_NAME + " batch #" + this.batchCounter + " repeated joinResult " + joinResult.name());
                }
                this.finishInnerRepeated(batch, joinResult, this.hashMapResults[0]);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(CLASS_NAME + " batch #" + this.batchCounter + " non-repeated");
                }
                int[] selected = batch.selected;
                boolean selectedInUse = batch.selectedInUse;
                int hashMapResultCount = 0;
                int allMatchCount = 0;
                int equalKeySeriesCount = 0;
                int spillCount = 0;
                int saveKeyBatchIndex = -1;
                boolean haveSaveKey = false;
                JoinUtil.JoinResult saveJoinResult = JoinUtil.JoinResult.NOMATCH;
                block21: for (int logical = 0; logical < inputLogicalSize; ++logical) {
                    boolean isNull;
                    int batchIndex = selectedInUse ? selected[logical] : logical;
                    boolean bl = isNull = !joinColVector.noNulls && joinColVector.isNull[batchIndex];
                    if (isNull || !haveSaveKey || !StringExpr.equal((byte[])vector[saveKeyBatchIndex], (int)start[saveKeyBatchIndex], (int)length[saveKeyBatchIndex], (byte[])vector[batchIndex], (int)start[batchIndex], (int)length[batchIndex])) {
                        if (haveSaveKey) {
                            switch (saveJoinResult) {
                                case MATCH: {
                                    ++hashMapResultCount;
                                    ++equalKeySeriesCount;
                                    break;
                                }
                                case SPILL: {
                                    ++hashMapResultCount;
                                    break;
                                }
                            }
                        }
                        if (isNull) {
                            saveJoinResult = JoinUtil.JoinResult.NOMATCH;
                            haveSaveKey = false;
                        } else {
                            haveSaveKey = true;
                            saveKeyBatchIndex = batchIndex;
                            byte[] keyBytes = vector[batchIndex];
                            int keyStart = start[batchIndex];
                            int keyLength = length[batchIndex];
                            saveJoinResult = this.hashMap.lookup(keyBytes, keyStart, keyLength, this.hashMapResults[hashMapResultCount]);
                        }
                        switch (saveJoinResult) {
                            case MATCH: {
                                this.equalKeySeriesHashMapResultIndices[equalKeySeriesCount] = hashMapResultCount;
                                this.equalKeySeriesAllMatchIndices[equalKeySeriesCount] = allMatchCount;
                                this.equalKeySeriesIsSingleValue[equalKeySeriesCount] = this.hashMapResults[hashMapResultCount].isSingleRow();
                                this.equalKeySeriesDuplicateCounts[equalKeySeriesCount] = 1;
                                this.allMatchs[allMatchCount++] = batchIndex;
                                break;
                            }
                            case SPILL: {
                                this.spills[spillCount] = batchIndex;
                                this.spillHashMapResultIndices[spillCount] = hashMapResultCount;
                                ++spillCount;
                                break;
                            }
                        }
                        continue;
                    }
                    switch (saveJoinResult) {
                        case MATCH: {
                            int n = equalKeySeriesCount;
                            this.equalKeySeriesDuplicateCounts[n] = this.equalKeySeriesDuplicateCounts[n] + 1;
                            this.allMatchs[allMatchCount++] = batchIndex;
                            continue block21;
                        }
                        case SPILL: {
                            this.spills[spillCount] = batchIndex;
                            this.spillHashMapResultIndices[spillCount] = hashMapResultCount;
                            ++spillCount;
                            continue block21;
                        }
                    }
                }
                if (haveSaveKey) {
                    switch (saveJoinResult) {
                        case MATCH: {
                            ++hashMapResultCount;
                            ++equalKeySeriesCount;
                            break;
                        }
                        case SPILL: {
                            ++hashMapResultCount;
                            break;
                        }
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(CLASS_NAME + " allMatchs " + VectorMapJoinInnerStringOperator.intArrayToRangesString(this.allMatchs, allMatchCount) + " equalKeySeriesHashMapResultIndices " + VectorMapJoinInnerStringOperator.intArrayToRangesString(this.equalKeySeriesHashMapResultIndices, equalKeySeriesCount) + " equalKeySeriesAllMatchIndices " + VectorMapJoinInnerStringOperator.intArrayToRangesString(this.equalKeySeriesAllMatchIndices, equalKeySeriesCount) + " equalKeySeriesIsSingleValue " + Arrays.toString(Arrays.copyOfRange(this.equalKeySeriesIsSingleValue, 0, equalKeySeriesCount)) + " equalKeySeriesDuplicateCounts " + Arrays.toString(Arrays.copyOfRange(this.equalKeySeriesDuplicateCounts, 0, equalKeySeriesCount)) + " spills " + VectorMapJoinInnerStringOperator.intArrayToRangesString(this.spills, spillCount) + " spillHashMapResultIndices " + VectorMapJoinInnerStringOperator.intArrayToRangesString(this.spillHashMapResultIndices, spillCount) + " hashMapResults " + Arrays.toString(Arrays.copyOfRange(this.hashMapResults, 0, hashMapResultCount)));
                }
                this.finishInner(batch, allMatchCount, equalKeySeriesCount, spillCount, hashMapResultCount);
            }
            if (batch.size > 0) {
                this.forwardBigTableBatch(batch);
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }
}

