/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class StringGroupColNotEqualStringGroupColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final int colNum1;
    private final int colNum2;

    public StringGroupColNotEqualStringGroupColumn(int colNum1, int colNum2, int outputColumnNum) {
        super(outputColumnNum);
        this.colNum1 = colNum1;
        this.colNum2 = colNum2;
    }

    public StringGroupColNotEqualStringGroupColumn() {
        this.colNum1 = -1;
        this.colNum2 = -1;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        block73: {
            int[] length2;
            int[] length1;
            int[] start2;
            int[] start1;
            byte[][] vector2;
            byte[][] vector1;
            boolean[] outputIsNull;
            boolean[] nullPos2;
            boolean[] nullPos1;
            int[] sel;
            BytesColumnVector inputColVector2;
            BytesColumnVector inputColVector1;
            int n;
            block78: {
                block76: {
                    block77: {
                        block74: {
                            block75: {
                                block72: {
                                    n = batch.size;
                                    if (n == 0) {
                                        return;
                                    }
                                    if (this.childExpressions != null) {
                                        super.evaluateChildren(batch);
                                    }
                                    inputColVector1 = (BytesColumnVector)batch.cols[this.colNum1];
                                    inputColVector2 = (BytesColumnVector)batch.cols[this.colNum2];
                                    LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumnNum];
                                    sel = batch.selected;
                                    nullPos1 = inputColVector1.isNull;
                                    nullPos2 = inputColVector2.isNull;
                                    outputIsNull = outputColVector.isNull;
                                    vector1 = inputColVector1.vector;
                                    vector2 = inputColVector2.vector;
                                    start1 = inputColVector1.start;
                                    start2 = inputColVector2.start;
                                    length1 = inputColVector1.length;
                                    length2 = inputColVector2.length;
                                    long[] outVector = outputColVector.vector;
                                    outputColVector.isRepeating = false;
                                    if (!inputColVector1.noNulls || !inputColVector2.noNulls) break block72;
                                    if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
                                        boolean ret;
                                        outputColVector.isRepeating = true;
                                        outputIsNull[0] = false;
                                        boolean bl = ret = !StringExpr.equal((byte[])vector1[0], (int)start1[0], (int)length1[0], (byte[])vector2[0], (int)start2[0], (int)length2[0]);
                                        outVector[0] = ret ? 1L : 0L;
                                    } else if (inputColVector1.isRepeating) {
                                        if (batch.selectedInUse) {
                                            for (int j = 0; j != n; ++j) {
                                                int i = sel[j];
                                                outputIsNull[i] = false;
                                                outVector[i] = !StringExpr.equal((byte[])vector1[0], (int)start1[0], (int)length1[0], (byte[])vector2[i], (int)start2[i], (int)length2[i]) ? 1L : 0L;
                                            }
                                        } else {
                                            Arrays.fill(outputIsNull, 0, n, false);
                                            for (int i = 0; i != n; ++i) {
                                                outVector[i] = !StringExpr.equal((byte[])vector1[0], (int)start1[0], (int)length1[0], (byte[])vector2[i], (int)start2[i], (int)length2[i]) ? 1L : 0L;
                                            }
                                        }
                                    } else if (inputColVector2.isRepeating) {
                                        if (batch.selectedInUse) {
                                            for (int j = 0; j != n; ++j) {
                                                int i = sel[j];
                                                outputIsNull[i] = false;
                                                outVector[i] = !StringExpr.equal((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[0], (int)start2[0], (int)length2[0]) ? 1L : 0L;
                                            }
                                        } else {
                                            Arrays.fill(outputIsNull, 0, n, false);
                                            for (int i = 0; i != n; ++i) {
                                                outVector[i] = !StringExpr.equal((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[0], (int)start2[0], (int)length2[0]) ? 1L : 0L;
                                            }
                                        }
                                    } else if (batch.selectedInUse) {
                                        for (int j = 0; j != n; ++j) {
                                            int i = sel[j];
                                            outputIsNull[i] = false;
                                            outVector[i] = !StringExpr.equal((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[i], (int)start2[i], (int)length2[i]) ? 1L : 0L;
                                        }
                                    } else {
                                        Arrays.fill(outputIsNull, 0, n, false);
                                        for (int i = 0; i != n; ++i) {
                                            outVector[i] = !StringExpr.equal((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[i], (int)start2[i], (int)length2[i]) ? 1L : 0L;
                                        }
                                    }
                                    break block73;
                                }
                                if (!inputColVector1.noNulls) break block74;
                                outputColVector.noNulls = false;
                                if (!inputColVector1.isRepeating || !inputColVector2.isRepeating) break block75;
                                outputColVector.isRepeating = true;
                                outputIsNull[0] = nullPos2[0];
                                if (nullPos2[0]) break block73;
                                outVector[0] = !StringExpr.equal((byte[])vector1[0], (int)start1[0], (int)length1[0], (byte[])vector2[0], (int)start2[0], (int)length2[0]) ? 1L : 0L;
                                break block73;
                            }
                            if (inputColVector1.isRepeating) {
                                if (batch.selectedInUse) {
                                    for (int j = 0; j != n; ++j) {
                                        int i = sel[j];
                                        outputIsNull[i] = nullPos2[i];
                                        if (nullPos2[i]) continue;
                                        outVector[i] = !StringExpr.equal((byte[])vector1[0], (int)start1[0], (int)length1[0], (byte[])vector2[i], (int)start2[i], (int)length2[i]) ? 1L : 0L;
                                    }
                                } else {
                                    for (int i = 0; i != n; ++i) {
                                        outputIsNull[i] = nullPos2[i];
                                        if (nullPos2[i]) continue;
                                        outVector[i] = !StringExpr.equal((byte[])vector1[0], (int)start1[0], (int)length1[0], (byte[])vector2[i], (int)start2[i], (int)length2[i]) ? 1L : 0L;
                                    }
                                }
                            } else if (inputColVector2.isRepeating) {
                                if (nullPos2[0]) {
                                    outputColVector.isRepeating = true;
                                    outputIsNull[0] = true;
                                    return;
                                }
                                if (batch.selectedInUse) {
                                    for (int j = 0; j != n; ++j) {
                                        int i = sel[j];
                                        outputIsNull[i] = false;
                                        outVector[i] = !StringExpr.equal((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[0], (int)start2[0], (int)length2[0]) ? 1L : 0L;
                                    }
                                } else {
                                    for (int i = 0; i != n; ++i) {
                                        outputIsNull[i] = false;
                                        outVector[i] = !StringExpr.equal((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[0], (int)start2[0], (int)length2[0]) ? 1L : 0L;
                                    }
                                }
                            } else if (batch.selectedInUse) {
                                for (int j = 0; j != n; ++j) {
                                    int i = sel[j];
                                    outputIsNull[i] = nullPos2[i];
                                    if (nullPos2[i]) continue;
                                    outVector[i] = !StringExpr.equal((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[i], (int)start2[i], (int)length2[i]) ? 1L : 0L;
                                }
                            } else {
                                for (int i = 0; i != n; ++i) {
                                    outputIsNull[i] = nullPos2[i];
                                    if (nullPos2[i]) continue;
                                    outVector[i] = !StringExpr.equal((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[i], (int)start2[i], (int)length2[i]) ? 1L : 0L;
                                }
                            }
                            break block73;
                        }
                        if (!inputColVector2.noNulls) break block76;
                        outputColVector.noNulls = false;
                        if (!inputColVector1.isRepeating || !inputColVector2.isRepeating) break block77;
                        outputColVector.isRepeating = true;
                        outputIsNull[0] = nullPos1[0];
                        if (nullPos1[0]) break block73;
                        outVector[0] = !StringExpr.equal((byte[])vector1[0], (int)start1[0], (int)length1[0], (byte[])vector2[0], (int)start2[0], (int)length2[0]) ? 1L : 0L;
                        break block73;
                    }
                    if (inputColVector1.isRepeating) {
                        if (nullPos1[0]) {
                            outputColVector.isRepeating = true;
                            outputIsNull[0] = true;
                            return;
                        }
                        if (batch.selectedInUse) {
                            for (int j = 0; j != n; ++j) {
                                int i = sel[j];
                                outputIsNull[i] = false;
                                outVector[i] = !StringExpr.equal((byte[])vector1[0], (int)start1[0], (int)length1[0], (byte[])vector2[i], (int)start2[i], (int)length2[i]) ? 1L : 0L;
                            }
                        } else {
                            for (int i = 0; i != n; ++i) {
                                outputIsNull[i] = false;
                                outVector[i] = !StringExpr.equal((byte[])vector1[0], (int)start1[0], (int)length1[0], (byte[])vector2[i], (int)start2[i], (int)length2[i]) ? 1L : 0L;
                            }
                        }
                    } else if (inputColVector2.isRepeating) {
                        if (batch.selectedInUse) {
                            for (int j = 0; j != n; ++j) {
                                int i = sel[j];
                                outputIsNull[i] = nullPos1[i];
                                if (nullPos1[i]) continue;
                                outVector[i] = !StringExpr.equal((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[0], (int)start2[0], (int)length2[0]) ? 1L : 0L;
                            }
                        } else {
                            for (int i = 0; i != n; ++i) {
                                outputIsNull[i] = nullPos1[i];
                                if (nullPos1[i]) continue;
                                outVector[i] = !StringExpr.equal((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[0], (int)start2[0], (int)length2[0]) ? 1L : 0L;
                            }
                        }
                    } else if (batch.selectedInUse) {
                        for (int j = 0; j != n; ++j) {
                            int i = sel[j];
                            outputIsNull[i] = nullPos1[i];
                            if (nullPos1[i]) continue;
                            outVector[i] = !StringExpr.equal((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[i], (int)start2[i], (int)length2[i]) ? 1L : 0L;
                        }
                    } else {
                        for (int i = 0; i != n; ++i) {
                            outputIsNull[i] = nullPos1[i];
                            if (nullPos1[i]) continue;
                            outVector[i] = !StringExpr.equal((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[i], (int)start2[i], (int)length2[i]) ? 1L : 0L;
                        }
                    }
                    break block73;
                }
                outputColVector.noNulls = false;
                if (!inputColVector1.isRepeating || !inputColVector2.isRepeating) break block78;
                outputColVector.isRepeating = true;
                boolean bl = outputIsNull[0] = nullPos1[0] || nullPos2[0];
                if (outputIsNull[0]) break block73;
                outVector[0] = !StringExpr.equal((byte[])vector1[0], (int)start1[0], (int)length1[0], (byte[])vector2[0], (int)start2[0], (int)length2[0]) ? 1L : 0L;
                break block73;
            }
            if (inputColVector1.isRepeating) {
                if (nullPos1[0]) {
                    outputColVector.isRepeating = true;
                    outputIsNull[0] = true;
                    return;
                }
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = nullPos2[i];
                        if (nullPos2[i]) continue;
                        outVector[i] = !StringExpr.equal((byte[])vector1[0], (int)start1[0], (int)length1[0], (byte[])vector2[i], (int)start2[i], (int)length2[i]) ? 1L : 0L;
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        outputIsNull[i] = nullPos2[i];
                        if (nullPos2[i]) continue;
                        outVector[i] = !StringExpr.equal((byte[])vector1[0], (int)start1[0], (int)length1[0], (byte[])vector2[i], (int)start2[i], (int)length2[i]) ? 1L : 0L;
                    }
                }
            } else if (inputColVector2.isRepeating) {
                if (nullPos2[0]) {
                    outputColVector.isRepeating = true;
                    outputIsNull[0] = true;
                    return;
                }
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = nullPos1[i];
                        if (nullPos1[i]) continue;
                        outVector[i] = !StringExpr.equal((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[0], (int)start2[0], (int)length2[0]) ? 1L : 0L;
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        outputIsNull[i] = nullPos1[i];
                        if (nullPos1[i]) continue;
                        outVector[i] = !StringExpr.equal((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[0], (int)start2[0], (int)length2[0]) ? 1L : 0L;
                    }
                }
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    boolean bl = outputIsNull[i] = nullPos1[i] || nullPos2[i];
                    if (outputIsNull[i]) continue;
                    outVector[i] = !StringExpr.equal((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[i], (int)start2[i], (int)length2[i]) ? 1L : 0L;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    boolean bl = outputIsNull[i] = nullPos1[i] || nullPos2[i];
                    if (outputIsNull[i]) continue;
                    outVector[i] = !StringExpr.equal((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[i], (int)start2[i], (int)length2[i]) ? 1L : 0L;
                }
            }
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.colNum1) + ", " + this.getColumnParamString(1, this.colNum2);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.STRING_FAMILY, VectorExpressionDescriptor.ArgumentType.STRING_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

