/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.io.Serializable;
import org.apache.hadoop.hive.common.type.DataTypePhysicalVariation;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorAggregateExpression;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFVariance;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class VectorAggregationDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final AggregationDesc aggrDesc;
    private final TypeInfo inputTypeInfo;
    private final ColumnVector.Type inputColVectorType;
    private final VectorExpression inputExpression;
    private final TypeInfo outputTypeInfo;
    private final ColumnVector.Type outputColVectorType;
    private final DataTypePhysicalVariation outputDataTypePhysicalVariation;
    private final Class<? extends VectorAggregateExpression> vecAggrClass;
    private GenericUDAFEvaluator evaluator;

    public VectorAggregationDesc(AggregationDesc aggrDesc, GenericUDAFEvaluator evaluator, TypeInfo inputTypeInfo, ColumnVector.Type inputColVectorType, VectorExpression inputExpression, TypeInfo outputTypeInfo, ColumnVector.Type outputColVectorType, Class<? extends VectorAggregateExpression> vecAggrClass) {
        this.aggrDesc = aggrDesc;
        this.evaluator = evaluator;
        this.inputTypeInfo = inputTypeInfo;
        this.inputColVectorType = inputColVectorType;
        this.inputExpression = inputExpression;
        this.outputTypeInfo = outputTypeInfo;
        this.outputColVectorType = outputColVectorType;
        this.outputDataTypePhysicalVariation = outputColVectorType == ColumnVector.Type.DECIMAL_64 ? DataTypePhysicalVariation.DECIMAL_64 : DataTypePhysicalVariation.NONE;
        this.vecAggrClass = vecAggrClass;
    }

    public AggregationDesc getAggrDesc() {
        return this.aggrDesc;
    }

    public TypeInfo getInputTypeInfo() {
        return this.inputTypeInfo;
    }

    public ColumnVector.Type getInputColVectorType() {
        return this.inputColVectorType;
    }

    public VectorExpression getInputExpression() {
        return this.inputExpression;
    }

    public TypeInfo getOutputTypeInfo() {
        return this.outputTypeInfo;
    }

    public ColumnVector.Type getOutputColVectorType() {
        return this.outputColVectorType;
    }

    public DataTypePhysicalVariation getOutputDataTypePhysicalVariation() {
        return this.outputDataTypePhysicalVariation;
    }

    public GenericUDAFEvaluator getEvaluator() {
        return this.evaluator;
    }

    public Class<? extends VectorAggregateExpression> getVecAggrClass() {
        return this.vecAggrClass;
    }

    public String toString() {
        String aggregationName;
        StringBuilder sb = new StringBuilder();
        sb.append(this.vecAggrClass.getSimpleName());
        if (this.inputExpression != null) {
            sb.append("(");
            sb.append(this.inputExpression.toString());
            sb.append(") -> ");
        } else {
            sb.append("(*) -> ");
        }
        sb.append(this.outputTypeInfo.toString());
        if (this.outputDataTypePhysicalVariation != null && this.outputDataTypePhysicalVariation != DataTypePhysicalVariation.NONE) {
            sb.append("/");
            sb.append(this.outputDataTypePhysicalVariation);
        }
        if (GenericUDAFVariance.isVarianceFamilyName(aggregationName = this.aggrDesc.getGenericUDAFName())) {
            sb.append(" aggregation: ");
            sb.append(aggregationName);
        }
        return sb.toString();
    }
}

