/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark.status.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hive.spark.client.metrics.Metrics;
import org.apache.hive.spark.client.metrics.ShuffleReadMetrics;

final class SparkMetricsUtils {
    private SparkMetricsUtils() {
    }

    static Map<String, Long> collectMetrics(Metrics allMetrics) {
        LinkedHashMap<String, Long> results = new LinkedHashMap<String, Long>();
        results.put("ExecutorDeserializeTime", allMetrics.executorDeserializeTime);
        results.put("ExecutorDeserializeCpuTime", allMetrics.executorDeserializeCpuTime);
        results.put("ExecutorRunTime", allMetrics.executorRunTime);
        results.put("ExecutorCpuTime", allMetrics.executorCpuTime);
        results.put("ResultSize", allMetrics.resultSize);
        results.put("JvmGCTime", allMetrics.jvmGCTime);
        results.put("ResultSerializationTime", allMetrics.resultSerializationTime);
        results.put("MemoryBytesSpilled", allMetrics.memoryBytesSpilled);
        results.put("DiskBytesSpilled", allMetrics.diskBytesSpilled);
        results.put("TaskDurationTime", allMetrics.taskDurationTime);
        if (allMetrics.inputMetrics != null) {
            results.put("BytesRead", allMetrics.inputMetrics.bytesRead);
        }
        if (allMetrics.shuffleReadMetrics != null) {
            ShuffleReadMetrics shuffleReadMetrics = allMetrics.shuffleReadMetrics;
            long rbf = shuffleReadMetrics.remoteBlocksFetched;
            long lbf = shuffleReadMetrics.localBlocksFetched;
            results.put("RemoteBlocksFetched", rbf);
            results.put("LocalBlocksFetched", lbf);
            results.put("TotalBlocksFetched", rbf + lbf);
            results.put("FetchWaitTime", shuffleReadMetrics.fetchWaitTime);
            results.put("RemoteBytesRead", shuffleReadMetrics.remoteBytesRead);
        }
        if (allMetrics.shuffleWriteMetrics != null) {
            results.put("ShuffleBytesWritten", allMetrics.shuffleWriteMetrics.shuffleBytesWritten);
            results.put("ShuffleWriteTime", allMetrics.shuffleWriteMetrics.shuffleWriteTime);
        }
        return results;
    }
}

