/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.http.async.netty;

import io.netty.handler.codec.http.HttpHeaders;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class TezBodyDeferringAsyncHandler
implements AsyncHandler<Response> {
    private static final Logger LOG = LoggerFactory.getLogger(TezBodyDeferringAsyncHandler.class);
    private final Response.ResponseBuilder responseBuilder = new Response.ResponseBuilder();
    private final CountDownLatch headersArrived = new CountDownLatch(1);
    private final OutputStream output;
    private volatile boolean responseSet;
    private volatile boolean statusReceived;
    private volatile Response response;
    private volatile Throwable throwable;
    private final Semaphore semaphore = new Semaphore(1);
    private final URL url;
    private final int headerReceiveTimeout;

    TezBodyDeferringAsyncHandler(OutputStream os, URL url, int timeout) {
        this.output = os;
        this.responseSet = false;
        this.url = url;
        this.headerReceiveTimeout = timeout;
    }

    public void onThrowable(Throwable t) {
        this.throwable = t;
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            LOG.error("Error in asyncHandler ", t);
            this.headersArrived.countDown();
            this.semaphore.release();
        }
        try {
            this.closeOut();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public AsyncHandler.State onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
        this.responseBuilder.reset();
        this.responseBuilder.accumulate(responseStatus);
        this.statusReceived = true;
        return AsyncHandler.State.CONTINUE;
    }

    public AsyncHandler.State onHeadersReceived(HttpHeaders headers) throws Exception {
        this.responseBuilder.accumulate(headers);
        return AsyncHandler.State.CONTINUE;
    }

    public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
        if (!this.responseSet) {
            this.response = this.responseBuilder.build();
            this.responseSet = true;
            this.headersArrived.countDown();
        }
        this.output.write(bodyPart.getBodyPartBytes());
        return AsyncHandler.State.CONTINUE;
    }

    protected void closeOut() throws IOException {
        try {
            this.output.flush();
        }
        finally {
            this.output.close();
        }
    }

    public Response onCompleted() throws IOException {
        if (!this.responseSet) {
            this.response = this.responseBuilder.build();
            this.responseSet = true;
        }
        this.headersArrived.countDown();
        this.closeOut();
        try {
            this.semaphore.acquire();
            if (this.throwable != null) {
                IOException ioe = new IOException(this.throwable.getMessage());
                ioe.initCause(this.throwable);
                throw ioe;
            }
            Response ioe = this.responseBuilder.build();
            return ioe;
        }
        catch (InterruptedException e) {
            Response response = null;
            return response;
        }
        finally {
            this.semaphore.release();
        }
    }

    public Response getResponse() throws InterruptedException, IOException {
        boolean result = this.headersArrived.await(this.headerReceiveTimeout, TimeUnit.MILLISECONDS);
        if (!result) {
            LOG.error("Breaking after timeout={}, url={}, responseSet={} statusReceived={}", new Object[]{this.headerReceiveTimeout, this.url, this.responseSet, this.statusReceived});
            return null;
        }
        try {
            this.semaphore.acquire();
            if (this.throwable != null) {
                IOException ioe = new IOException(this.throwable.getMessage());
                ioe.initCause(this.throwable);
                throw ioe;
            }
            Response response = this.response;
            return response;
        }
        finally {
            this.semaphore.release();
        }
    }

    static class BodyDeferringInputStream
    extends FilterInputStream {
        private final Future<Response> future;
        private final TezBodyDeferringAsyncHandler bdah;

        public BodyDeferringInputStream(Future<Response> future, TezBodyDeferringAsyncHandler bdah, InputStream in) {
            super(in);
            this.future = future;
            this.bdah = bdah;
        }

        @Override
        public void close() throws IOException {
            super.close();
            try {
                this.getLastResponse();
            }
            catch (Exception e) {
                IOException ioe = new IOException(e.getMessage());
                ioe.initCause(e);
                throw ioe;
            }
        }

        public Response getAsapResponse() throws InterruptedException, IOException {
            return this.bdah.getResponse();
        }

        public Response getLastResponse() throws InterruptedException, ExecutionException {
            return this.future.get();
        }
    }
}

