/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.fate.zookeeper;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.fate.zookeeper.ZooCacheFactory;
import org.apache.accumulo.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooLock
implements Watcher {
    private static final Logger log = LoggerFactory.getLogger(ZooLock.class);
    public static final String LOCK_PREFIX = "zlock-";
    private boolean lockWasAcquired;
    private final String path;
    protected final IZooReaderWriter zooKeeper;
    private String lock;
    private LockWatcher lockWatcher;
    private boolean watchingParent = false;
    private String asyncLock;
    private static ZooCache getLockDataZooCache;

    public ZooLock(String zookeepers, int timeInMillis, String scheme, byte[] auth, String path) {
        this(new ZooCacheFactory().getZooCache(zookeepers, timeInMillis), ZooReaderWriter.getInstance(zookeepers, timeInMillis, scheme, auth), path);
    }

    protected ZooLock(ZooCache zc, IZooReaderWriter zrw, String path) {
        getLockDataZooCache = zc;
        this.path = path;
        this.zooKeeper = zrw;
        try {
            this.zooKeeper.getStatus(path, this);
            this.watchingParent = true;
        }
        catch (Exception ex) {
            log.warn("Error getting setting initial watch on ZooLock", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public synchronized boolean tryLock(LockWatcher lw, byte[] data) throws KeeperException, InterruptedException {
        TryLockAsyncLockWatcher tlalw = new TryLockAsyncLockWatcher(lw);
        this.lockAsync(tlalw, data);
        if (tlalw.acquiredLock) {
            return true;
        }
        if (this.asyncLock != null) {
            this.zooKeeper.recursiveDelete(this.path + "/" + this.asyncLock, ZooUtil.NodeMissingPolicy.SKIP);
            this.asyncLock = null;
        }
        return false;
    }

    private synchronized void lockAsync(final String myLock, final AsyncLockWatcher lw) throws KeeperException, InterruptedException {
        if (this.asyncLock == null) {
            throw new IllegalStateException("Called lockAsync() when asyncLock == null");
        }
        List<String> children = this.zooKeeper.getChildren(this.path);
        if (!children.contains(myLock)) {
            throw new RuntimeException("Lock attempt ephemeral node no longer exist " + myLock);
        }
        Collections.sort(children);
        if (log.isTraceEnabled()) {
            log.trace("Candidate lock nodes");
            for (String string : children) {
                log.trace("- " + string);
            }
        }
        if (children.get(0).equals(myLock)) {
            log.trace("First candidate is my lock, acquiring");
            if (!this.watchingParent) {
                throw new IllegalStateException("Can not acquire lock, no longer watching parent : " + this.path);
            }
            this.lockWatcher = lw;
            this.lock = myLock;
            this.asyncLock = null;
            this.lockWasAcquired = true;
            lw.acquiredLock();
            return;
        }
        String prev = null;
        for (String child : children) {
            if (child.equals(myLock)) break;
            prev = child;
        }
        final String string = this.path + "/" + prev;
        log.trace("Establishing watch on " + string);
        Stat stat = this.zooKeeper.getStatus(string, new Watcher(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void process(WatchedEvent event) {
                ZooLock zooLock;
                if (log.isTraceEnabled()) {
                    log.trace("Processing event:");
                    log.trace("- type  " + event.getType());
                    log.trace("- path  " + event.getPath());
                    log.trace("- state " + event.getState());
                }
                boolean renew = true;
                if (event.getType() == Watcher.Event.EventType.NodeDeleted && event.getPath().equals(string)) {
                    log.trace("Detected deletion of " + string + ", attempting to acquire lock");
                    zooLock = ZooLock.this;
                    synchronized (zooLock) {
                        block20: {
                            try {
                                if (ZooLock.this.asyncLock != null) {
                                    ZooLock.this.lockAsync(myLock, lw);
                                } else if (log.isTraceEnabled()) {
                                    log.trace("While waiting for another lock " + string + " " + myLock + " was deleted");
                                }
                            }
                            catch (Exception e) {
                                if (ZooLock.this.lock != null) break block20;
                                lw.failedToAcquireLock(e);
                            }
                        }
                    }
                    renew = false;
                }
                if (event.getState() == Watcher.Event.KeeperState.Expired || event.getState() == Watcher.Event.KeeperState.Disconnected) {
                    zooLock = ZooLock.this;
                    synchronized (zooLock) {
                        if (ZooLock.this.lock == null) {
                            lw.failedToAcquireLock(new Exception("Zookeeper Session expired / disconnected"));
                        }
                    }
                    renew = false;
                }
                if (renew) {
                    log.trace("Renewing watch on " + string);
                    try {
                        Stat restat = ZooLock.this.zooKeeper.getStatus(string, this);
                        if (restat == null) {
                            ZooLock.this.lockAsync(myLock, lw);
                        }
                    }
                    catch (KeeperException e) {
                        lw.failedToAcquireLock(new Exception("Failed to renew watch on other master node"));
                    }
                    catch (InterruptedException e) {
                        lw.failedToAcquireLock(new Exception("Failed to renew watch on other master node"));
                    }
                }
            }
        });
        if (stat == null) {
            this.lockAsync(myLock, lw);
        }
    }

    private void lostLock(LockLossReason reason) {
        LockWatcher localLw = this.lockWatcher;
        this.lock = null;
        this.lockWatcher = null;
        localLw.lostLock(reason);
    }

    public synchronized void lockAsync(final AsyncLockWatcher lw, byte[] data) {
        if (this.lockWatcher != null || this.lock != null || this.asyncLock != null) {
            throw new IllegalStateException();
        }
        this.lockWasAcquired = false;
        try {
            final String asyncLockPath = this.zooKeeper.putEphemeralSequential(this.path + "/" + LOCK_PREFIX, data);
            log.trace("Ephemeral node " + asyncLockPath + " created");
            Stat stat = this.zooKeeper.getStatus(asyncLockPath, new Watcher(){

                private void failedToAcquireLock() {
                    lw.failedToAcquireLock(new Exception("Lock deleted before acquired"));
                    ZooLock.this.asyncLock = null;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void process(WatchedEvent event) {
                    ZooLock zooLock = ZooLock.this;
                    synchronized (zooLock) {
                        if (ZooLock.this.lock != null && event.getType() == Watcher.Event.EventType.NodeDeleted && event.getPath().equals(ZooLock.this.path + "/" + ZooLock.this.lock)) {
                            ZooLock.this.lostLock(LockLossReason.LOCK_DELETED);
                        } else if (ZooLock.this.asyncLock != null && event.getType() == Watcher.Event.EventType.NodeDeleted && event.getPath().equals(ZooLock.this.path + "/" + ZooLock.this.asyncLock)) {
                            this.failedToAcquireLock();
                        } else if (event.getState() != Watcher.Event.KeeperState.Disconnected && event.getState() != Watcher.Event.KeeperState.Expired && (ZooLock.this.lock != null || ZooLock.this.asyncLock != null)) {
                            log.debug("Unexpected event watching lock node " + event + " " + asyncLockPath);
                            try {
                                Stat stat2 = ZooLock.this.zooKeeper.getStatus(asyncLockPath, this);
                                if (stat2 == null) {
                                    if (ZooLock.this.lock != null) {
                                        ZooLock.this.lostLock(LockLossReason.LOCK_DELETED);
                                    } else if (ZooLock.this.asyncLock != null) {
                                        this.failedToAcquireLock();
                                    }
                                }
                            }
                            catch (Throwable e) {
                                ZooLock.this.lockWatcher.unableToMonitorLockNode(e);
                                log.error("Failed to stat lock node " + asyncLockPath, e);
                            }
                        }
                    }
                }
            });
            if (stat == null) {
                lw.failedToAcquireLock(new Exception("Lock does not exist after create"));
                return;
            }
            this.asyncLock = asyncLockPath.substring(this.path.length() + 1);
            this.lockAsync(this.asyncLock, lw);
        }
        catch (KeeperException e) {
            lw.failedToAcquireLock((Exception)((Object)e));
        }
        catch (InterruptedException e) {
            lw.failedToAcquireLock(e);
        }
    }

    public synchronized boolean tryToCancelAsyncLockOrUnlock() throws InterruptedException, KeeperException {
        boolean del = false;
        if (this.asyncLock != null) {
            this.zooKeeper.recursiveDelete(this.path + "/" + this.asyncLock, ZooUtil.NodeMissingPolicy.SKIP);
            del = true;
        }
        if (this.lock != null) {
            this.unlock();
            del = true;
        }
        return del;
    }

    public synchronized void unlock() throws InterruptedException, KeeperException {
        if (this.lock == null) {
            throw new IllegalStateException();
        }
        LockWatcher localLw = this.lockWatcher;
        String localLock = this.lock;
        this.lock = null;
        this.lockWatcher = null;
        this.zooKeeper.recursiveDelete(this.path + "/" + localLock, ZooUtil.NodeMissingPolicy.SKIP);
        localLw.lostLock(LockLossReason.LOCK_DELETED);
    }

    public synchronized String getLockPath() {
        if (this.lock == null) {
            return null;
        }
        return this.path + "/" + this.lock;
    }

    public synchronized String getLockName() {
        return this.lock;
    }

    public synchronized ZooUtil.LockID getLockID() {
        if (this.lock == null) {
            throw new IllegalStateException("Lock not held");
        }
        return new ZooUtil.LockID(this.path, this.lock, this.zooKeeper.getZooKeeper().getSessionId());
    }

    public synchronized boolean wasLockAcquired() {
        return this.lockWasAcquired;
    }

    public synchronized boolean isLocked() {
        return this.lock != null;
    }

    public synchronized void replaceLockData(byte[] b) throws KeeperException, InterruptedException {
        if (this.getLockPath() != null) {
            this.zooKeeper.getZooKeeper().setData(this.getLockPath(), b, -1);
        }
    }

    public synchronized void process(WatchedEvent event) {
        block5: {
            log.debug("event " + event.getPath() + " " + event.getType() + " " + event.getState());
            this.watchingParent = false;
            if (event.getState() == Watcher.Event.KeeperState.Expired && this.lock != null) {
                this.lostLock(LockLossReason.SESSION_EXPIRED);
            } else {
                try {
                    this.zooKeeper.getStatus(this.path, this);
                    this.watchingParent = true;
                }
                catch (KeeperException.ConnectionLossException ex) {
                    log.warn("lost connection to zookeeper");
                }
                catch (Exception ex) {
                    if (this.lock == null && this.asyncLock == null) break block5;
                    this.lockWatcher.unableToMonitorLockNode(ex);
                    log.error("Error resetting watch on ZooLock " + (this.lock == null ? this.asyncLock : this.lock) + " " + event, (Throwable)ex);
                }
            }
        }
    }

    public static boolean isLockHeld(ZooCache zc, ZooUtil.LockID lid) {
        List<String> children = zc.getChildren(lid.path);
        if (children == null || children.size() == 0) {
            return false;
        }
        children = new ArrayList<String>(children);
        Collections.sort(children);
        String lockNode = children.get(0);
        if (!lid.node.equals(lockNode)) {
            return false;
        }
        ZooCache.ZcStat stat = new ZooCache.ZcStat();
        return zc.get(lid.path + "/" + lid.node, stat) != null && stat.getEphemeralOwner() == lid.eid;
    }

    public static byte[] getLockData(ZooKeeper zk, String path) throws KeeperException, InterruptedException {
        List children = zk.getChildren(path, false);
        if (children == null || children.size() == 0) {
            return null;
        }
        Collections.sort(children);
        String lockNode = (String)children.get(0);
        return zk.getData(path + "/" + lockNode, false, null);
    }

    public static byte[] getLockData(ZooCache zc, String path, ZooCache.ZcStat stat) {
        List<String> children = zc.getChildren(path);
        if (children == null || children.size() == 0) {
            return null;
        }
        children = new ArrayList<String>(children);
        Collections.sort(children);
        String lockNode = children.get(0);
        if (!lockNode.startsWith(LOCK_PREFIX)) {
            throw new RuntimeException("Node " + lockNode + " at " + path + " is not a lock node");
        }
        return zc.get(path + "/" + lockNode, stat);
    }

    public static long getSessionId(ZooCache zc, String path) throws KeeperException, InterruptedException {
        List<String> children = zc.getChildren(path);
        if (children == null || children.size() == 0) {
            return 0L;
        }
        children = new ArrayList<String>(children);
        Collections.sort(children);
        String lockNode = children.get(0);
        ZooCache.ZcStat stat = new ZooCache.ZcStat();
        if (zc.get(path + "/" + lockNode, stat) != null) {
            return stat.getEphemeralOwner();
        }
        return 0L;
    }

    public long getSessionId() throws KeeperException, InterruptedException {
        return ZooLock.getSessionId(getLockDataZooCache, this.path);
    }

    public static void deleteLock(IZooReaderWriter zk, String path) throws InterruptedException, KeeperException {
        List<String> children = zk.getChildren(path);
        if (children == null || children.size() == 0) {
            throw new IllegalStateException("No lock is held at " + path);
        }
        Collections.sort(children);
        String lockNode = children.get(0);
        if (!lockNode.startsWith(LOCK_PREFIX)) {
            throw new RuntimeException("Node " + lockNode + " at " + path + " is not a lock node");
        }
        zk.recursiveDelete(path + "/" + lockNode, ZooUtil.NodeMissingPolicy.SKIP);
    }

    public static boolean deleteLock(IZooReaderWriter zk, String path, String lockData) throws InterruptedException, KeeperException {
        List<String> children = zk.getChildren(path);
        if (children == null || children.size() == 0) {
            throw new IllegalStateException("No lock is held at " + path);
        }
        Collections.sort(children);
        String lockNode = children.get(0);
        if (!lockNode.startsWith(LOCK_PREFIX)) {
            throw new RuntimeException("Node " + lockNode + " at " + path + " is not a lock node");
        }
        byte[] data = zk.getData(path + "/" + lockNode, null);
        if (lockData.equals(new String(data, StandardCharsets.UTF_8))) {
            zk.recursiveDelete(path + "/" + lockNode, ZooUtil.NodeMissingPolicy.FAIL);
            return true;
        }
        return false;
    }

    private static class TryLockAsyncLockWatcher
    implements AsyncLockWatcher {
        boolean acquiredLock = false;
        LockWatcher lw;

        public TryLockAsyncLockWatcher(LockWatcher lw2) {
            this.lw = lw2;
        }

        @Override
        public void acquiredLock() {
            this.acquiredLock = true;
        }

        @Override
        public void failedToAcquireLock(Exception e) {
        }

        @Override
        public void lostLock(LockLossReason reason) {
            this.lw.lostLock(reason);
        }

        @Override
        public void unableToMonitorLockNode(Throwable e) {
            this.lw.unableToMonitorLockNode(e);
        }
    }

    public static interface AsyncLockWatcher
    extends LockWatcher {
        public void acquiredLock();

        public void failedToAcquireLock(Exception var1);
    }

    public static interface LockWatcher {
        public void lostLock(LockLossReason var1);

        public void unableToMonitorLockNode(Throwable var1);
    }

    public static enum LockLossReason {
        LOCK_DELETED,
        SESSION_EXPIRED;

    }
}

