/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.IsolatedScanner;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.BatchWriterImpl;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.Credentials;
import org.apache.accumulo.core.client.impl.ScannerImpl;
import org.apache.accumulo.core.client.impl.Writer;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.tabletserver.log.LogEntry;
import org.apache.accumulo.core.tabletserver.thrift.ConstraintViolationException;
import org.apache.accumulo.core.util.ColumnFQ;
import org.apache.accumulo.core.util.FastFormat;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.AccumuloServerContext;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.fs.FileRef;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.fs.VolumeManagerImpl;
import org.apache.accumulo.server.util.FileUtil;
import org.apache.accumulo.server.util.TabletIterator;
import org.apache.accumulo.server.zookeeper.ZooLock;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.zookeeper.KeeperException;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataTableUtil {
    private static final Text EMPTY_TEXT = new Text();
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static Map<Credentials, Writer> root_tables = new HashMap<Credentials, Writer>();
    private static Map<Credentials, Writer> metadata_tables = new HashMap<Credentials, Writer>();
    private static final Logger log = LoggerFactory.getLogger(MetadataTableUtil.class);

    private MetadataTableUtil() {
    }

    public static synchronized Writer getMetadataTable(ClientContext context) {
        Credentials credentials = context.getCredentials();
        Writer metadataTable = metadata_tables.get(credentials);
        if (metadataTable == null) {
            metadataTable = new Writer(context, "!0");
            metadata_tables.put(credentials, metadataTable);
        }
        return metadataTable;
    }

    public static synchronized Writer getRootTable(ClientContext context) {
        Credentials credentials = context.getCredentials();
        Writer rootTable = root_tables.get(credentials);
        if (rootTable == null) {
            rootTable = new Writer(context, "+r");
            root_tables.put(credentials, rootTable);
        }
        return rootTable;
    }

    public static void putLockID(ZooLock zooLock, Mutation m) {
        MetadataSchema.TabletsSection.ServerColumnFamily.LOCK_COLUMN.put(m, new Value(zooLock.getLockID().serialize(ZooUtil.getRoot((Instance)HdfsZooInstance.getInstance()) + "/").getBytes(StandardCharsets.UTF_8)));
    }

    private static void update(ClientContext context, Mutation m, KeyExtent extent) {
        MetadataTableUtil.update(context, null, m, extent);
    }

    public static void update(ClientContext context, ZooLock zooLock, Mutation m, KeyExtent extent) {
        Writer t = extent.isMeta() ? MetadataTableUtil.getRootTable(context) : MetadataTableUtil.getMetadataTable(context);
        MetadataTableUtil.update(t, zooLock, m);
    }

    public static void update(Writer t, ZooLock zooLock, Mutation m) {
        if (zooLock != null) {
            MetadataTableUtil.putLockID(zooLock, m);
        }
        while (true) {
            try {
                t.update(m);
                return;
            }
            catch (AccumuloException e) {
                log.error("{}", (Object)e.getMessage(), (Object)e);
            }
            catch (AccumuloSecurityException e) {
                log.error("{}", (Object)e.getMessage(), (Object)e);
            }
            catch (ConstraintViolationException e) {
                log.error("{}", (Object)e.getMessage(), (Object)e);
                throw new RuntimeException(e);
            }
            catch (TableNotFoundException e) {
                log.error("{}", (Object)e.getMessage(), (Object)e);
            }
            UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    public static void updateTabletFlushID(KeyExtent extent, long flushID, ClientContext context, ZooLock zooLock) {
        if (!extent.isRootTablet()) {
            Mutation m = new Mutation(extent.getMetadataEntry());
            MetadataSchema.TabletsSection.ServerColumnFamily.FLUSH_COLUMN.put(m, new Value((flushID + "").getBytes(StandardCharsets.UTF_8)));
            MetadataTableUtil.update(context, zooLock, m, extent);
        }
    }

    public static void updateTabletCompactID(KeyExtent extent, long compactID, ClientContext context, ZooLock zooLock) {
        if (!extent.isRootTablet()) {
            Mutation m = new Mutation(extent.getMetadataEntry());
            MetadataSchema.TabletsSection.ServerColumnFamily.COMPACT_COLUMN.put(m, new Value((compactID + "").getBytes(StandardCharsets.UTF_8)));
            MetadataTableUtil.update(context, zooLock, m, extent);
        }
    }

    public static void updateTabletDataFile(long tid, KeyExtent extent, Map<FileRef, DataFileValue> estSizes, String time, ClientContext context, ZooLock zooLock) {
        Mutation m = new Mutation(extent.getMetadataEntry());
        byte[] tidBytes = Long.toString(tid).getBytes(StandardCharsets.UTF_8);
        for (Map.Entry<FileRef, DataFileValue> entry : estSizes.entrySet()) {
            Text file = entry.getKey().meta();
            m.put(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, file, new Value(entry.getValue().encode()));
            m.put(MetadataSchema.TabletsSection.BulkFileColumnFamily.NAME, file, new Value(tidBytes));
        }
        MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.put(m, new Value(time.getBytes(StandardCharsets.UTF_8)));
        MetadataTableUtil.update(context, zooLock, m, extent);
    }

    public static void updateTabletDir(KeyExtent extent, String newDir, ClientContext context, ZooLock lock) {
        Mutation m = new Mutation(extent.getMetadataEntry());
        MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.put(m, new Value(newDir.getBytes(StandardCharsets.UTF_8)));
        MetadataTableUtil.update(context, lock, m, extent);
    }

    public static void addTablet(KeyExtent extent, String path, ClientContext context, char timeType, ZooLock lock) {
        Mutation m = extent.getPrevRowUpdateMutation();
        MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.put(m, new Value(path.getBytes(StandardCharsets.UTF_8)));
        MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.put(m, new Value((timeType + "0").getBytes(StandardCharsets.UTF_8)));
        MetadataTableUtil.update(context, lock, m, extent);
    }

    public static void updateTabletVolumes(KeyExtent extent, List<LogEntry> logsToRemove, List<LogEntry> logsToAdd, List<FileRef> filesToRemove, SortedMap<FileRef, DataFileValue> filesToAdd, String newDir, ZooLock zooLock, AccumuloServerContext context) {
        if (extent.isRootTablet()) {
            if (newDir != null) {
                throw new IllegalArgumentException("newDir not expected for " + extent);
            }
            if (filesToRemove.size() != 0 || filesToAdd.size() != 0) {
                throw new IllegalArgumentException("files not expected for " + extent);
            }
            for (LogEntry logEntry : logsToAdd) {
                MetadataTableUtil.addRootLogEntry(context, zooLock, logEntry);
            }
            MetadataTableUtil.removeUnusedWALEntries(context, extent, logsToRemove, zooLock);
        } else {
            Mutation m = new Mutation(extent.getMetadataEntry());
            for (LogEntry logEntry : logsToRemove) {
                m.putDelete(logEntry.getColumnFamily(), logEntry.getColumnQualifier());
            }
            for (LogEntry logEntry : logsToAdd) {
                m.put(logEntry.getColumnFamily(), logEntry.getColumnQualifier(), logEntry.getValue());
            }
            for (FileRef fileRef : filesToRemove) {
                m.putDelete(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, fileRef.meta());
            }
            for (Map.Entry entry : filesToAdd.entrySet()) {
                m.put(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, ((FileRef)entry.getKey()).meta(), new Value(((DataFileValue)entry.getValue()).encode()));
            }
            if (newDir != null) {
                MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.put(m, new Value(newDir.getBytes(StandardCharsets.UTF_8)));
            }
            MetadataTableUtil.update(context, m, extent);
        }
    }

    private static void retryZooKeeperUpdate(ClientContext context, ZooLock zooLock, ZooOperation op) {
        while (true) {
            try {
                ZooReaderWriter zoo = ZooReaderWriter.getInstance();
                if (!zoo.isLockHeld(zooLock.getLockID())) break;
                op.run((IZooReaderWriter)zoo);
            }
            catch (Exception e) {
                log.error("Unexpected exception {}", (Object)e.getMessage(), (Object)e);
                UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
                continue;
            }
            break;
        }
    }

    private static void addRootLogEntry(AccumuloServerContext context, ZooLock zooLock, final LogEntry entry) {
        MetadataTableUtil.retryZooKeeperUpdate(context, zooLock, new ZooOperation(){

            @Override
            public void run(IZooReaderWriter rw) throws KeeperException, InterruptedException, IOException {
                String root = MetadataTableUtil.getZookeeperLogLocation();
                rw.putPersistentData(root + "/" + entry.getUniqueID(), entry.toBytes(), ZooUtil.NodeExistsPolicy.OVERWRITE);
            }
        });
    }

    public static SortedMap<FileRef, DataFileValue> getDataFileSizes(KeyExtent extent, ClientContext context) throws IOException {
        TreeMap<FileRef, DataFileValue> sizes = new TreeMap<FileRef, DataFileValue>();
        try (ScannerImpl mdScanner = new ScannerImpl(context, "!0", Authorizations.EMPTY);){
            Map.Entry entry;
            mdScanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
            Text row = extent.getMetadataEntry();
            VolumeManager fs = VolumeManagerImpl.get();
            Key endKey = new Key(row, MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, new Text(""));
            endKey = endKey.followingKey(PartialKey.ROW_COLFAM);
            mdScanner.setRange(new Range(new Key(row), endKey));
            Object object = mdScanner.iterator();
            while (object.hasNext() && ((Key)(entry = (Map.Entry)object.next()).getKey()).getRow().equals((Object)row)) {
                DataFileValue dfv = new DataFileValue(((Value)entry.getValue()).get());
                sizes.put(new FileRef(fs, (Key)entry.getKey()), dfv);
            }
            object = sizes;
            return object;
        }
    }

    public static void rollBackSplit(Text metadataEntry, Text oldPrevEndRow, ClientContext context, ZooLock zooLock) {
        KeyExtent ke = new KeyExtent(metadataEntry, oldPrevEndRow);
        Mutation m = ke.getPrevRowUpdateMutation();
        MetadataSchema.TabletsSection.TabletColumnFamily.SPLIT_RATIO_COLUMN.putDelete(m);
        MetadataSchema.TabletsSection.TabletColumnFamily.OLD_PREV_ROW_COLUMN.putDelete(m);
        MetadataTableUtil.update(context, zooLock, m, new KeyExtent(metadataEntry, (Text)null));
    }

    public static void splitTablet(KeyExtent extent, Text oldPrevEndRow, double splitRatio, ClientContext context, ZooLock zooLock) {
        Mutation m = extent.getPrevRowUpdateMutation();
        MetadataSchema.TabletsSection.TabletColumnFamily.SPLIT_RATIO_COLUMN.put(m, new Value(Double.toString(splitRatio).getBytes(StandardCharsets.UTF_8)));
        MetadataSchema.TabletsSection.TabletColumnFamily.OLD_PREV_ROW_COLUMN.put(m, KeyExtent.encodePrevEndRow((Text)oldPrevEndRow));
        MetadataSchema.TabletsSection.ChoppedColumnFamily.CHOPPED_COLUMN.putDelete(m);
        MetadataTableUtil.update(context, zooLock, m, extent);
    }

    public static void finishSplit(Text metadataEntry, Map<FileRef, DataFileValue> datafileSizes, List<FileRef> highDatafilesToRemove, ClientContext context, ZooLock zooLock) {
        Mutation m = new Mutation(metadataEntry);
        MetadataSchema.TabletsSection.TabletColumnFamily.SPLIT_RATIO_COLUMN.putDelete(m);
        MetadataSchema.TabletsSection.TabletColumnFamily.OLD_PREV_ROW_COLUMN.putDelete(m);
        MetadataSchema.TabletsSection.ChoppedColumnFamily.CHOPPED_COLUMN.putDelete(m);
        for (Map.Entry<FileRef, DataFileValue> entry : datafileSizes.entrySet()) {
            m.put(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, entry.getKey().meta(), new Value(entry.getValue().encode()));
        }
        for (FileRef pathToRemove : highDatafilesToRemove) {
            m.putDelete(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, pathToRemove.meta());
        }
        MetadataTableUtil.update(context, zooLock, m, new KeyExtent(metadataEntry, (Text)null));
    }

    public static void finishSplit(KeyExtent extent, Map<FileRef, DataFileValue> datafileSizes, List<FileRef> highDatafilesToRemove, ClientContext context, ZooLock zooLock) {
        MetadataTableUtil.finishSplit(extent.getMetadataEntry(), datafileSizes, highDatafilesToRemove, context, zooLock);
    }

    public static void addDeleteEntries(KeyExtent extent, Set<FileRef> datafilesToDelete, ClientContext context) throws IOException {
        String tableId = extent.getTableId();
        for (FileRef pathToRemove : datafilesToDelete) {
            MetadataTableUtil.update(context, MetadataTableUtil.createDeleteMutation(tableId, pathToRemove.path().toString()), extent);
        }
    }

    public static void addDeleteEntry(AccumuloServerContext context, String tableId, String path) throws IOException {
        MetadataTableUtil.update(context, MetadataTableUtil.createDeleteMutation(tableId, path), new KeyExtent(tableId, null, null));
    }

    public static Mutation createDeleteMutation(String tableId, String pathToRemove) throws IOException {
        Path path = VolumeManagerImpl.get().getFullPath(tableId, pathToRemove);
        Mutation delFlag = new Mutation(new Text(MetadataSchema.DeletesSection.getRowPrefix() + path.toString()));
        delFlag.put(EMPTY_TEXT, EMPTY_TEXT, new Value(new byte[0]));
        return delFlag;
    }

    public static void removeScanFiles(KeyExtent extent, Set<FileRef> scanFiles, ClientContext context, ZooLock zooLock) {
        Mutation m = new Mutation(extent.getMetadataEntry());
        for (FileRef pathToRemove : scanFiles) {
            m.putDelete(MetadataSchema.TabletsSection.ScanFileColumnFamily.NAME, pathToRemove.meta());
        }
        MetadataTableUtil.update(context, zooLock, m, extent);
    }

    public static void splitDatafiles(String tableId, Text midRow, double splitRatio, Map<FileRef, FileUtil.FileInfo> firstAndLastRows, SortedMap<FileRef, DataFileValue> datafiles, SortedMap<FileRef, DataFileValue> lowDatafileSizes, SortedMap<FileRef, DataFileValue> highDatafileSizes, List<FileRef> highDatafilesToRemove) {
        for (Map.Entry<FileRef, DataFileValue> entry : datafiles.entrySet()) {
            long lowEntries;
            long lowSize;
            Text firstRow = null;
            Text lastRow = null;
            boolean rowsKnown = false;
            FileUtil.FileInfo mfi = firstAndLastRows.get(entry.getKey());
            if (mfi != null) {
                firstRow = mfi.getFirstRow();
                lastRow = mfi.getLastRow();
                rowsKnown = true;
            }
            if (rowsKnown && firstRow.compareTo((BinaryComparable)midRow) > 0) {
                long highSize = entry.getValue().getSize();
                long highEntries = entry.getValue().getNumEntries();
                highDatafileSizes.put(entry.getKey(), new DataFileValue(highSize, highEntries, entry.getValue().getTime()));
                continue;
            }
            if (rowsKnown && lastRow.compareTo((BinaryComparable)midRow) <= 0) {
                lowSize = entry.getValue().getSize();
                lowEntries = entry.getValue().getNumEntries();
                lowDatafileSizes.put(entry.getKey(), new DataFileValue(lowSize, lowEntries, entry.getValue().getTime()));
                highDatafilesToRemove.add(entry.getKey());
                continue;
            }
            lowSize = (long)Math.floor((double)entry.getValue().getSize() * splitRatio);
            lowEntries = (long)Math.floor((double)entry.getValue().getNumEntries() * splitRatio);
            lowDatafileSizes.put(entry.getKey(), new DataFileValue(lowSize, lowEntries, entry.getValue().getTime()));
            long highSize = (long)Math.ceil((double)entry.getValue().getSize() * (1.0 - splitRatio));
            long highEntries = (long)Math.ceil((double)entry.getValue().getNumEntries() * (1.0 - splitRatio));
            highDatafileSizes.put(entry.getKey(), new DataFileValue(highSize, highEntries, entry.getValue().getTime()));
        }
    }

    public static void deleteTable(String tableId, boolean insertDeletes, ClientContext context, ZooLock lock) throws AccumuloException, IOException {
        try (ScannerImpl ms = new ScannerImpl(context, "!0", Authorizations.EMPTY);
             BatchWriterImpl bw = new BatchWriterImpl(context, "!0", new BatchWriterConfig().setMaxMemory(1000000L).setMaxLatency(120000L, TimeUnit.MILLISECONDS).setMaxWriteThreads(2));){
            Key key;
            Mutation m = null;
            ms.setRange(new KeyExtent(tableId, null, null).toMetadataRange());
            if (insertDeletes) {
                ms.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
                MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.fetch((ScannerBase)ms);
                for (Map.Entry cell : ms) {
                    key = (Key)cell.getKey();
                    if (key.getColumnFamily().equals((Object)MetadataSchema.TabletsSection.DataFileColumnFamily.NAME)) {
                        FileRef ref = new FileRef(VolumeManagerImpl.get(), key);
                        bw.addMutation(MetadataTableUtil.createDeleteMutation(tableId, ref.meta().toString()));
                    }
                    if (!MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.hasColumns(key)) continue;
                    bw.addMutation(MetadataTableUtil.createDeleteMutation(tableId, ((Value)cell.getValue()).toString()));
                }
                bw.flush();
                ms.clearColumns();
            }
            for (Map.Entry cell : ms) {
                key = (Key)cell.getKey();
                if (m == null) {
                    m = new Mutation(key.getRow());
                    if (lock != null) {
                        MetadataTableUtil.putLockID(lock, m);
                    }
                }
                if (key.getRow().compareTo(m.getRow(), 0, m.getRow().length) != 0) {
                    bw.addMutation(m);
                    m = new Mutation(key.getRow());
                    if (lock != null) {
                        MetadataTableUtil.putLockID(lock, m);
                    }
                }
                m.putDelete(key.getColumnFamily(), key.getColumnQualifier());
            }
            if (m != null) {
                bw.addMutation(m);
            }
        }
    }

    static String getZookeeperLogLocation() {
        return ZooUtil.getRoot((Instance)HdfsZooInstance.getInstance()) + "/root_tablet/walogs";
    }

    public static void setRootTabletDir(String dir) throws IOException {
        ZooReaderWriter zoo = ZooReaderWriter.getInstance();
        String zpath = ZooUtil.getRoot((Instance)HdfsZooInstance.getInstance()) + "/root_tablet/dir";
        try {
            zoo.putPersistentData(zpath, dir.getBytes(StandardCharsets.UTF_8), -1, ZooUtil.NodeExistsPolicy.OVERWRITE);
        }
        catch (KeeperException e) {
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
    }

    public static String getRootTabletDir() throws IOException {
        ZooReaderWriter zoo = ZooReaderWriter.getInstance();
        String zpath = ZooUtil.getRoot((Instance)HdfsZooInstance.getInstance()) + "/root_tablet/dir";
        try {
            return new String(zoo.getData(zpath, null), StandardCharsets.UTF_8);
        }
        catch (KeeperException e) {
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
    }

    public static Pair<List<LogEntry>, SortedMap<FileRef, DataFileValue>> getFileAndLogEntries(ClientContext context, KeyExtent extent) throws KeeperException, InterruptedException, IOException {
        ArrayList<LogEntry> result = new ArrayList<LogEntry>();
        TreeMap<FileRef, DataFileValue> sizes = new TreeMap<FileRef, DataFileValue>();
        VolumeManager fs = VolumeManagerImpl.get();
        if (extent.isRootTablet()) {
            FileStatus[] files;
            MetadataTableUtil.getRootLogEntries(result);
            Path rootDir = new Path(MetadataTableUtil.getRootTabletDir());
            for (FileStatus fileStatus : files = fs.listStatus(rootDir)) {
                if (fileStatus.getPath().toString().endsWith("_tmp")) continue;
                DataFileValue dfv = new DataFileValue(0L, 0L);
                sizes.put(new FileRef(fileStatus.getPath().toString(), fileStatus.getPath()), dfv);
            }
        } else {
            String systemTableToCheck = extent.isMeta() ? "+r" : "!0";
            try (ScannerImpl scanner = new ScannerImpl(context, systemTableToCheck, Authorizations.EMPTY);){
                scanner.fetchColumnFamily(MetadataSchema.TabletsSection.LogColumnFamily.NAME);
                scanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
                scanner.setRange(extent.toMetadataRange());
                for (Map.Entry entry : scanner) {
                    if (!((Key)entry.getKey()).getRow().equals((Object)extent.getMetadataEntry())) {
                        throw new RuntimeException("Unexpected row " + ((Key)entry.getKey()).getRow() + " expected " + extent.getMetadataEntry());
                    }
                    if (((Key)entry.getKey()).getColumnFamily().equals((Object)MetadataSchema.TabletsSection.LogColumnFamily.NAME)) {
                        result.add(LogEntry.fromKeyValue((Key)((Key)entry.getKey()), (Value)((Value)entry.getValue())));
                        continue;
                    }
                    if (((Key)entry.getKey()).getColumnFamily().equals((Object)MetadataSchema.TabletsSection.DataFileColumnFamily.NAME)) {
                        DataFileValue dfv = new DataFileValue(((Value)entry.getValue()).get());
                        sizes.put(new FileRef(fs, (Key)entry.getKey()), dfv);
                        continue;
                    }
                    throw new RuntimeException("Unexpected col fam " + ((Key)entry.getKey()).getColumnFamily());
                }
            }
        }
        return new Pair(result, sizes);
    }

    public static List<LogEntry> getLogEntries(ClientContext context, KeyExtent extent) throws IOException, KeeperException, InterruptedException {
        log.info("Scanning logging entries for " + extent);
        ArrayList<LogEntry> result = new ArrayList<LogEntry>();
        if (extent.equals((Object)RootTable.EXTENT)) {
            log.info("Getting logs for root tablet from zookeeper");
            MetadataTableUtil.getRootLogEntries(result);
        } else {
            log.info("Scanning metadata for logs used for tablet " + extent);
            Scanner scanner = MetadataTableUtil.getTabletLogScanner(context, extent);
            Text pattern = extent.getMetadataEntry();
            for (Map.Entry entry : scanner) {
                Text row = ((Key)entry.getKey()).getRow();
                if (!((Key)entry.getKey()).getColumnFamily().equals((Object)MetadataSchema.TabletsSection.LogColumnFamily.NAME) || !row.equals((Object)pattern)) continue;
                result.add(LogEntry.fromKeyValue((Key)((Key)entry.getKey()), (Value)((Value)entry.getValue())));
            }
        }
        log.info("Returning logs " + result + " for extent " + extent);
        return result;
    }

    static void getRootLogEntries(ArrayList<LogEntry> result) throws KeeperException, InterruptedException, IOException {
        ZooReaderWriter zoo = ZooReaderWriter.getInstance();
        String root = MetadataTableUtil.getZookeeperLogLocation();
        result.clear();
        for (String child : zoo.getChildren(root)) {
            try {
                LogEntry e = LogEntry.fromBytes((byte[])zoo.getData(root + "/" + child, null));
                e = new LogEntry(RootTable.EXTENT, 0L, e.server, e.filename);
                result.add(e);
            }
            catch (KeeperException.NoNodeException ex) {}
        }
    }

    private static Scanner getTabletLogScanner(ClientContext context, KeyExtent extent) {
        String tableId = "!0";
        if (extent.isMeta()) {
            tableId = "+r";
        }
        ScannerImpl scanner = new ScannerImpl(context, tableId, Authorizations.EMPTY);
        scanner.fetchColumnFamily(MetadataSchema.TabletsSection.LogColumnFamily.NAME);
        Text start = extent.getMetadataEntry();
        Key endKey = new Key(start, MetadataSchema.TabletsSection.LogColumnFamily.NAME);
        endKey = endKey.followingKey(PartialKey.ROW_COLFAM);
        scanner.setRange(new Range(new Key(start), endKey));
        return scanner;
    }

    public static Iterator<LogEntry> getLogEntries(ClientContext context) throws IOException, KeeperException, InterruptedException {
        return new LogEntryIterator(context);
    }

    public static void removeUnusedWALEntries(AccumuloServerContext context, KeyExtent extent, final List<LogEntry> entries, ZooLock zooLock) {
        if (extent.isRootTablet()) {
            MetadataTableUtil.retryZooKeeperUpdate(context, zooLock, new ZooOperation(){

                @Override
                public void run(IZooReaderWriter rw) throws KeeperException, InterruptedException, IOException {
                    String root = MetadataTableUtil.getZookeeperLogLocation();
                    for (LogEntry entry : entries) {
                        String path = root + "/" + entry.getUniqueID();
                        log.debug("Removing " + path + " from zookeeper");
                        rw.recursiveDelete(path, ZooUtil.NodeMissingPolicy.SKIP);
                    }
                }
            });
        } else {
            Mutation m = new Mutation(extent.getMetadataEntry());
            for (LogEntry entry : entries) {
                m.putDelete(entry.getColumnFamily(), entry.getColumnQualifier());
            }
            MetadataTableUtil.update(context, zooLock, m, extent);
        }
    }

    private static void getFiles(Set<String> files, Map<Key, Value> tablet, String srcTableId) {
        for (Map.Entry<Key, Value> entry : tablet.entrySet()) {
            if (!entry.getKey().getColumnFamily().equals((Object)MetadataSchema.TabletsSection.DataFileColumnFamily.NAME)) continue;
            String cf = entry.getKey().getColumnQualifier().toString();
            if (srcTableId != null && !cf.startsWith("../") && !cf.contains(":")) {
                cf = "../" + srcTableId + entry.getKey().getColumnQualifier();
            }
            files.add(cf);
        }
    }

    private static Mutation createCloneMutation(String srcTableId, String tableId, Map<Key, Value> tablet) {
        KeyExtent ke = new KeyExtent(tablet.keySet().iterator().next().getRow(), (Text)null);
        Mutation m = new Mutation(KeyExtent.getMetadataEntry((String)tableId, (Text)ke.getEndRow()));
        for (Map.Entry<Key, Value> entry : tablet.entrySet()) {
            if (entry.getKey().getColumnFamily().equals((Object)MetadataSchema.TabletsSection.DataFileColumnFamily.NAME)) {
                String cf = entry.getKey().getColumnQualifier().toString();
                if (!cf.startsWith("../") && !cf.contains(":")) {
                    cf = "../" + srcTableId + entry.getKey().getColumnQualifier();
                }
                m.put(entry.getKey().getColumnFamily(), new Text(cf), entry.getValue());
                continue;
            }
            if (entry.getKey().getColumnFamily().equals((Object)MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME)) {
                m.put(MetadataSchema.TabletsSection.LastLocationColumnFamily.NAME, entry.getKey().getColumnQualifier(), entry.getValue());
                continue;
            }
            if (entry.getKey().getColumnFamily().equals((Object)MetadataSchema.TabletsSection.LastLocationColumnFamily.NAME)) continue;
            m.put(entry.getKey().getColumnFamily(), entry.getKey().getColumnQualifier(), entry.getValue());
        }
        return m;
    }

    private static Scanner createCloneScanner(String tableName, String tableId, Connector conn) throws TableNotFoundException {
        if (tableId.equals("!0")) {
            tableName = "accumulo.root";
        }
        IsolatedScanner mscanner = new IsolatedScanner(conn.createScanner(tableName, Authorizations.EMPTY));
        mscanner.setRange(new KeyExtent(tableId, null, null).toMetadataRange());
        mscanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
        mscanner.fetchColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
        mscanner.fetchColumnFamily(MetadataSchema.TabletsSection.LastLocationColumnFamily.NAME);
        mscanner.fetchColumnFamily(MetadataSchema.TabletsSection.ClonedColumnFamily.NAME);
        MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.fetch((ScannerBase)mscanner);
        MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.fetch((ScannerBase)mscanner);
        return mscanner;
    }

    @VisibleForTesting
    public static void initializeClone(String tableName, String srcTableId, String tableId, Connector conn, BatchWriter bw) throws TableNotFoundException, MutationsRejectedException {
        TabletIterator ti = srcTableId.equals("!0") ? new TabletIterator(MetadataTableUtil.createCloneScanner(tableName, srcTableId, conn), new Range(), true, true) : new TabletIterator(MetadataTableUtil.createCloneScanner(tableName, srcTableId, conn), new KeyExtent(srcTableId, null, null).toMetadataRange(), true, true);
        if (!ti.hasNext()) {
            throw new RuntimeException(" table deleted during clone?  srcTableId = " + srcTableId);
        }
        while (ti.hasNext()) {
            bw.addMutation(MetadataTableUtil.createCloneMutation(srcTableId, tableId, (Map<Key, Value>)ti.next()));
        }
        bw.flush();
    }

    private static int compareEndRows(Text endRow1, Text endRow2) {
        return new KeyExtent("0", endRow1, null).compareTo(new KeyExtent("0", endRow2, null));
    }

    @VisibleForTesting
    public static int checkClone(String tableName, String srcTableId, String tableId, Connector conn, BatchWriter bw) throws TableNotFoundException, MutationsRejectedException {
        TabletIterator srcIter = new TabletIterator(MetadataTableUtil.createCloneScanner(tableName, srcTableId, conn), new KeyExtent(srcTableId, null, null).toMetadataRange(), true, true);
        TabletIterator cloneIter = new TabletIterator(MetadataTableUtil.createCloneScanner(tableName, tableId, conn), new KeyExtent(tableId, null, null).toMetadataRange(), true, true);
        if (!cloneIter.hasNext() || !srcIter.hasNext()) {
            throw new RuntimeException(" table deleted during clone?  srcTableId = " + srcTableId + " tableId=" + tableId);
        }
        int rewrites = 0;
        while (cloneIter.hasNext()) {
            Mutation m;
            Object cloneTablet = cloneIter.next();
            Text cloneEndRow = new KeyExtent(((Key)cloneTablet.keySet().iterator().next()).getRow(), (Text)null).getEndRow();
            HashSet<String> cloneFiles = new HashSet<String>();
            boolean cloneSuccessful = false;
            for (Map.Entry entry : cloneTablet.entrySet()) {
                if (!((Key)entry.getKey()).getColumnFamily().equals((Object)MetadataSchema.TabletsSection.ClonedColumnFamily.NAME)) continue;
                cloneSuccessful = true;
                break;
            }
            if (!cloneSuccessful) {
                MetadataTableUtil.getFiles(cloneFiles, (Map<Key, Value>)cloneTablet, null);
            }
            ArrayList<Object> srcTablets = new ArrayList<Object>();
            Object srcTablet = srcIter.next();
            srcTablets.add(srcTablet);
            Text srcEndRow = new KeyExtent(((Key)srcTablet.keySet().iterator().next()).getRow(), (Text)null).getEndRow();
            int cmp = MetadataTableUtil.compareEndRows(cloneEndRow, srcEndRow);
            if (cmp < 0) {
                throw new TabletIterator.TabletDeletedException("Tablets deleted from src during clone : " + cloneEndRow + " " + srcEndRow);
            }
            HashSet<String> srcFiles = new HashSet<String>();
            if (!cloneSuccessful) {
                MetadataTableUtil.getFiles(srcFiles, (Map<Key, Value>)srcTablet, srcTableId);
            }
            while (cmp > 0) {
                srcTablet = srcIter.next();
                srcTablets.add(srcTablet);
                srcEndRow = new KeyExtent(((Key)srcTablet.keySet().iterator().next()).getRow(), (Text)null).getEndRow();
                cmp = MetadataTableUtil.compareEndRows(cloneEndRow, srcEndRow);
                if (cmp < 0) {
                    throw new TabletIterator.TabletDeletedException("Tablets deleted from src during clone : " + cloneEndRow + " " + srcEndRow);
                }
                if (cloneSuccessful) continue;
                MetadataTableUtil.getFiles(srcFiles, (Map<Key, Value>)srcTablet, srcTableId);
            }
            if (cloneSuccessful) continue;
            if (!srcFiles.containsAll(cloneFiles)) {
                m = new Mutation(((Key)cloneTablet.keySet().iterator().next()).getRow());
                for (Map.Entry entry : cloneTablet.entrySet()) {
                    Key k = (Key)entry.getKey();
                    m.putDelete(k.getColumnFamily(), k.getColumnQualifier(), k.getTimestamp());
                }
                bw.addMutation(m);
                for (Map map : srcTablets) {
                    bw.addMutation(MetadataTableUtil.createCloneMutation(srcTableId, tableId, map));
                }
                ++rewrites;
                continue;
            }
            m = new Mutation(((Key)cloneTablet.keySet().iterator().next()).getRow());
            m.put(MetadataSchema.TabletsSection.ClonedColumnFamily.NAME, new Text(""), new Value("OK".getBytes(StandardCharsets.UTF_8)));
            bw.addMutation(m);
        }
        bw.flush();
        return rewrites;
    }

    @SuppressModernizer
    public static void cloneTable(ClientContext context, String srcTableId, String tableId, VolumeManager volumeManager) throws Exception {
        Connector conn = context.getConnector();
        try (BatchWriter bw = conn.createBatchWriter("accumulo.metadata", new BatchWriterConfig());){
            while (true) {
                try {
                    int rewrites;
                    MetadataTableUtil.initializeClone("accumulo.metadata", srcTableId, tableId, conn, bw);
                    while ((rewrites = MetadataTableUtil.checkClone("accumulo.metadata", srcTableId, tableId, conn, bw)) != 0) {
                    }
                    bw.flush();
                }
                catch (TabletIterator.TabletDeletedException tde) {
                    bw.flush();
                    MetadataTableUtil.deleteTable(tableId, false, context, null);
                    log.debug("Tablets merged in table " + srcTableId + " while attempting to clone, trying again");
                    UtilWaitThread.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
                    continue;
                }
                break;
            }
            Scanner mscanner = conn.createScanner("accumulo.metadata", Authorizations.EMPTY);
            mscanner.setRange(new KeyExtent(tableId, null, null).toMetadataRange());
            mscanner.fetchColumnFamily(MetadataSchema.TabletsSection.ClonedColumnFamily.NAME);
            int dirCount = 0;
            for (Map.Entry entry : mscanner) {
                Key k = (Key)entry.getKey();
                Mutation m = new Mutation(k.getRow());
                m.putDelete(k.getColumnFamily(), k.getColumnQualifier());
                String dir = volumeManager.choose((Optional<String>)Optional.of((Object)tableId), ServerConstants.getBaseUris()) + "/tables" + "/" + tableId + "/" + new String(FastFormat.toZeroPaddedString((long)dirCount++, (int)8, (int)16, (byte[])Constants.CLONE_PREFIX_BYTES));
                MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.put(m, new Value(dir.getBytes(StandardCharsets.UTF_8)));
                bw.addMutation(m);
            }
        }
    }

    public static void chopped(AccumuloServerContext context, KeyExtent extent, ZooLock zooLock) {
        Mutation m = new Mutation(extent.getMetadataEntry());
        MetadataSchema.TabletsSection.ChoppedColumnFamily.CHOPPED_COLUMN.put(m, new Value("chopped".getBytes(StandardCharsets.UTF_8)));
        MetadataTableUtil.update(context, zooLock, m, extent);
    }

    public static void removeBulkLoadEntries(Connector conn, String tableId, long tid) throws Exception {
        try (IsolatedScanner mscanner = new IsolatedScanner(conn.createScanner("accumulo.metadata", Authorizations.EMPTY));
             BatchWriter bw = conn.createBatchWriter("accumulo.metadata", new BatchWriterConfig());){
            mscanner.setRange(new KeyExtent(tableId, null, null).toMetadataRange());
            mscanner.fetchColumnFamily(MetadataSchema.TabletsSection.BulkFileColumnFamily.NAME);
            byte[] tidAsBytes = Long.toString(tid).getBytes(StandardCharsets.UTF_8);
            for (Map.Entry entry : mscanner) {
                log.trace("Looking at entry {} with tid {}", (Object)entry, (Object)tid);
                if (!Arrays.equals(((Value)entry.getValue()).get(), tidAsBytes)) continue;
                log.trace("deleting entry {}", (Object)entry);
                Key key = (Key)entry.getKey();
                Mutation m = new Mutation(key.getRow());
                m.putDelete(key.getColumnFamily(), key.getColumnQualifier());
                bw.addMutation(m);
            }
        }
    }

    public static List<FileRef> getBulkFilesLoaded(Connector conn, KeyExtent extent, long tid) throws IOException {
        ArrayList<FileRef> arrayList;
        ArrayList<FileRef> result = new ArrayList<FileRef>();
        IsolatedScanner mscanner = new IsolatedScanner(conn.createScanner(extent.isMeta() ? "accumulo.root" : "accumulo.metadata", Authorizations.EMPTY));
        try {
            VolumeManager fs = VolumeManagerImpl.get();
            mscanner.setRange(extent.toMetadataRange());
            mscanner.fetchColumnFamily(MetadataSchema.TabletsSection.BulkFileColumnFamily.NAME);
            for (Map.Entry entry : mscanner) {
                if (Long.parseLong(((Value)entry.getValue()).toString()) != tid) continue;
                result.add(new FileRef(fs, (Key)entry.getKey()));
            }
            arrayList = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    mscanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (TableNotFoundException ex) {
                throw new RuntimeException("Onos! teh metadata table has vanished!!");
            }
        }
        mscanner.close();
        return arrayList;
    }

    public static Map<Long, ? extends Collection<FileRef>> getBulkFilesLoaded(ClientContext context, KeyExtent extent) throws IOException {
        Text metadataRow = extent.getMetadataEntry();
        HashMap<Long, ArrayList<FileRef>> result = new HashMap<Long, ArrayList<FileRef>>();
        VolumeManager fs = VolumeManagerImpl.get();
        try (ScannerImpl scanner = new ScannerImpl(context, extent.isMeta() ? "+r" : "!0", Authorizations.EMPTY);){
            scanner.setRange(new Range(metadataRow));
            scanner.fetchColumnFamily(MetadataSchema.TabletsSection.BulkFileColumnFamily.NAME);
            for (Map.Entry entry : scanner) {
                Long tid = Long.parseLong(((Value)entry.getValue()).toString());
                ArrayList<FileRef> lst = (ArrayList<FileRef>)result.get(tid);
                if (lst == null) {
                    lst = new ArrayList<FileRef>();
                    result.put(tid, lst);
                }
                lst.add(new FileRef(fs, (Key)entry.getKey()));
            }
        }
        return result;
    }

    public static void addBulkLoadInProgressFlag(AccumuloServerContext context, String path) {
        Mutation m = new Mutation((CharSequence)(MetadataSchema.BlipSection.getRowPrefix() + path));
        m.put(EMPTY_TEXT, EMPTY_TEXT, new Value(new byte[0]));
        MetadataTableUtil.update(context, m, new KeyExtent("anythingNotMetadata", null, null));
    }

    public static void removeBulkLoadInProgressFlag(AccumuloServerContext context, String path) {
        Mutation m = new Mutation((CharSequence)(MetadataSchema.BlipSection.getRowPrefix() + path));
        m.putDelete(EMPTY_TEXT, EMPTY_TEXT);
        MetadataTableUtil.update(context, m, new KeyExtent("anythingNotMetadata", null, null));
    }

    @SuppressModernizer
    public static void createReplicationTable(ClientContext context) throws IOException {
        String dir = VolumeManagerImpl.get().choose((Optional<String>)Optional.of((Object)"+rep"), ServerConstants.getBaseUris()) + "/tables" + "/" + "+rep" + "/default_tablet";
        Mutation m = new Mutation(new Text(KeyExtent.getMetadataEntry((String)"+rep", null)));
        m.put(MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.getColumnFamily(), MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.getColumnQualifier(), 0L, new Value(dir.getBytes(StandardCharsets.UTF_8)));
        m.put(MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.getColumnFamily(), MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.getColumnQualifier(), 0L, new Value("L0".getBytes(StandardCharsets.UTF_8)));
        m.put(MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.getColumnFamily(), MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.getColumnQualifier(), 0L, KeyExtent.encodePrevEndRow(null));
        MetadataTableUtil.update(MetadataTableUtil.getMetadataTable(context), null, m);
    }

    public static void moveMetaDeleteMarkers(ClientContext context) {
        String oldDeletesPrefix = "!!~del";
        Range oldDeletesRange = new Range((CharSequence)oldDeletesPrefix, true, (CharSequence)"!!~dem", false);
        try (ScannerImpl scanner = new ScannerImpl(context, "+r", Authorizations.EMPTY);){
            Map.Entry entry;
            String row;
            scanner.setRange(oldDeletesRange);
            Iterator iterator = scanner.iterator();
            while (iterator.hasNext() && (row = ((Key)(entry = (Map.Entry)iterator.next()).getKey()).getRow().toString()).startsWith(oldDeletesPrefix)) {
                MetadataTableUtil.moveDeleteEntry(context, RootTable.OLD_EXTENT, entry, row, oldDeletesPrefix);
            }
        }
    }

    public static void moveMetaDeleteMarkersFrom14(ClientContext context) {
        KeyExtent notMetadata = new KeyExtent("anythingNotMetadata", null, null);
        try (ScannerImpl scanner = new ScannerImpl(context, "!0", Authorizations.EMPTY);){
            Map.Entry entry;
            String row;
            scanner.setRange(MetadataSchema.DeletesSection.getRange());
            Iterator iterator = scanner.iterator();
            while (iterator.hasNext() && (row = ((Key)(entry = (Map.Entry)iterator.next()).getKey()).getRow().toString()).startsWith(MetadataSchema.DeletesSection.getRowPrefix() + "/" + "!0")) {
                MetadataTableUtil.moveDeleteEntry(context, notMetadata, entry, row, MetadataSchema.DeletesSection.getRowPrefix());
            }
        }
    }

    private static void moveDeleteEntry(ClientContext context, KeyExtent oldExtent, Map.Entry<Key, Value> entry, String rowID, String prefix) {
        String filename = rowID.substring(prefix.length());
        log.info("Moving " + filename + " marker in " + "accumulo.root");
        Mutation m = new Mutation((CharSequence)(MetadataSchema.DeletesSection.getRowPrefix() + filename));
        m.put(EMPTY_BYTES, EMPTY_BYTES, EMPTY_BYTES);
        MetadataTableUtil.update(context, m, RootTable.EXTENT);
        m = new Mutation(entry.getKey().getRow());
        m.putDelete(EMPTY_BYTES, EMPTY_BYTES);
        MetadataTableUtil.update(context, m, oldExtent);
    }

    public static SortedMap<Text, SortedMap<ColumnFQ, Value>> getTabletEntries(SortedMap<Key, Value> tabletKeyValues, List<ColumnFQ> columns) {
        TreeMap<Text, SortedMap<ColumnFQ, Value>> tabletEntries = new TreeMap<Text, SortedMap<ColumnFQ, Value>>();
        HashSet<ColumnFQ> colSet = null;
        if (columns != null) {
            colSet = new HashSet<ColumnFQ>(columns);
        }
        for (Map.Entry<Key, Value> entry : tabletKeyValues.entrySet()) {
            ColumnFQ currentKey = new ColumnFQ(entry.getKey());
            if (columns != null && !colSet.contains(currentKey)) continue;
            Text row = entry.getKey().getRow();
            SortedMap<ColumnFQ, Value> colVals = tabletEntries.get(row);
            if (colVals == null) {
                colVals = new TreeMap<ColumnFQ, Value>();
                tabletEntries.put(row, colVals);
            }
            colVals.put(currentKey, entry.getValue());
        }
        return tabletEntries;
    }

    private static class LogEntryIterator
    implements Iterator<LogEntry> {
        Iterator<LogEntry> zookeeperEntries = null;
        Iterator<LogEntry> rootTableEntries = null;
        Iterator<Map.Entry<Key, Value>> metadataEntries = null;

        LogEntryIterator(ClientContext context) throws IOException, KeeperException, InterruptedException {
            this.zookeeperEntries = MetadataTableUtil.getLogEntries(context, RootTable.EXTENT).iterator();
            this.rootTableEntries = MetadataTableUtil.getLogEntries(context, new KeyExtent("!0", null, null)).iterator();
            try {
                Scanner scanner = context.getConnector().createScanner("accumulo.metadata", Authorizations.EMPTY);
                log.info("Setting range to " + MetadataSchema.TabletsSection.getRange());
                scanner.setRange(MetadataSchema.TabletsSection.getRange());
                scanner.fetchColumnFamily(MetadataSchema.TabletsSection.LogColumnFamily.NAME);
                this.metadataEntries = scanner.iterator();
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }

        @Override
        public boolean hasNext() {
            return this.zookeeperEntries.hasNext() || this.rootTableEntries.hasNext() || this.metadataEntries.hasNext();
        }

        @Override
        public LogEntry next() {
            if (this.zookeeperEntries.hasNext()) {
                return this.zookeeperEntries.next();
            }
            if (this.rootTableEntries.hasNext()) {
                return this.rootTableEntries.next();
            }
            Map.Entry<Key, Value> entry = this.metadataEntries.next();
            return LogEntry.fromKeyValue((Key)entry.getKey(), (Value)entry.getValue());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static interface ZooOperation {
        public void run(IZooReaderWriter var1) throws KeeperException, InterruptedException, IOException;
    }
}

