/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.fs;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.conf.ServerConfigurationFactory;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.fs.RandomVolumeChooser;
import org.apache.accumulo.server.fs.VolumeChooser;
import org.apache.accumulo.server.fs.VolumeChooserEnvironment;

public class PerTableVolumeChooser
implements VolumeChooser {
    private final VolumeChooser fallbackVolumeChooser = new RandomVolumeChooser();
    private final ConcurrentHashMap<String, VolumeChooser> tableSpecificChooser = new ConcurrentHashMap();
    private volatile ServerConfigurationFactory serverConfs;

    @Override
    public String choose(VolumeChooserEnvironment env, String[] options) {
        VolumeChooser chooser = null;
        if (env.hasTableId()) {
            ServerConfigurationFactory localConf = this.serverConfs;
            if (localConf == null) {
                this.serverConfs = localConf = new ServerConfigurationFactory(HdfsZooInstance.getInstance());
            }
            TableConfiguration tableConf = localConf.getTableConfiguration(env.getTableId());
            chooser = this.tableSpecificChooser.get(env.getTableId());
            if (chooser == null) {
                VolumeChooser temp = (VolumeChooser)Property.createTableInstanceFromPropertyName((AccumuloConfiguration)tableConf, (Property)Property.TABLE_VOLUME_CHOOSER, VolumeChooser.class, (Object)this.fallbackVolumeChooser);
                chooser = this.tableSpecificChooser.putIfAbsent(env.getTableId(), temp);
                if (chooser == null) {
                    chooser = temp;
                }
            } else if (!chooser.getClass().getName().equals(tableConf.get(Property.TABLE_VOLUME_CHOOSER))) {
                VolumeChooser temp = (VolumeChooser)Property.createTableInstanceFromPropertyName((AccumuloConfiguration)tableConf, (Property)Property.TABLE_VOLUME_CHOOSER, VolumeChooser.class, (Object)this.fallbackVolumeChooser);
                VolumeChooser last = this.tableSpecificChooser.replace(env.getTableId(), temp);
                chooser = chooser.equals(last) ? temp : last;
            }
        } else {
            chooser = this.fallbackVolumeChooser;
        }
        return chooser.choose(env, options);
    }
}

